/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.extendbill;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.ContractExtendStatusEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.CfmSecondFieldDevHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ExtendBillSaveService
extends AbstractTmcBizOppService {
    private static final String[] selectProperties = new String[]{"id", "billno", "currency", "amount", "bizdate", "loanrate", "expiredate", "repayamount", "notrepayamount", "renewalexpiredate", "exrateadjustdate"};

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("sourcebillid");
        sic.add("billstatus");
        sic.add("auditor");
        sic.add("auditdate");
        sic.add("protocolno");
        sic.add("bizdate");
        sic.add("renewalinteresttype");
        sic.add("renewalinterestrate");
        sic.add("ratetype");
        sic.add("ratedeadline");
        sic.add("ratesign");
        sic.add("ratefloatpoint");
        sic.add("rateadjuststyle");
        sic.add("rateadjustcycle");
        sic.add("exrateadjustdate");
        sic.add("datasource");
        sic.add("org");
        sic.add("creditorg");
        sic.add("creditor");
        sic.add("creditortype");
        sic.add("registorg");
        sic.add("debtor");
        sic.add("debtortype");
        sic.add("textdebtor");
        sic.add("textcreditor");
        sic.add("productfactory");
        sic.add("renewalexpiredate");
        sic.add("enddate");
        sic.add("prevrenewalexpiredate");
        sic.add("startdate");
        sic.add("lendernature");
        sic.add("loantype");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        CfmBillCommonHelper.setNeedSaveFieldValue((DynamicObject[])dataEntities);
        if ("true".equals(this.operationVariable.get("byInit"))) {
            this.doByInitOnProcess(dataEntities);
        } else {
            for (DynamicObject extendBill : dataEntities) {
                CfmSecondFieldDevHelper.dealTarBillSecondDev((DynamicObject)extendBill, (Map)this.operationVariable);
                DynamicObject contractBill = TmcDataServiceHelper.loadSingle((Object)extendBill.get("sourcebillid"), (String)"cfm_loancontractbill", (String)"extendstatus");
                if (!EmptyUtil.isNoEmpty((DynamicObject)contractBill)) continue;
                contractBill.set("extendstatus", (Object)ContractExtendStatusEnum.SAVE.getValue());
                TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{contractBill});
            }
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        if ("true".equals(this.operationVariable.get("byInit"))) {
            for (DynamicObject extend : dataEntities) {
                BusinessHelper.fillConfirmInfo((DynamicObject)extend);
            }
        }
    }

    private void doByInitOnProcess(DynamicObject[] dataEntities) {
        for (DynamicObject extend : dataEntities) {
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(extend.getString("datasource"));
            extend.set("confirmstatus", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
            extend.set("confirmer", (Object)RequestContext.get().getCurrUserId());
            extend.set("confirmtime", (Object)DateUtils.getCurrentTime());
            extend.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            extend.set("auditor", (Object)RequestContext.get().getCurrUserId());
            extend.set("auditdate", (Object)DateUtils.getCurrentTime());
            String mainOrg = ((MainEntityType)extend.getDataEntityType()).getMainOrg();
            String codeNumber = CodeRuleHelper.generateNumber((String)extend.getDynamicObjectType().getName(), (DynamicObject)extend, (String)extend.getDynamicObject(mainOrg).getPkValue().toString(), (String)"");
            if (StringUtils.isEmpty((CharSequence)codeNumber)) {
                throw new KDBizException(bizResource.getInbEndinitNoebill());
            }
            extend.set("billno", (Object)codeNumber);
            extend.set("protocolno", this.operationVariable.get("protocolno"));
            extend.set("bizdate", (Object)this.getDatePro("renewaldate"));
            extend.set("renewalexpiredate", (Object)this.getDatePro("renewalexpiredate"));
            extend.set("renewalinteresttype", this.operationVariable.get("renewalinteresttype"));
            extend.set("renewalinterestrate", (Object)this.getBigDecimalPro("renewalinterestrate"));
            extend.set("isadjustinterestrate", (Object)"1");
            extend.set("isinit", (Object)"1");
            String interestType = (String)this.operationVariable.get("renewalinteresttype");
            if (InterestTypeEnum.FIXED.getValue().equals(interestType)) {
                extend.set("renewalinterestrate", (Object)this.getBigDecimalPro("renewalinterestrate"));
            }
            if (InterestTypeEnum.FLOAT.getValue().equals(interestType)) {
                Long referenceRateId = Long.valueOf((String)this.operationVariable.get("exreferencerate"));
                if (EmptyUtil.isNoEmpty((Long)referenceRateId)) {
                    extend.set("referencerate", (Object)BusinessDataServiceHelper.loadSingle((Object)referenceRateId, (String)"tbd_referrate", (String)"id"));
                }
                extend.set("ratesign", this.operationVariable.get("exratesign"));
                extend.set("ratefloatpoint", (Object)this.getBigDecimalPro("exratefloatpoint"));
                String loanrateadjuststyle = (String)this.operationVariable.get("exrateadjuststyle");
                extend.set("rateadjuststyle", (Object)loanrateadjuststyle);
                if (RateAdjustStyleEnum.CYCLE.getValue().equals(loanrateadjuststyle)) {
                    extend.set("rateadjustcycletype", this.operationVariable.get("exrateadjustcycletype"));
                    extend.set("rateadjustcycle", (Object)this.getBigDecimalPro("exrateadjustcycle"));
                }
            }
            this.fillLines(extend);
        }
    }

    private void fillLines(DynamicObject extend) {
        Long contractId = Long.valueOf((String)this.operationVariable.get("contractId"));
        QFilter contractFilter = new QFilter("sourcebillid", "=", (Object)contractId);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter drawStatusFilter = new QFilter("drawtype", "in", (Object)new String[]{DrawTypeEnum.DRAWED.getValue(), DrawTypeEnum.PARTPAYMENT.getValue()});
        DynamicObjectCollection loadBills = QueryServiceHelper.query((String)"cfm_loanbill", (String)String.join((CharSequence)",", selectProperties), (QFilter[])new QFilter[]{contractFilter, statusFilter, drawStatusFilter});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)loadBills)) {
            return;
        }
        DynamicObjectCollection dbLines = extend.getDynamicObjectCollection("loanbilllist");
        int seq = 1;
        for (DynamicObject loanBill : loadBills) {
            DynamicObject line = dbLines.addNew();
            line.set("seq", (Object)seq++);
            line.set("drawbillid", loanBill.get("id"));
            line.set("drawbillno", loanBill.get("billno"));
            line.set("drawcurrency", loanBill.get("currency"));
            line.set("ldrawamount", loanBill.get("amount"));
            line.set("loandate", loanBill.get("bizdate"));
            line.set("loanrate", loanBill.get("loanrate"));
            line.set("expiredate", loanBill.get("expiredate"));
            line.set("repayamount", loanBill.get("repayamount"));
            line.set("lnotrepayamount", loanBill.get("notrepayamount"));
            if (EmptyUtil.isNoEmpty((Object)loanBill.get("renewalexpiredate"))) {
                line.set("e_prevrenewalexpiredate", loanBill.get("expiredate"));
                line.set("lrenewalexpiredate", loanBill.get("renewalexpiredate"));
                line.set("isrenewal", (Object)"1");
                line.set("extendamount", loanBill.get("notrepayamount"));
                line.set("exrateadjustdate", loanBill.get("exrateadjustdate"));
                continue;
            }
            line.set("isrenewal", (Object)"0");
            line.set("extendamount", (Object)0);
        }
    }

    private BigDecimal getBigDecimalPro(String pro) {
        return new BigDecimal((String)this.operationVariable.get(pro));
    }

    private Date getDatePro(String pro) {
        if (EmptyUtil.isEmpty((String)((String)this.operationVariable.get(pro)))) {
            return null;
        }
        return DateUtils.stringToDate((String)((String)this.operationVariable.get(pro)), (String)"yyyyMMdd");
    }
}

