/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.extendbill;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.enums.ApplyBusinessStatusEnum;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.ExtendHelper;
import kd.tmc.cfm.common.helper.LoanWriteBackHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;

public class ExtendBillUnConfirmService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("sourcebillid");
        sic.add("loanbilllist");
        sic.add("loanbilllist.drawbillid");
        sic.add("loanbilllist.lrenewalexpiredate");
        sic.add("loanbilllist.isrenewal");
        sic.add("confirmstatus");
        sic.add("confirmer");
        sic.add("confirmtime");
        sic.add("productfactory");
        sic.add("renewalexpiredate");
        sic.add("enddate");
        sic.add("prevrenewalexpiredate");
        sic.add("startdate");
        sic.add("lendernature");
        sic.add("loantype");
        sic.add("extendapplyf7");
        sic.add("creditortype");
        sic.add("debtortype");
        sic.add("debtor");
        sic.add("textdebtor");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject extendBill : dataEntities) {
            BusinessHelper.clearConfirmInfo((DynamicObject)extendBill);
            ExtendHelper.undoExtend((DynamicObject)extendBill);
            CfmBillCommonHelper.updateApplyBizStatus((DynamicObject)extendBill, (String)"extendapplyf7", (String)"cfm_extendapplybill", (String)ApplyBusinessStatusEnum.HANDING.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        HashSet loanBillIds = new HashSet(dataEntities.length);
        for (DynamicObject extendBill : dataEntities) {
            loanBillIds.addAll(extendBill.getDynamicObjectCollection("loanbilllist").stream().filter(d -> d.getBoolean("isrenewal")).map(d -> d.getLong("drawbillid")).collect(Collectors.toSet()));
        }
        if (!loanBillIds.isEmpty()) {
            LoanWriteBackHelper.writeBack(new ArrayList(loanBillIds), (LoanWBTypeEnum)LoanWBTypeEnum.EXTEND);
        }
    }
}

