/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.initbill;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.tmc.cfm.common.bean.RepayPlanBean;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.ContractExtendStatusEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.InitStatusEnum;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.enums.OverRateTypeEnum;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.cfm.common.enums.SettleCenterStatusEnum;
import kd.tmc.cfm.common.helper.CfmBillSDKHelper;
import kd.tmc.cfm.common.helper.EntityPropertyHelper;
import kd.tmc.cfm.common.helper.InitBillHelper;
import kd.tmc.cfm.common.helper.LoanWriteBackHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.IntCalMethodEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.RateSignEnum;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.MarketDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcAppCache;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.model.guaranteeuse.GuaranteeUseBean;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InitBillendInitService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(InitBillendInitService.class);

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.addAll(EntityPropertyHelper.getPropertys((String)"ifm_initbill"));
        sic.add("loanentry");
        sic.addAll(EntityPropertyHelper.getEntryPropertys((String)"cfm_initbill", (String)"loanentry"));
        sic.add("repaysubentry");
        sic.add("exrepaymentdate");
        sic.add("exdrawamount");
        sic.add("repaymentdesc");
        sic.add("confirmstatus");
        sic.add("confirmer");
        sic.add("confirmtime");
        sic.add("textdebtor");
        sic.add("datasource");
        sic.add("registorg");
        sic.add("feedetail");
        sic.add("feescheme");
        sic.add("feetype");
        sic.add("feecurrency");
        sic.add("feeamt");
        sic.add("feepaydate");
        sic.add("feerate");
        sic.add("feesettletype");
        sic.add("feeacctbank");
        sic.add("feeoppunittype");
        sic.add("feeoppunit");
        sic.add("feeoppunittext");
        sic.add("feeoppacctbank");
        sic.add("feeoppbebank");
        sic.add("feesource");
        sic.add("feeissettle");
        sic.add("feeremark");
        sic.add("excrate");
        sic.add("loan_feedetail");
        sic.add("lfeescheme");
        sic.add("lfeetype");
        sic.add("lfeecurrency");
        sic.add("lfeeamt");
        sic.add("lfeepaydate");
        sic.add("lfeerate");
        sic.add("lfeesettletype");
        sic.add("lfeeacctbank");
        sic.add("lfeeoppunittype");
        sic.add("lfeeoppunit");
        sic.add("lfeeoppunittext");
        sic.add("lfeeoppacctbank");
        sic.add("lfeeoppbebank");
        sic.add("lfeesource");
        sic.add("lfeeissettle");
        sic.add("lfeeremark");
        sic.add("lexcrate");
        sic.add("banksyndicate_entry");
        sic.add("e_bankrole");
        sic.add("e_bank");
        sic.add("e_shareamount");
        sic.add("e_bankdescription");
        sic.add("e_creditlimit");
        sic.add("bankentryid");
        sic.add("project_entry");
        sic.add("e_project");
        sic.add("e_projdescription");
        sic.add("tradefin_entry");
        sic.add("e_tf_relationtype");
        sic.add("e_tf_relatebillno");
        sic.add("e_tf_beneficiary");
        sic.add("e_tf_expiredate");
        sic.add("e_tf_description");
        sic.add("e_tf_unpaidamount");
        sic.add("e_tf_currency");
        sic.add("e_tf_letter");
        sic.add("e_tf_relatebillid");
        sic.add("supplychainfin_entry");
        sic.add("e_sc_coreenterprise");
        sic.add("e_sc_relationtype");
        sic.add("e_sc_orderno");
        sic.add("e_sc_executedate");
        sic.add("e_sc_description");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject initBill : dataEntities) {
            initBill.set("initstatus", (Object)InitStatusEnum.INITED.getValue());
            initBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            logger.info(" 1: \u751f\u6210\u5408\u540c\u5e76\u4e14\u4fdd\u5b58\u5165\u5e93.");
            DynamicObject contractBill = this.genContractBill(initBill);
            logger.info(" 2: \u751f\u6210\u63d0\u6b3e.");
            DynamicObjectCollection loans = initBill.getDynamicObjectCollection("loanentry");
            if (!EmptyUtil.isEmpty((DynamicObjectCollection)loans)) {
                this.genLoanBills(initBill, contractBill, loans);
            }
            if (!"ifm_initbill".equals(initBill.getDataEntityType().getName())) {
                logger.info("3: \u751f\u6210\u5c55\u671f.");
                this.genExtendBill(initBill, contractBill, loans);
            }
            if (EmptyUtil.isEmpty((DynamicObjectCollection)loans)) continue;
            logger.info("4. \u8c03\u7528\u7edf\u4e00\u7684writeBack\u65b9\u6cd5.");
            this.writeBack(contractBill);
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    private void writeBack(DynamicObject contractBill) {
        Long contractId = (Long)contractBill.getPkValue();
        QFilter contractFilter = new QFilter("sourcebillid", "=", (Object)contractId);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter drawStatusFilter = new QFilter("drawtype", "in", (Object)new String[]{DrawTypeEnum.DRAWED.getValue(), DrawTypeEnum.PARTPAYMENT.getValue()});
        List loanBillIds = QueryServiceHelper.queryPrimaryKeys((String)"cfm_loanbill", (QFilter[])new QFilter[]{contractFilter, statusFilter, drawStatusFilter}, null, (int)-1);
        if (EmptyUtil.isNoEmpty((Object)loanBillIds)) {
            LoanWriteBackHelper.writeBack(loanBillIds.stream().map(d -> (Long)d).collect(Collectors.toList()), (LoanWBTypeEnum)LoanWBTypeEnum.REPAYMENT);
        }
    }

    private void genExtendBill(DynamicObject initBill, DynamicObject contractBill, DynamicObjectCollection loans) {
        if (!initBill.getBoolean("isextend")) {
            return;
        }
        String entityName = initBill.getDataEntityType().getName();
        String extendBill = "cfm_contractextendbill";
        if ("cim_invest_initbill".equals(entityName)) {
            extendBill = "cim_invest_extendbill";
        }
        DynamicObject[] extendBills = TmcBotpHelper.push((DynamicObject)contractBill, (String)extendBill);
        OperateOption create = OperateOption.create();
        create.setVariableValue("byInit", "true");
        create.setVariableValue("contractId", contractBill.getPkValue().toString());
        create.setVariableValue("protocolno", initBill.getString("protocolno"));
        create.setVariableValue("renewaldate", this.getDatePro(initBill, "renewaldate"));
        create.setVariableValue("renewalexpiredate", this.getDatePro(initBill, "renewalexpiredate"));
        create.setVariableValue("renewalinteresttype", initBill.getString("renewalinteresttype"));
        create.setVariableValue("renewalinterestrate", String.valueOf(initBill.getBigDecimal("renewalinterestrate")));
        create.setVariableValue("initid", String.valueOf(initBill.getPkValue()));
        if (InterestTypeEnum.FLOAT.getValue().equals(initBill.getString("renewalinteresttype"))) {
            create.setVariableValue("exreferencerate", String.valueOf(initBill.getDynamicObject("exreferencerate").getPkValue()));
            create.setVariableValue("exratesign", String.valueOf(initBill.getString("exratesign")));
            create.setVariableValue("exratefloatpoint", String.valueOf(initBill.get("exratefloatpoint")));
            create.setVariableValue("exrateadjuststyle", String.valueOf(initBill.getString("exrateadjuststyle")));
            if (RateAdjustStyleEnum.CYCLE.getValue().equals(initBill.getString("exrateadjuststyle"))) {
                create.setVariableValue("exrateadjustcycletype", String.valueOf(initBill.get("exrateadjustcycletype")));
                create.setVariableValue("exrateadjustcycle", String.valueOf(initBill.get("exrateadjustcycle")));
            }
        }
        try {
            OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"save", (String)extendBill, (DynamicObject[])extendBills, (OperateOption)create);
            if (EmptyUtil.isEmpty((Collection)operationResult.getSuccessPkIds())) {
                throw new KDBizException(String.join((CharSequence)";", ((OperateErrorInfo)((ValidateResult)operationResult.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage()));
            }
            Object[] extendIds = operationResult.getSuccessPkIds().toArray();
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("WF", "TRUE");
            operationResult = TmcOperateServiceHelper.execOperate((String)"submit", (String)extendBill, (Object[])extendIds, (OperateOption)operateOption);
            if (EmptyUtil.isEmpty((Collection)operationResult.getSuccessPkIds())) {
                throw new KDBizException(String.join((CharSequence)";", ((OperateErrorInfo)((ValidateResult)operationResult.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage()));
            }
            extendIds = operationResult.getSuccessPkIds().toArray();
            TmcOperateServiceHelper.execOperate((String)"audit", (String)extendBill, (Object[])extendIds, (OperateOption)OperateOption.create());
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u5c55\u671f\u5355\u636e\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
            throw e;
        }
    }

    private void genLoanBills(DynamicObject initBill, DynamicObject contractBill, DynamicObjectCollection loanBills) {
        for (DynamicObject loan : loanBills) {
            OperateOption create = OperateOption.create();
            create.setVariableValue("byInit", "true");
            create.setVariableValue("loanbillid", String.valueOf(loan.getLong("loanbillid")));
            create.setVariableValue("loanbillno", loan.getString("loanbillno"));
            create.setVariableValue("datasource", initBill.getString("datasource"));
            create.setVariableValue("drawamount", String.valueOf(loan.getBigDecimal("drawamount")));
            create.setVariableValue("loaddate", this.getDatePro(loan, "loaddate"));
            create.setVariableValue("receivedate", this.getDatePro(loan, "receivedate"));
            create.setVariableValue("startinstdate", this.getDatePro(loan, "startinstdate"));
            create.setVariableValue("loanterm", loan.getString("loanterm"));
            create.setVariableValue("expiredate", this.getDatePro(loan, "expiredate"));
            create.setVariableValue("loanrate", String.valueOf(loan.getBigDecimal("loanrate")));
            create.setVariableValue("loadacctbank", loan.getDynamicObject("loadacctbank").getPkValue().toString());
            if (!"ifm_initbill".equals(initBill.getDataEntityType().getName())) {
                create.setVariableValue("creditamount", String.valueOf(loan.getBigDecimal("creditamount")));
                DynamicObject creditLimit = loan.getDynamicObject("creditlimit");
                if (creditLimit != null) {
                    create.setVariableValue("creditlimit", creditLimit.getPkValue().toString());
                }
            }
            create.setVariableValue("repayamount", String.valueOf(loan.getBigDecimal("repayamount")));
            create.setVariableValue("repaydate", this.getDatePro(loan, "repaydate"));
            create.setVariableValue("payinterestamount", String.valueOf(loan.getBigDecimal("payinterestamount")));
            create.setVariableValue("endinstdate", this.getDatePro(loan, "endinstdate"));
            create.setVariableValue("endpreinstdate", this.getDatePro(loan, "endpreinstdate"));
            create.setVariableValue("initid", String.valueOf(initBill.getPkValue()));
            create.setVariableValue("isunifyloanreturn", String.valueOf(loan.getBoolean("isunifyloanreturn")));
            if (InterestTypeEnum.FLOAT.getValue().equals(contractBill.getString("interesttype"))) {
                create.setVariableValue("interesttype", InterestTypeEnum.FLOAT.getValue());
                create.setVariableValue("referencerate", initBill.getDynamicObject("referencerate").getPkValue().toString());
                create.setVariableValue("loanratesign", String.valueOf(loan.getString("loanratesign")));
                create.setVariableValue("loanratefloatpoint", String.valueOf(loan.get("loanratefloatpoint")));
                if ("ifm_initbill".equals(initBill.getDataEntityType().getName())) {
                    create.setVariableValue("loanrateadjuststyle", String.valueOf(initBill.getString("rateadjuststyle")));
                    if (RateAdjustStyleEnum.CYCLE.getValue().equals(initBill.getString("rateadjuststyle"))) {
                        create.setVariableValue("loanrateadjustdate", this.getDatePro(initBill, "rateadjustdate"));
                        create.setVariableValue("loanrateadjusttype", String.valueOf(initBill.get("rateadjustcycletype")));
                        create.setVariableValue("loanrateadjustcycle", String.valueOf(initBill.get("rateadjustcycle")));
                    }
                } else {
                    create.setVariableValue("loanrateadjuststyle", String.valueOf(loan.getString("loanrateadjuststyle")));
                    if (RateAdjustStyleEnum.CYCLE.getValue().equals(loan.getString("loanrateadjuststyle"))) {
                        create.setVariableValue("loanrateadjustdate", this.getDatePro(loan, "loanrateadjustdate"));
                        create.setVariableValue("loanrateadjusttype", String.valueOf(loan.get("loanrateadjusttype")));
                        create.setVariableValue("loanrateadjustcycle", String.valueOf(loan.get("loanrateadjustcycle")));
                    }
                }
            }
            if (contractBill.getBoolean("isextend")) {
                create.setVariableValue("loanexpiredate", this.getDatePro(loan, "loanexpiredate"));
                create.setVariableValue("extrateajustdate", this.getDatePro(loan, "extrateajustdate"));
                create.setVariableValue("renewalinterestrate", String.valueOf(initBill.getBigDecimal("renewalinterestrate")));
            }
            DynamicObjectCollection plans = loan.getDynamicObjectCollection("repaysubentry");
            ArrayList<RepayPlanBean> planList = new ArrayList<RepayPlanBean>();
            for (DynamicObject plan : plans) {
                RepayPlanBean rp = new RepayPlanBean();
                planList.add(rp);
                rp.setExrepaymentdate(plan.getDate("exrepaymentdate"));
                rp.setExdrawamount(plan.getBigDecimal("exdrawamount"));
                rp.setRepaymentdesc(plan.getString("repaymentdesc"));
            }
            create.setVariableValue("repaysubentry", SerializationUtils.toJsonString(planList));
            IAppCache iAppCache = TmcAppCache.get((String)"cfm", (String)"initbill", (String)"init");
            HashMap<String, String> loanBillInfo = new HashMap<String, String>();
            loanBillInfo.put("loanBillId", String.valueOf(loan.getLong("loanbillid")));
            loanBillInfo.put("loanBillNo", loan.getString("loanbillno"));
            iAppCache.put("tmc_cfm_init_loanbill:" + String.valueOf(contractBill.getPkValue()), loanBillInfo, 300);
            String loanType = initBill.getString("loantype");
            if (!"ifm_initbill".equals(initBill.getDataEntityType().getName())) {
                this.dealLoanFeeEntry(loan, loanType, create, initBill);
            }
            InitBillHelper.dealGmSubEntry((DynamicObject)loan, (DynamicObject)initBill, (String)loanType, (OperateOption)create);
            TmcOperateServiceHelper.execOperate((String)"loanbillinitpushandsave", (String)this.getContractEntityName(initBill), (DynamicObject[])new DynamicObject[]{contractBill}, (OperateOption)create);
        }
    }

    private DynamicObject genContractBill(DynamicObject initBill) {
        DynamicObject contractBill = BusinessDataServiceHelper.newDynamicObject((String)this.getContractEntityName(initBill));
        contractBill.set("id", initBill.get("loancontractid"));
        contractBill.set("confirmstatus", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
        contractBill.set("confirmer", (Object)RequestContext.get().getCurrUserId());
        contractBill.set("creator", (Object)RequestContext.get().getCurrUserId());
        contractBill.set("modifier", (Object)RequestContext.get().getCurrUserId());
        contractBill.set("confirmtime", (Object)DateUtils.getCurrentTime());
        contractBill.set("createtime", (Object)DateUtils.getCurrentTime());
        contractBill.set("modifytime", (Object)DateUtils.getCurrentTime());
        contractBill.set("datasource", initBill.get("datasource"));
        contractBill.set("registorg", initBill.get("registorg"));
        contractBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
        contractBill.set("org", initBill.get("org"));
        contractBill.set("contractstatus", (Object)LoanContractStatusEnum.EXECUTING.getValue());
        contractBill.set("intcalmethod", (Object)IntCalMethodEnum.totalcallint.getValue());
        contractBill.set("payintadjustrule", (Object)AdjustMethodEnum.no_adjust.getValue());
        contractBill.set("rateresetadjustrule", (Object)AdjustMethodEnum.no_adjust.getValue());
        contractBill.set("loantype", (Object)initBill.getString("loantype"));
        contractBill.set("region", initBill.get("region"));
        if ("cim_invest_initbill".equals(initBill.getDataEntityType().getName())) {
            contractBill.set("debtortype", initBill.get("debtortype"));
        } else {
            contractBill.set("creditortype", initBill.get("creditortype"));
        }
        contractBill.set("textcreditor", initBill.get("textcreditor"));
        contractBill.set("creditor", initBill.get("creditor"));
        contractBill.set("debtor", initBill.get("debtor"));
        contractBill.set("creditorg", initBill.get("creditorg"));
        contractBill.set("clientorg", initBill.get("clientorg"));
        contractBill.set("finproduct", initBill.get("finproduct"));
        contractBill.set("lendernature", initBill.get("lendernature"));
        contractBill.set("textdebtor", initBill.get("textdebtor"));
        contractBill.set("contractno", initBill.get("contractno"));
        contractBill.set("contractname", initBill.get("contractname"));
        contractBill.set("bizdate", initBill.get("bizdate"));
        contractBill.set("startdate", initBill.get("startdate"));
        contractBill.set("currency", initBill.get("currency"));
        contractBill.set("amount", initBill.get("amount"));
        contractBill.set("enddate", initBill.get("enddate"));
        contractBill.set("term", initBill.get("term"));
        contractBill.set("accountbank", initBill.get("accountbank"));
        contractBill.set("loaneracctbank", initBill.get("loaneracctbank"));
        contractBill.set("drawway", initBill.get("drawway"));
        contractBill.set("loanuse", initBill.get("loanuse"));
        contractBill.set("guarantee", initBill.get("guarantee"));
        contractBill.set("description", initBill.get("description"));
        contractBill.set("otherexplain", initBill.get("otherexplain"));
        if (initBill.getBoolean("isextend")) {
            contractBill.set("renewalexpiredate", initBill.get("renewalexpiredate"));
        }
        if ("ifm_initbill".equals(initBill.getDataEntityType().getName())) {
            contractBill.set("creditorg", (Object)initBill.getDynamicObject("settlecenter").getDynamicObject("org"));
            contractBill.set("settlecenter", initBill.get("settlecenter"));
            contractBill.set("settlestatus", (Object)SettleCenterStatusEnum.ACCEPT.getValue());
        }
        contractBill.set("iscycleloan", (Object)initBill.getBoolean("iscycleloan"));
        contractBill.set("interesttype", initBill.get("interesttype"));
        contractBill.set("interestrate", initBill.get("interestrate"));
        if (InterestTypeEnum.isFloat((String)initBill.getString("interesttype"))) {
            contractBill.set("startinterestrate", (Object)this.getRate(initBill));
        } else {
            contractBill.set("startinterestrate", initBill.get("interestrate"));
        }
        contractBill.set("interestsettledplan", initBill.get("interestsettledplan"));
        contractBill.set("settleintmode", initBill.get("settleintmode"));
        contractBill.set("basis", initBill.get("basis"));
        contractBill.set("repaymentway", initBill.get("repaymentway"));
        contractBill.set("stageplan", initBill.get("stageplan"));
        contractBill.set("islimitclause", initBill.get("islimitclause"));
        contractBill.set("limitclauseexplain", initBill.get("limitclauseexplain"));
        contractBill.set("isextend", initBill.get("isextend"));
        contractBill.set("isinit", (Object)"1");
        contractBill.set("initid", initBill.getPkValue());
        if (InterestTypeEnum.FLOAT.getValue().equals(initBill.get("interesttype"))) {
            contractBill.set("referencerate", initBill.get("referencerate"));
            contractBill.set("ratesign", initBill.get("ratesign"));
            contractBill.set("ratefloatpoint", initBill.get("ratefloatpoint"));
            contractBill.set("rateadjuststyle", initBill.get("rateadjuststyle"));
            if (RateAdjustStyleEnum.CYCLE.getValue().equals(initBill.get("rateadjuststyle"))) {
                contractBill.set("rateadjustdate", initBill.get("rateadjustdate"));
                contractBill.set("rateadjustcycletype", initBill.get("rateadjustcycletype"));
                contractBill.set("rateadjustcycle", initBill.get("rateadjustcycle"));
            }
        }
        if (initBill.getBoolean("isextend")) {
            contractBill.set("extendstatus", (Object)ContractExtendStatusEnum.AUDIT.getValue());
        } else {
            contractBill.set("extendstatus", (Object)ContractExtendStatusEnum.NOT.getValue());
        }
        if (EmptyUtil.isEmpty((Object)initBill.get("clientorg"))) {
            contractBill.set("isclientloan", (Object)"0");
        } else {
            contractBill.set("isclientloan", (Object)"1");
        }
        contractBill.set("overratetype", initBill.get("overratetype"));
        String overRateType = initBill.getString("overratetype");
        if (OverRateTypeEnum.isPercent((String)overRateType)) {
            contractBill.set("floatingratio", initBill.get("floatingratio"));
        } else {
            contractBill.set("overrate", initBill.get("overrate"));
        }
        this.dealContractSumAmt(initBill, contractBill);
        CfmBillSDKHelper.dealInitBillSecondDevFields((DynamicObject)initBill, (DynamicObject)contractBill);
        OperateOption create = OperateOption.create();
        create.setVariableValue("byInit", "true");
        if (!"ifm_initbill".equals(initBill.getDataEntityType().getName())) {
            this.dealContractFeeBill(initBill, contractBill, create);
            this.dealContractBizInfo(initBill, contractBill);
        }
        create.setVariableValue("srcEntityNumber", initBill.getDataEntityType().getName());
        OperationResult save = TmcOperateServiceHelper.execOperate((String)"save", (String)this.getContractEntityName(initBill), (DynamicObject[])new DynamicObject[]{contractBill}, (OperateOption)create);
        contractBill.set("id", save.getSuccessPkIds().get(0));
        this.setContractGmEntry(contractBill, initBill);
        return contractBill;
    }

    private String getContractEntityName(DynamicObject initBill) {
        String entityName = initBill.getDataEntityType().getName();
        if ("ifm_initbill".equals(entityName)) {
            return "ifm_loancontractbill";
        }
        if ("cfm_initbill_bond".equals(entityName)) {
            return "cfm_loancontract_bo";
        }
        if ("cim_invest_initbill".equals(entityName)) {
            return "cim_invest_contract";
        }
        return "cfm_loancontractbill";
    }

    private void dealLoanFeeEntry(DynamicObject loanBill, String loanType, OperateOption create, DynamicObject initBill) {
        logger.info("  2.1 \u63d0\u6b3e\u7684\u8d39\u7528\u660e\u7ec6.");
        DynamicObjectCollection loanLBs = loanBill.getDynamicObjectCollection("loan_feedetail");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)loanLBs)) {
            String formId;
            String loanFeeEntrySeriStr = DynamicObjectSerializeUtil.serialize((Object[])loanLBs.toArray(), (DynamicObjectType)((DynamicObject)loanLBs.get(0)).getDynamicObjectType());
            create.setVariableValue("loanFeeEntrySeriStr", loanFeeEntrySeriStr);
            boolean isInvestInit = "cim_invest_initbill".equals(initBill.getDataEntityType().getName());
            String string = formId = isInvestInit ? "cim_invest_loanbill" : "cfm_loanbill_e_l";
            if (LoanTypeEnum.BANKLOAN.getValue().equals(loanType) || LoanTypeEnum.BANKSLOAN.getValue().equals(loanType)) {
                formId = "cfm_loanbill_b_l";
            } else if (LoanTypeEnum.BOND.getValue().equals(loanType)) {
                formId = "cfm_loanbill_bond";
            }
            create.setVariableValue("FeeDetailEditPageSaveOp", formId);
        }
    }

    private void dealContractBizInfo(DynamicObject initBill, DynamicObject contractBill) {
        DynamicObjectCollection tradefInfos;
        DynamicObjectCollection projectInfos;
        DynamicObjectCollection bankInfos = initBill.getDynamicObjectCollection("banksyndicate_entry");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)bankInfos)) {
            DynamicObjectCollection bankCs = contractBill.getDynamicObjectCollection("banksyndicate_entry");
            bankCs.clear();
            int seq = 1;
            for (Object bankInfo : bankInfos) {
                DynamicObject bankC = bankCs.addNew();
                bankC.set("seq", (Object)seq++);
                bankC.set("e_bankrole", bankInfo.get("e_bankrole"));
                bankC.set("e_bank", bankInfo.get("e_bank"));
                bankC.set("e_shareamount", bankInfo.get("e_shareamount"));
                bankC.set("e_bankdescription", bankInfo.get("e_bankdescription"));
                bankC.set("e_creditlimit", bankInfo.get("e_creditlimit"));
                bankC.set("id", bankInfo.get("bankentryid"));
            }
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(projectInfos = initBill.getDynamicObjectCollection("project_entry")))) {
            DynamicObjectCollection projectCs = contractBill.getDynamicObjectCollection("project_entry");
            projectCs.clear();
            int seq = 1;
            for (Object projectInfo : projectInfos) {
                DynamicObject projectC = projectCs.addNew();
                projectC.set("seq", (Object)seq++);
                projectC.set("e_project", projectInfo.get("e_project"));
                projectC.set("e_projdescription", projectInfo.get("e_projdescription"));
            }
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(tradefInfos = initBill.getDynamicObjectCollection("tradefin_entry")))) {
            DynamicObjectCollection tradefInfoCs = contractBill.getDynamicObjectCollection("tradefin_entry");
            tradefInfoCs.clear();
            int seq = 1;
            for (DynamicObject tradefInfo : tradefInfos) {
                DynamicObject tradefInfoC = tradefInfoCs.addNew();
                tradefInfoC.set("seq", (Object)seq++);
                tradefInfoC.set("e_tf_relationtype", tradefInfo.get("e_tf_relationtype"));
                tradefInfoC.set("e_tf_relatebillno", tradefInfo.get("e_tf_relatebillno"));
                tradefInfoC.set("e_tf_letter", tradefInfo.get("e_tf_letter"));
                tradefInfoC.set("e_tf_beneficiary", tradefInfo.get("e_tf_beneficiary"));
                tradefInfoC.set("e_tf_expiredate", tradefInfo.get("e_tf_expiredate"));
                tradefInfoC.set("e_tf_description", tradefInfo.get("e_tf_description"));
                tradefInfoC.set("e_tf_unpaidamount", tradefInfo.get("e_tf_unpaidamount"));
                tradefInfoC.set("e_tf_currency", tradefInfo.get("e_tf_currency"));
                tradefInfoC.set("e_tf_relatebillid", tradefInfo.get("e_tf_relatebillid"));
            }
        }
        DynamicObjectCollection supplyChainfInfos = initBill.getDynamicObjectCollection("supplychainfin_entry");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)tradefInfos)) {
            DynamicObjectCollection supplyCs = contractBill.getDynamicObjectCollection("supplychainfin_entry");
            supplyCs.clear();
            int seq = 1;
            for (DynamicObject supplyChainfInfo : supplyChainfInfos) {
                DynamicObject supplyC = supplyCs.addNew();
                supplyC.set("seq", (Object)seq++);
                supplyC.set("e_sc_coreenterprise", supplyChainfInfo.get("e_sc_coreenterprise"));
                supplyC.set("e_sc_relationtype", supplyChainfInfo.get("e_sc_relationtype"));
                supplyC.set("e_sc_orderno", supplyChainfInfo.get("e_sc_orderno"));
                supplyC.set("e_sc_executedate", supplyChainfInfo.get("e_sc_executedate"));
                supplyC.set("e_sc_description", supplyChainfInfo.get("e_sc_description"));
            }
        }
    }

    private void dealContractFeeBill(DynamicObject initBill, DynamicObject contractBill, OperateOption create) {
        logger.info(" 1.1 \u5408\u540c\u7684\u8d39\u7528\u660e\u7ec6.");
        DynamicObjectCollection initCBs = initBill.getDynamicObjectCollection("feedetail");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)initCBs)) {
            String formId;
            String loanType = initBill.getString("loantype");
            boolean isInvestInit = "cim_invest_initbill".equals(initBill.getDataEntityType().getName());
            String string = formId = isInvestInit ? "cim_invest_contract" : "cfm_loancontract_ic_l";
            if (LoanTypeEnum.BANKLOAN.getValue().equals(loanType) || LoanTypeEnum.BANKSLOAN.getValue().equals(loanType)) {
                formId = "cfm_loancontract_bl_l";
            } else if (LoanTypeEnum.BOND.getValue().equals(loanType)) {
                formId = "cfm_loancontract_bo";
            }
            create.setVariableValue("FeeDetailEditPageSaveOp", formId);
            DynamicObjectCollection feeDetails = contractBill.getDynamicObjectCollection("feedetail");
            feeDetails.clear();
            int seq = 1;
            for (DynamicObject initCB : initCBs) {
                DynamicObject feeDetail = feeDetails.addNew();
                feeDetail.set("seq", (Object)seq++);
                feeDetail.set("loanbillno", null);
                feeDetail.set("feescheme", initCB.get("feescheme"));
                feeDetail.set("feetype", initCB.get("feetype"));
                feeDetail.set("feepaydate", initCB.get("feepaydate"));
                feeDetail.set("feecurrency", initCB.get("feecurrency"));
                feeDetail.set("feeamt", initCB.get("feeamt"));
                feeDetail.set("feerate", initCB.get("feerate"));
                feeDetail.set("feesettletype", initCB.get("feesettletype"));
                feeDetail.set("feeacctbank", initCB.get("feeacctbank"));
                feeDetail.set("feeoppunittype", initCB.get("feeoppunittype"));
                feeDetail.set("feeoppunit", initCB.get("feeoppunit"));
                feeDetail.set("feeoppunittext", initCB.get("feeoppunittext"));
                feeDetail.set("feeoppacctbank", initCB.get("feeoppacctbank"));
                feeDetail.set("feeoppbebank", initCB.get("feeoppbebank"));
                feeDetail.set("feeissettle", (Object)"1");
                feeDetail.set("feesource", initCB.get("feesource"));
                feeDetail.set("feeremark", initCB.get("feeremark"));
                feeDetail.set("excrate", initCB.get("excrate"));
            }
        }
    }

    private void dealContractSumAmt(DynamicObject initBill, DynamicObject contractBill) {
        DynamicObjectCollection loanEntrys = initBill.getDynamicObjectCollection("loanentry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)loanEntrys)) {
            contractBill.set("contractstatus", (Object)LoanContractStatusEnum.REGISTERED.getValue());
            return;
        }
        BigDecimal drawTAmt = BigDecimal.ZERO;
        BigDecimal repayTAmt = BigDecimal.ZERO;
        BigDecimal payInterestTAmt = BigDecimal.ZERO;
        for (DynamicObject loanEntry : loanEntrys) {
            BigDecimal drawAmt = loanEntry.getBigDecimal("drawamount");
            BigDecimal repayAmt = loanEntry.getBigDecimal("repayamount");
            BigDecimal payInterestAmt = loanEntry.getBigDecimal("payinterestamount");
            drawTAmt = drawTAmt.add(drawAmt);
            repayTAmt = repayTAmt.add(repayAmt);
            payInterestTAmt = payInterestTAmt.add(payInterestAmt);
        }
        contractBill.set("drawamount", (Object)drawTAmt);
        contractBill.set("notdrawamount", (Object)contractBill.getBigDecimal("amount").subtract(drawTAmt));
        contractBill.set("repayamount", (Object)repayTAmt);
        contractBill.set("notrepayamount", (Object)drawTAmt.subtract(repayTAmt));
        contractBill.set("payinterestamount", (Object)payInterestTAmt);
        contractBill.set("notpayinterestamount", (Object)BigDecimal.ZERO);
    }

    private String getDatePro(DynamicObject loan, String property) {
        Object date = loan.get(property);
        if (date == null) {
            return "";
        }
        return DateUtils.formatString((Date)loan.getDate(property), (String)"yyyyMMdd");
    }

    private void setContractGmEntry(DynamicObject contractBill, DynamicObject initBill) {
        String orgName;
        Long orgId;
        DynamicObjectCollection parentEntry = initBill.getDynamicObjectCollection("loanentry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)parentEntry)) {
            return;
        }
        DynamicObjectCollection bankSynEntry = initBill.getDynamicObjectCollection("banksyndicate_entry");
        HashMap<String, BigDecimal> bizAmountMap = new HashMap<String, BigDecimal>(bankSynEntry.size());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)bankSynEntry)) {
            for (DynamicObject bankSycDo : bankSynEntry) {
                String creditorType = bankSycDo.getString("e_bankrole");
                DynamicObject bankDo = bankSycDo.getDynamicObject("e_bank");
                if (EmptyUtil.isEmpty((String)creditorType) || EmptyUtil.isEmpty((DynamicObject)bankDo)) continue;
                bizAmountMap.put(creditorType + bankDo.getLong("id"), bankSycDo.getBigDecimal("e_shareamount"));
            }
        }
        HashSet<String> gcSet = new HashSet<String>();
        ArrayList<GuaranteeUseBean> gUseList = new ArrayList<GuaranteeUseBean>(8);
        BigDecimal contractAmt = contractBill.getBigDecimal("amount");
        String cParty = contractBill.getString("textcreditor");
        Date startDate = contractBill.getDate("bizdate");
        Date endDate = contractBill.getDate("enddate");
        if ("cim_invest_initbill".equals(initBill.getDataEntityType().getName())) {
            orgId = Optional.ofNullable(contractBill.getDynamicObject("creditorg")).map(r -> r.getLong("id")).orElse(0L);
            orgName = Optional.ofNullable(contractBill.getDynamicObject("creditorg")).map(r -> r.getString("name")).orElse("");
        } else {
            orgId = Optional.ofNullable(contractBill.getDynamicObject("org")).map(r -> r.getLong("id")).orElse(0L);
            orgName = Optional.ofNullable(contractBill.getDynamicObject("org")).map(r -> r.getString("name")).orElse("");
        }
        Long currencyId = Optional.ofNullable(contractBill.getDynamicObject("currency")).map(r -> r.getLong("id")).orElse(0L);
        boolean isBanks = LoanTypeEnum.isBanksLoan((String)initBill.getString("loantype"));
        for (DynamicObject parentRow : parentEntry) {
            DynamicObjectCollection subEntry = parentRow.getDynamicObjectCollection("gmsubentry");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)subEntry)) continue;
            for (DynamicObject subRow : subEntry) {
                if (!isBanks && subRow.getBoolean("gcreditguarantee")) continue;
                Long gcId = Optional.ofNullable(subRow.getDynamicObject("gcontract")).map(r -> r.getLong("id")).orElse(0L);
                String creditorType = subRow.getString("gcreditortype");
                Long creditor = subRow.getLong("gcreditor");
                if (gcId == 0L || !gcSet.add(gcId + creditorType + creditor)) continue;
                GuaranteeUseBean gUse = new GuaranteeUseBean();
                gUse.setSrcBillId(Long.valueOf(contractBill.getLong("id")));
                gUse.setSrcBillType(this.getContractEntityByInitBill(initBill));
                gUse.setSrcBillNo(contractBill.getString("billno"));
                gUse.setgContractId(gcId);
                gUse.setBizAmount(bizAmountMap.containsKey(creditorType + creditor) ? (BigDecimal)bizAmountMap.get(creditorType + creditor) : contractAmt);
                gUse.setComment(subRow.getString("gcomment"));
                gUse.setgAmount(bizAmountMap.containsKey(creditorType + creditor) ? subRow.getBigDecimal("gamount") : contractAmt.multiply(subRow.getBigDecimal("gratio")).divide(Constants.ONE_HUNDRED));
                gUse.setgRatio(subRow.getBigDecimal("gratio"));
                gUse.setExchrate(subRow.getBigDecimal("gexchrate"));
                gUse.setgCreditorType(creditorType);
                gUse.setgCreditor(creditor);
                gUse.setgCreditorText(subRow.getString("gcreditortext"));
                gUse.setDebtOrgId(orgId);
                gUse.setDebtOrgText(orgName);
                gUse.setDebtCurrencyId(currencyId);
                gUse.setCparty(cParty);
                gUse.setDebtStartDate(startDate);
                gUse.setDebtEndDate(endDate);
                gUseList.add(gUse);
            }
        }
        if (EmptyUtil.isNoEmpty(gUseList)) {
            GuaranteeUseHelper.saveGuaranteeUse(gUseList);
        }
    }

    private String getContractEntityByInitBill(DynamicObject initBill) {
        String entityName = initBill.getDataEntityType().getName();
        if ("cfm_initbill_bond".equals(entityName)) {
            return "cfm_loancontract_bo";
        }
        if ("cfm_initbill_e".equals(entityName)) {
            return "cfm_loancontract_ic_l";
        }
        if ("ifm_initbill".equals(entityName)) {
            return "ifm_loancontractbill";
        }
        if ("cim_invest_initbill".equals(entityName)) {
            return "cim_invest_contract";
        }
        return "cfm_loancontract_bl_l";
    }

    private BigDecimal getRate(DynamicObject initBill) {
        DynamicObject referenceRate = initBill.getDynamicObject("referencerate");
        Date startDate = initBill.getDate("startdate");
        BigDecimal rateFloatPoint = initBill.getBigDecimal("ratefloatpoint");
        String rateSign = initBill.getString("ratesign");
        if (EmptyUtil.isNoEmpty((DynamicObject)referenceRate) && EmptyUtil.isNoEmpty((Object)startDate)) {
            BigDecimal rate = MarketDataServiceHelper.referRate((String)referenceRate.getString("number"), (Date)startDate, (boolean)false);
            if (EmptyUtil.isEmpty((BigDecimal)rate)) {
                return BigDecimal.ZERO;
            }
            BigDecimal rateFloat = new BigDecimal(BigInteger.ZERO);
            if (EmptyUtil.isNoEmpty((BigDecimal)rateFloatPoint) && EmptyUtil.isNoEmpty((String)rateSign)) {
                rateFloat = rateFloatPoint.divide(new BigDecimal("100"), 6, RoundingMode.HALF_UP);
                if (RateSignEnum.SUBTRACT.getValue().equals(rateSign)) {
                    rateFloat = rateFloat.negate();
                }
            }
            return rate.add(rateFloat);
        }
        return BigDecimal.ZERO;
    }
}

