/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.interestbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.LoanWriteBackHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;

public class InterestBillUnConfirmService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List ias = super.getSelector();
        ias.add("sourcebillid");
        ias.add("billno");
        ias.add("billstatus");
        ias.add("repaymentid");
        ias.add("actualinstamt");
        ias.add("endinstdate");
        ias.add("instbillctg");
        ias.add("confirmstatus");
        ias.add("confirmer");
        ias.add("confirmtime");
        ias.add("datasource");
        ias.add("settlestatus");
        ias.add("calcoverint");
        return ias;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject interestEntity : dataEntities) {
            BusinessHelper.clearConfirmInfo((DynamicObject)interestEntity);
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        Set loanBillIds = Arrays.stream(dataEntities).map(d -> d.getLong("sourcebillid")).collect(Collectors.toSet());
        LoanWriteBackHelper.writeBack(new ArrayList(loanBillIds), (LoanWBTypeEnum)LoanWBTypeEnum.INTEREST);
    }
}

