/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.interestbill;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.enums.WriteOffStatusEnum;
import kd.tmc.cfm.common.helper.IntBillWriteOffHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class InterestBillUnWriteOffService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(InterestBillUnWriteOffService.class);

    public List<String> getSelector() {
        List ias = super.getSelector();
        ias.add("sourcebillid");
        ias.add("billno");
        ias.add("billstatus");
        ias.add("repaymentid");
        ias.add("actualinstamt");
        ias.add("startinstdate");
        ias.add("bechargeinstamt");
        ias.add("afterchargeinstamt");
        ias.add("endinstdate");
        ias.add("org");
        ias.add("settlestatus");
        ias.add("writeoffdate");
        ias.add("batchnoid");
        ias.add("thischargeinstamt");
        ias.add("writeoffstatus");
        return ias;
    }

    public void process(DynamicObject[] interestBills) throws KDException {
        Set batchNos = Arrays.stream(interestBills).map(o -> o.getLong("batchnoid")).collect(Collectors.toSet());
        logger.info("batchNos:" + batchNos);
        for (Long batchNo : batchNos) {
            this.unWriteOff(batchNo);
        }
    }

    private void unWriteOff(Long batchNo) {
        DynamicObject[] interestBills;
        QFilter filter = new QFilter("batchnoid", "=", (Object)batchNo);
        for (DynamicObject interestBill : interestBills = TmcDataServiceHelper.load((String)"cfm_interestbill", (String)String.join((CharSequence)",", this.getSelector()), (QFilter[])filter.toArray())) {
            interestBill.set("bechargeinstamt", (Object)BigDecimal.ZERO);
            interestBill.set("thischargeinstamt", (Object)BigDecimal.ZERO);
            interestBill.set("afterchargeinstamt", (Object)BigDecimal.ZERO);
            interestBill.set("writeoffstatus", (Object)WriteOffStatusEnum.NO_WRITEOFF.getValue());
            interestBill.set("writeoffdate", null);
        }
        DynamicObject[] relations = TmcDataServiceHelper.load((String)"cfm_instwriteoff_relation", (String)"preinstbillid,amount", (QFilter[])new QFilter[]{filter});
        List ids = Arrays.stream(relations).map(v -> v.getLong("preinstbillid")).collect(Collectors.toList());
        filter = new QFilter("id", "in", ids);
        DynamicObject[] preInstBills = TmcDataServiceHelper.load((String)"cfm_preinterestbill", (String)"id,writeoffamt,actpreinstamt,writeoffamt,nowriteoffamt,writeoffstatus,batchnoid,beforewriteoffamt", (QFilter[])new QFilter[]{filter});
        Map<Long, List<DynamicObject>> relationsGroup = Arrays.stream(relations).collect(Collectors.groupingBy(v -> v.getLong("preinstbillid")));
        for (DynamicObject preInstBill : preInstBills) {
            List<DynamicObject> relationList = relationsGroup.get(preInstBill.getLong("id"));
            for (DynamicObject relation : relationList) {
                IntBillWriteOffHelper.updatePreIntBill((DynamicObject)preInstBill, (BigDecimal)relation.getBigDecimal("amount"), (boolean)false, (boolean)false);
            }
        }
        SaveServiceHelper.save((DynamicObject[])preInstBills);
        SaveServiceHelper.save((DynamicObject[])interestBills);
        logger.info("delete cfm_instwriteoff_relation");
        filter = new QFilter("batchnoid", "=", (Object)batchNo);
        DeleteServiceHelper.delete((String)"cfm_instwriteoff_relation", (QFilter[])filter.toArray());
    }
}

