/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.interestbill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.tmc.cfm.common.helper.BatchIntBillHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class LoanIntBillBatchDeleteBotpService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entry");
        selector.add("loanbillid");
        selector.add("status");
        selector.add("intbillid");
        selector.add("biztype");
        selector.add("loantype");
        selector.add("datasource");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        this.deleteUpperBotp(dataEntities);
    }

    private void deleteUpperBotp(DynamicObject[] dataEntities) {
        for (DynamicObject data : dataEntities) {
            Pair<String, String> botpPair = this.getBotpPair(data, "upper");
            DynamicObjectCollection entries = data.getDynamicObjectCollection("entry");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)entries) || botpPair == null) continue;
            for (DynamicObject entry : entries) {
                long srcBillId = entry.getLong("loanbillid");
                if (!EmptyUtil.isNoEmpty((Long)srcBillId)) continue;
                TmcBotpHelper.deleteRation((String)((String)botpPair.getRight()), (Long)srcBillId, (Long)data.getLong("id"));
            }
        }
    }

    public Pair<String, String> getBotpPair(DynamicObject data, String relateType) {
        String entityName = data.getDynamicObjectType().getName();
        String bizType = data.getString("biztype");
        String loanType = data.getString("loantype");
        if (EmptyUtil.isEmpty((String)loanType)) {
            return null;
        }
        String dataSource = data.getString("datasource");
        Pair botpPair = StringUtils.equals((CharSequence)bizType, (CharSequence)"loan") ? BatchIntBillHelper.getBatchIntBotpPair((String)dataSource) : BatchIntBillHelper.getPreIntBotpPair((String)loanType, (String)dataSource);
        if (StringUtils.equals((CharSequence)relateType, (CharSequence)"upper")) {
            return Pair.of((Object)botpPair.getLeft(), (Object)entityName);
        }
        return Pair.of((Object)entityName, (Object)botpPair.getRight());
    }
}

