/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.interestbill;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.ExceptionUtils;
import kd.sdk.tmc.cfm.extpoint.interestbill.ILoanIntBillBatchSecondDevFields;
import kd.tmc.cfm.common.enums.BatchIntViewInfoEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.BatchIntBillHelper;
import kd.tmc.cfm.common.repository.InterestBillRepository;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.ListUtils;
import org.apache.commons.lang3.tuple.Pair;

public class LoanIntBillBatchSubmitService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(LoanIntBillBatchSubmitService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billno");
        selector.add("loanbillid");
        selector.add("bizdate");
        selector.add("comment");
        selector.add("isauto");
        selector.add("interestamt");
        selector.add("intdetailnum");
        selector.add("intcomment");
        selector.add("startdate");
        selector.add("enddate");
        selector.add("intbillid");
        selector.add("bizdealno");
        selector.add("settlecenter");
        selector.add("org");
        selector.add("company");
        selector.add("datasource");
        selector.add("loantype");
        selector.add("status");
        selector.add("actualinstamt");
        selector.add("payee");
        selector.add("payeetype");
        selector.add("payeetext");
        selector.add("payeebank");
        selector.add("payeeaccttext");
        selector.add("e_isrelcash");
        selector.add("businessdate");
        selector.add("creator");
        selector.add("calcoverint");
        selector.add("currency");
        selector.add("loancurrency");
        selector.add("convertrate");
        selector.add("convertintamt");
        selector.add("loanbillno");
        selector.add("accountbank");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        String datasource = dataEntities[0].getString("datasource");
        if (StringUtils.equals((CharSequence)datasource, (CharSequence)"ifm")) {
            this.dealIfmBatchInt(dataEntities);
        } else {
            this.dealCfmBatchInt(dataEntities);
        }
    }

    private void dealCfmBatchInt(DynamicObject[] dataEntities) {
        for (DynamicObject batchIntBill : dataEntities) {
            String datasource = batchIntBill.getString("datasource");
            String loanType = batchIntBill.getString("loantype");
            boolean isAuto = batchIntBill.getBoolean("isauto");
            Pair intBotpPair = BatchIntBillHelper.getBatchIntBotpPair((String)datasource);
            DynamicObjectCollection batchInEntrys = batchIntBill.getDynamicObjectCollection("entry");
            String loanBillEntity = (String)intBotpPair.getLeft();
            List loanBillIds = batchInEntrys.stream().map(v -> v.getLong("loanbillid")).collect(Collectors.toList());
            Map loanBillMap = TmcDataServiceHelper.loadDataAndMapById((String)loanBillEntity, (String)"id,loancontractbill.number,billno,currency.name", loanBillIds);
            loanType = LoanTypeEnum.isBanksLoan((String)loanType) ? LoanTypeEnum.BANKLOAN.getValue() : loanType;
            BatchIntViewInfoEnum batchViewInfo = BatchIntViewInfoEnum.getBatchViewInfo((String)loanType, (String)"loan");
            List ids = loanBillMap.keySet().stream().map(Object::toString).collect(Collectors.toList());
            Map lockMap = MutexServiceHelper.batchRequest(ids, (String)loanBillEntity, (String)"submit");
            List lockIds = lockMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
            try {
                String lockErrorBillNos = batchInEntrys.stream().filter(b -> Boolean.FALSE.equals(lockMap.get(b.getString("loanbillid")))).map(b -> b.getString("loanbillno")).collect(Collectors.joining(","));
                if (EmptyUtil.isNoEmpty((String)lockErrorBillNos)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u4e0b\u63a8\u5229\u606f\u5355, \u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"LoanIntBillBatchSaveService_2", (String)"tmc-cfm-business", (Object[])new Object[0]), lockErrorBillNos));
                }
                HashSet<Object> intBillIds = new HashSet<Object>(batchInEntrys.size());
                Map<Long, DynamicObject> batchInEntryMap = batchInEntrys.stream().collect(Collectors.toMap(d -> d.getLong("loanbillid"), d -> d, (d1, d2) -> d1));
                List batchInEntryLists = ListUtils.splitList((List)batchInEntrys, (long)50L);
                for (List batchInEntryList : batchInEntryLists) {
                    List loanBillIdList = batchInEntryList.stream().map(d -> d.getLong("loanbillid")).collect(Collectors.toList());
                    String interestBillEntity = (String)intBotpPair.getRight();
                    DynamicObject[] targetBills = TmcBotpHelper.batchPush((Object[])loanBillIdList.toArray(), (String)loanBillEntity, (String)interestBillEntity);
                    HashMap<Long, DynamicObject> targetBillBatchInEntryMap = new HashMap<Long, DynamicObject>(batchInEntryList.size());
                    for (DynamicObject targetBill : targetBills) {
                        long loanBillId = targetBill.getLong("sourcebillid");
                        DynamicObject batchIntEntry = batchInEntryMap.get(loanBillId);
                        DynamicObject loanBill = (DynamicObject)loanBillMap.get(loanBillId);
                        targetBillBatchInEntryMap.put(targetBill.getLong("id"), batchIntEntry);
                        this.dealLoanIntBillBatchAuditSecondDev(batchIntBill, batchIntEntry, targetBill);
                        Date bizDate = batchIntEntry.getDate("payintdate");
                        this.fillIntDetail(targetBill, batchIntEntry, bizDate, batchIntBill.getDate("businessdate"));
                        this.setSlBankInterestEntry(targetBill, batchIntBill.getDynamicObjectCollection("slentryentity"));
                        targetBill.set("cim_invest_interestbill".equals(interestBillEntity) ? "loaneracctbank" : "instbankacct", (Object)batchIntEntry.getDynamicObject("accountbank"));
                        targetBill.set("datasource", (Object)datasource);
                        targetBill.set("creator", batchIntBill.get("creator"));
                        targetBill.set("confirmstatus", (Object)ConfirmStatusEnum.WAITCONFIRM.getValue());
                        BigDecimal actualinstamt = batchIntEntry.getBigDecimal("actualinstamt");
                        DynamicObject payCurrency = batchIntEntry.getDynamicObject("currency");
                        targetBill.set("currency", (Object)payCurrency);
                        String intComment = BatchIntBillHelper.genIntComment((DynamicObject)loanBill, (BatchIntViewInfoEnum)batchViewInfo, (Date)bizDate, (BigDecimal)actualinstamt, (DynamicObject)payCurrency);
                        batchIntEntry.set("intcomment", (Object)intComment);
                        targetBill.set("auto", (Object)isAuto);
                    }
                    this.doSubmitInterestBill(intBillIds, interestBillEntity, targetBills, targetBillBatchInEntryMap);
                }
                this.checkFail(intBillIds, batchIntBill, batchInEntrys);
            }
            catch (Exception e) {
                logger.error("LoanIntBillBatchSubmitError\uff1a" + e.getMessage(), (Throwable)e);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u5229\u606f\u5355\u5931\u8d25:%s", (String)"LoanIntBillBatchSaveService_3", (String)"tmc-cfm-business", (Object[])new Object[0]), e.getMessage()));
            }
            finally {
                if (!lockIds.isEmpty()) {
                    MutexServiceHelper.batchRelease(lockIds, (String)loanBillEntity, (String)"submit");
                }
            }
        }
    }

    private boolean doSubmitInterestBill(Set<Object> intBillIds, String interestBillEntity, DynamicObject[] targetBills, Map<Long, DynamicObject> targetBillBatchInEntryMap) {
        block6: {
            OperationResult result = null;
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("WF", "TRUE");
            try {
                result = TmcOperateServiceHelper.execOperate((String)"submit", (String)interestBillEntity, (DynamicObject[])targetBills, (OperateOption)operateOption, (boolean)Boolean.FALSE);
                if (result == null) {
                    return false;
                }
                HashMap billNoMap = result.getBillNos();
                if (EmptyUtil.isEmpty((Object)billNoMap)) {
                    billNoMap = new HashMap(1);
                }
                List successPkIds = result.getSuccessPkIds();
                for (Object pkId : successPkIds) {
                    Long successPkId = (Long)pkId;
                    DynamicObject batchIntEntry = targetBillBatchInEntryMap.get(successPkId);
                    batchIntEntry.set("intdetailnum", billNoMap.get(pkId.toString()));
                    batchIntEntry.set("intbillid", (Object)successPkId);
                    batchIntEntry.set("status", (Object)"success");
                    intBillIds.add(successPkId);
                }
            }
            catch (Exception e) {
                String error = String.format(ResManager.loadKDString((String)"\u5229\u606f\u5355\u751f\u6210\u5931\u8d25\uff1a%s", (String)"LoanIntBillBatchSaveService_0", (String)"tmc-cfm-business", (Object[])new Object[0]), e.getMessage().length() > 60 ? e.getMessage().substring(0, 60) : e.getMessage());
                logger.error("LoanIntBillBatchSubmitError error: " + error, (Throwable)e);
                List interestBillIds = Arrays.stream(targetBills).map(d -> d.getLong("id")).collect(Collectors.toList());
                Map interestBillMap = InterestBillRepository.getInterestBillByIds(interestBillIds, (String)"id,billstatus");
                for (DynamicObject targetBill : targetBills) {
                    DynamicObject interestBill;
                    long interestBillId = targetBill.getLong("id");
                    DynamicObject batchIntEntry = targetBillBatchInEntryMap.get(interestBillId);
                    if (batchIntEntry == null || (interestBill = (DynamicObject)interestBillMap.get(interestBillId)) != null && BillStatusEnum.isSubmit((String)interestBill.getString("billstatus"))) continue;
                    batchIntEntry.set("status", (Object)"fail");
                    batchIntEntry.set("intcomment", (Object)error);
                }
                if (interestBillMap.isEmpty()) break block6;
                Object[] ids = interestBillMap.keySet().toArray();
                TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)interestBillEntity, (Object[])ids, (OperateOption)operateOption);
                TmcOperateServiceHelper.execOperate((String)"delete", (String)interestBillEntity, (Object[])ids, (OperateOption)operateOption);
            }
        }
        return false;
    }

    private void dealLoanIntBillBatchAuditSecondDev(DynamicObject batchIntBill, DynamicObject loanBillEntry, DynamicObject targetIntBill) {
        PluginProxy pluginProxy = PluginProxy.create(ILoanIntBillBatchSecondDevFields.class, (String)"kd.sdk.tmc.cfm.extpoint.interestbill.ILoanIntBillBatchSecondDevFields.loanIntBillBatchSecondDevFields");
        pluginProxy.callReplace(proxy -> {
            proxy.loanIntBillBatchSecondDevFields(batchIntBill, loanBillEntry, targetIntBill);
            return new Object();
        });
    }

    private void dealIfmBatchInt(DynamicObject[] dataEntities) {
        for (DynamicObject batchIntBill : dataEntities) {
            DynamicObjectCollection batchInEntrys = batchIntBill.getDynamicObjectCollection("entry");
            List loanBillIds = batchInEntrys.stream().map(v -> v.getString("loanbillid")).collect(Collectors.toList());
            Map lockMap = MutexServiceHelper.batchRequest(loanBillIds, (String)"ifm_loanbill", (String)"submit");
            List lockIds = lockMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
            boolean isAuto = batchIntBill.getBoolean("isauto");
            try {
                String lockErrorBillNos = batchInEntrys.stream().filter(b -> Boolean.FALSE.equals(lockMap.get(b.getString("loanbillid")))).map(b -> b.getString("loanbillno")).collect(Collectors.joining(","));
                if (EmptyUtil.isNoEmpty((String)lockErrorBillNos)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u4e0b\u63a8\u5229\u606f\u5355, \u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"LoanIntBillBatchSaveService_2", (String)"tmc-cfm-business", (Object[])new Object[0]), lockErrorBillNos));
                }
                HashSet<Object> intBillIds = new HashSet<Object>(batchInEntrys.size());
                Map<Long, DynamicObject> batchInEntryMap = batchInEntrys.stream().collect(Collectors.toMap(d -> d.getLong("loanbillid"), d -> d, (d1, d2) -> d1));
                List batchInEntryLists = ListUtils.splitList((List)batchInEntrys, (long)50L);
                for (List batchInEntryList : batchInEntryLists) {
                    List loanBillIdList = batchInEntryList.stream().map(d -> d.getLong("loanbillid")).collect(Collectors.toList());
                    DynamicObject[] targetBills = TmcBotpHelper.batchPush((Object[])loanBillIdList.toArray(), (String)"ifm_loanbill", (String)"ifm_interestbill");
                    HashMap<Long, DynamicObject> targetBillBatchInEntryMap = new HashMap<Long, DynamicObject>(batchInEntryList.size());
                    for (DynamicObject targetBill : targetBills) {
                        long loanBillId = targetBill.getLong("sourcebillid");
                        DynamicObject batchIntEntry = batchInEntryMap.get(loanBillId);
                        targetBillBatchInEntryMap.put(targetBill.getLong("id"), batchIntEntry);
                        this.dealLoanIntBillBatchAuditSecondDev(batchIntBill, batchIntEntry, targetBill);
                        Date bizDate = batchIntEntry.getDate("payintdate");
                        this.fillIntDetail(targetBill, batchIntEntry, bizDate, batchIntBill.getDate("businessdate"));
                        targetBill.set("datasource", (Object)"ifm");
                        targetBill.set("instbankacct", (Object)batchIntEntry.getDynamicObject("accountbank"));
                        targetBill.set("bizdealno", (Object)batchIntBill.getString("bizdealno"));
                        targetBill.set("confirmstatus", (Object)"waitconfirm");
                        targetBill.set("confirmer", (Object)RequestContext.get().getCurrUserId());
                        targetBill.set("creator", batchIntBill.get("creator"));
                        targetBill.set("auto", (Object)isAuto);
                    }
                    this.doSubmitInterestBill(intBillIds, "ifm_interestbill", targetBills, targetBillBatchInEntryMap);
                }
                this.checkFail(intBillIds, batchIntBill, batchInEntrys);
            }
            catch (Exception e) {
                logger.info("LoanIntBillBatchSubmitError\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u5229\u606f\u5355\u5931\u8d25:%s", (String)"LoanIntBillBatchSaveService_3", (String)"tmc-cfm-business", (Object[])new Object[0]), e.getMessage()));
            }
            finally {
                if (!lockIds.isEmpty()) {
                    MutexServiceHelper.batchRelease(lockIds, (String)"ifm_loanbill", (String)"submit");
                }
            }
        }
    }

    private void checkFail(Set<Object> intBillIds, DynamicObject batchIntBill, DynamicObjectCollection batchInEntrys) {
        if (intBillIds.size() < batchInEntrys.size()) {
            DynamicObjectCollection batchEntrys = batchIntBill.getDynamicObjectCollection("entry");
            for (DynamicObject intEntry : batchEntrys) {
                if (!intBillIds.contains(intEntry.getLong("intbillid"))) continue;
                intEntry.set("status", (Object)"");
                intEntry.set("intcomment", (Object)"");
                intEntry.set("intdetailnum", null);
                intEntry.set("intbillid", null);
            }
            batchIntBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            throw new KDBizException(ResManager.loadKDString((String)"\u6709\u63d0\u4ea4\u5931\u8d25\u7684\u8bb0\u5f55\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4\uff0c\u6216\u8005\u5220\u9664\u3002", (String)"LoanIntBillBatchSubmitService_0", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
    }

    private void fillIntDetail(DynamicObject targetBill, DynamicObject batchIntEntry, Date bizDate, Date businessdate) {
        targetBill.set("bizdate", (Object)bizDate);
        targetBill.set("businessdate", (Object)businessdate);
        targetBill.set("startinstdate", (Object)batchIntEntry.getDate("startdate"));
        targetBill.set("endinstdate", (Object)batchIntEntry.getDate("enddate"));
        targetBill.set("predictinstamt", (Object)batchIntEntry.getBigDecimal("interestamt"));
        targetBill.set("actualinstamt", (Object)batchIntEntry.getBigDecimal("actualinstamt"));
        targetBill.set("org", (Object)batchIntEntry.getDynamicObject("company"));
        if (LoanTypeEnum.isBond((String)targetBill.getString("loantype"))) {
            QFilter qFilter = new QFilter("id", "=", (Object)batchIntEntry.getLong("payee"));
            DynamicObject supplierDy = TmcDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"id, name", (QFilter[])qFilter.toArray());
            targetBill.set("payeetype", (Object)batchIntEntry.getString("payeetype"));
            targetBill.set("payee", (Object)supplierDy);
            targetBill.set("payeetext", (Object)batchIntEntry.getString("payeetext"));
            targetBill.set("payeebank", (Object)batchIntEntry.getDynamicObject("payeebank"));
            targetBill.set("payeeaccttext", (Object)batchIntEntry.getString("payeeaccttext"));
        }
        targetBill.set("isrelcash", (Object)batchIntEntry.getString("e_isrelcash"));
        if (targetBill.containsProperty("calcoverint") && batchIntEntry.containsProperty("calcoverint")) {
            targetBill.set("calcoverint", (Object)batchIntEntry.getString("calcoverint"));
        }
        targetBill.set("convertrate", (Object)batchIntEntry.getBigDecimal("convertrate"));
        targetBill.set("convertintamt", (Object)batchIntEntry.getBigDecimal("convertintamt"));
        targetBill.set("loancurrency", (Object)batchIntEntry.getDynamicObject("loancurrency"));
        targetBill.set("currency", (Object)batchIntEntry.getDynamicObject("currency"));
        if (targetBill.containsProperty("intyearrate") && batchIntEntry.containsProperty("intyearrate")) {
            targetBill.set("intyearrate", (Object)batchIntEntry.getBigDecimal("intyearrate"));
        }
        if (targetBill.containsProperty("preintyearrate") && batchIntEntry.containsProperty("preintyearrate")) {
            targetBill.set("preintyearrate", (Object)batchIntEntry.getBigDecimal("preintyearrate"));
        }
    }

    private void setSlBankInterestEntry(DynamicObject targetBill, DynamicObjectCollection loanSlEntrys) {
        DynamicObjectCollection interestSlBankEntrys = targetBill.getDynamicObjectCollection("slentryentity");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)interestSlBankEntrys) || EmptyUtil.isEmpty((DynamicObjectCollection)loanSlEntrys)) {
            return;
        }
        long loanBillId = targetBill.getLong("sourcebillid");
        if (EmptyUtil.isEmpty((Long)loanBillId)) {
            loanBillId = interestSlBankEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("s_loanbillno"))).map(o -> o.getDynamicObject("s_loanbillno").getLong("id")).findFirst().orElse(0L);
        }
        List slLoanBankEntryList = loanSlEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("s_loanbillno"))).collect(Collectors.toList());
        HashMap<Long, Pair> loanBankEntryMap = new HashMap<Long, Pair>(interestSlBankEntrys.size());
        for (DynamicObject loanSlEntry : slLoanBankEntryList) {
            long billId = loanSlEntry.getDynamicObject("s_loanbillno").getLong("id");
            if (billId != loanBillId) continue;
            loanBankEntryMap.put(loanSlEntry.getDynamicObject("s_bank").getLong("id"), Pair.of((Object)loanSlEntry.getBigDecimal("s_repayinst"), (Object)loanSlEntry.getBigDecimal("s_convertintamt")));
        }
        for (DynamicObject interestSlBankEntry : interestSlBankEntrys) {
            DynamicObject bank = interestSlBankEntry.getDynamicObject("s_bank");
            if (EmptyUtil.isEmpty((DynamicObject)bank)) continue;
            Pair bankAmountMap = loanBankEntryMap.getOrDefault(bank.getLong("id"), Pair.of((Object)BigDecimal.ZERO, (Object)BigDecimal.ZERO));
            interestSlBankEntry.set("s_repayinst", bankAmountMap.getLeft());
            interestSlBankEntry.set("s_convertintamt", bankAmountMap.getRight());
        }
    }
}

