/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.loanbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.tmc.cfm.common.enums.BillTypeEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LenderNatureEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.SettleTypeEnum;
import kd.tmc.cfm.common.helper.BatchIntBillHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InterestbillctgEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailExtInfo;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillExtInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BatchLoanBillAutoInterestService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(BatchLoanBillAutoInterestService.class);
    protected List<Object> batchBillIds = new ArrayList<Object>();

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("id");
        selector.add("org");
        selector.add("textdebtor");
        selector.add("creditorg");
        selector.add("textcreditor");
        selector.add("billno");
        selector.add("currency");
        selector.add("loancontractbill");
        selector.add("endinstdate");
        selector.add("startintdate");
        selector.add("notrepayamount");
        selector.add("lastrepaydate");
        selector.add("loantype");
        selector.add("datasource");
        selector.add("accountbank");
        selector.add("lendernature");
        selector.add("creditortype");
        selector.add("loaneracctbank");
        selector.add("repayacctbank");
        selector.add("repaymentway");
        selector.add("banksyndicate_entry");
        selector.add("e_bankrole");
        selector.add("e_bank");
        selector.add("e_shareamount");
        selector.add("interest_entry");
        selector.add("interestcalamount");
        selector.add("intstate");
        selector.add("intaccount");
        selector.add("intstartdate");
        selector.add("intenddate");
        selector.add("interesdate");
        selector.add("intereststartdate");
        selector.add("interestenddate");
        selector.add("interestdate");
        selector.add("interestbalance");
        selector.add("benchmarkint");
        selector.add("floatrate");
        selector.add("floatint");
        selector.add("interestrate");
        selector.add("interestamount");
        selector.add("interestdays");
        selector.add("intway");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        String interestBillStatus = (String)this.operationVariable.get("interestbillstatus");
        logger.info("\u72b6\u6001:interestBillStatus=" + interestBillStatus);
        String autoPayInt = (String)this.operationVariable.get("auto");
        logger.info("\u81ea\u52a8\u4ed8\u606f:autoPre=" + autoPayInt);
        ArrayList<DynamicObject> batchAutoIntObjList = new ArrayList<DynamicObject>(dataEntities.length);
        HashSet<String> repayWays = new HashSet<String>(Arrays.asList(RepaymentWayEnum.bqhblsbq.getValue(), RepaymentWayEnum.dqhblsbq.getValue(), RepaymentWayEnum.debj.getValue(), RepaymentWayEnum.debx.getValue(), RepaymentWayEnum.dbdx.getValue()));
        for (DynamicObject data : dataEntities) {
            String repaymentWay = data.getString("repaymentway");
            if (repayWays.contains(repaymentWay)) continue;
            String entity = "cfm_intbill_batch_loan";
            if (DataSourceEnum.isIfm((String)data.getString("datasource"))) {
                entity = "ifm_intbill_batch_loan";
            }
            DynamicObject batchAutoIntObj = BusinessDataServiceHelper.newDynamicObject((String)entity);
            String mainOrgField = BatchIntBillHelper.getMainOrgFeild((DynamicObject)data);
            String codeNumber = CodeRuleServiceHelper.getNumber((String)entity, (DynamicObject)batchAutoIntObj, (String)data.getDynamicObject(mainOrgField).getPkValue().toString());
            batchAutoIntObj.set("billno", (Object)codeNumber);
            batchAutoIntObj.set("creator", (Object)RequestContext.get().getCurrUserId());
            batchAutoIntObj.set("createtime", (Object)new Date());
            batchAutoIntObj.set("bizdate", (Object)DateUtils.getCurrentDate());
            batchAutoIntObj.set("businessdate", (Object)DateUtils.getCurrentDate());
            batchAutoIntObj.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            batchAutoIntObj.set("org", (Object)data.getDynamicObject(mainOrgField));
            batchAutoIntObj.set("biztype", (Object)BillTypeEnum.LOAN.getValue());
            boolean investType = this.isInvestType(data);
            String dataSource = this.getDataSource(data, investType);
            String loanType = data.getString("loantype");
            batchAutoIntObj.set("loantype", (Object)loanType);
            batchAutoIntObj.set("datasource", (Object)dataSource);
            batchAutoIntObj.set("interesttype", (Object)"loan");
            if ("ifm".equals(data.getString("datasource"))) {
                DynamicObject loanBill = TmcDataServiceHelper.loadSingle((String)"ifm_loanbill", (String)"id, settlecenter", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)data.getLong("id"))});
                batchAutoIntObj.set("settlecenter", loanBill.get("settlecenter"));
                batchAutoIntObj.set("interesttype", (Object)"fx");
            }
            batchAutoIntObj.set("comment", (Object)"auto");
            batchAutoIntObj.set("isauto", (Object)true);
            DynamicObjectCollection entryList = batchAutoIntObj.getDynamicObjectCollection("entry");
            DynamicObject entry = entryList.addNew();
            this.setEntryValueByLoanBill(entry, data);
            IntBillExtInfo intBill = this.getIntBillExtInfo(data);
            if (EmptyUtil.isEmpty((Object)intBill) || intBill == null) continue;
            BigDecimal actualInstAmt = this.getActualInstAmt(intBill, data);
            entry.set("startdate", (Object)intBill.getBeginDate());
            entry.set("enddate", (Object)intBill.getEndDate());
            entry.set("interestamt", (Object)intBill.getAmount());
            entry.set("actualinstamt", (Object)actualInstAmt);
            entry.set("convertintamt", (Object)actualInstAmt);
            entry.set("convertrate", (Object)BigDecimal.ONE);
            entry.set("intdetail", (Object)intBill);
            entry.set("intdetail_tag", (Object)SerializationUtils.toJsonString((Object)intBill));
            List details = intBill.getExtDetails();
            entry.set("rate", (Object)((IntBillDetailExtInfo)details.get(0)).getRate());
            entry.set("principle", (Object)((IntBillDetailExtInfo)details.get(0)).getPrinciple());
            entry.set("intyearrate", (Object)intBill.calcIntYearRate(actualInstAmt));
            entry.set("preintyearrate", (Object)intBill.calcIntYearRate(actualInstAmt));
            entry.set("payintdate", (Object)intBill.getBizDate());
            int days = details.stream().mapToInt(IntBillDetailInfo::getDays).sum();
            entry.set("intdays", (Object)days);
            DynamicObject bankAcct = this.getPayIntAccount(data, investType);
            entry.set("accountbank", (Object)bankAcct);
            entry.set("loancontractbillno", (Object)data.getDynamicObject("loancontractbill").getString("number"));
            entry.set("contractnum", (Object)data.getDynamicObject("loancontractbill").getString("contractno"));
            entry.set("inttype", (Object)SettleTypeEnum.JX.getValue());
            this.setSlInterestEntry(data, batchAutoIntObj, actualInstAmt);
            batchAutoIntObjList.add(batchAutoIntObj);
        }
        if (EmptyUtil.isNoEmpty(batchAutoIntObjList)) {
            OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"save", (String)"ifm_intbill_batch_loan", (DynamicObject[])batchAutoIntObjList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create(), (boolean)true);
            if (!operationResult.isSuccess() && EmptyUtil.isNoEmpty((Object)operationResult.getAllErrorInfo())) {
                OperateErrorInfo operateErrorInfo = (OperateErrorInfo)operationResult.getAllErrorInfo().get(0);
                logger.info("BatchLoanBillAutoInterestService save error >> " + operateErrorInfo.getMessage());
            }
            if ("submit".equals(interestBillStatus) || "audit".equals(interestBillStatus)) {
                this.batchBillIds.addAll(operationResult.getSuccessPkIds());
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("auto", "true");
                operateOption.setVariableValue("WF", "TRUE");
                OperationResult submitResult = TmcOperateServiceHelper.execOperate((String)"submit", (String)"ifm_intbill_batch_loan", (Object[])operationResult.getSuccessPkIds().toArray(), (OperateOption)operateOption, (boolean)true);
                if ("audit".equals(interestBillStatus) && submitResult.isSuccess()) {
                    TmcOperateServiceHelper.execOperate((String)"audit", (String)"ifm_intbill_batch_loan", (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)operateOption, (boolean)true);
                }
            }
        }
    }

    private BigDecimal getActualInstAmt(IntBillExtInfo intBill, DynamicObject loanBill) {
        DynamicObject intPlanEntry;
        List intPlans;
        BigDecimal actualInstAmt = intBill.getAmount();
        DynamicObjectCollection intPlanEntrys = loanBill.getDynamicObjectCollection("interest_entry");
        if (intPlanEntrys.size() > 0 && (intPlans = intPlanEntrys.stream().filter(o -> o.getBigDecimal("interestcalamount").compareTo(BigDecimal.ZERO) > 0).filter(o -> o.getInt("intstate") == 0).collect(Collectors.toList())).size() > 0 && EmptyUtil.isNoEmpty((DynamicObject)(intPlanEntry = intPlans.stream().min(Comparator.comparing(c -> c.getDate("interesdate"))).orElseGet(null)))) {
            actualInstAmt = intPlanEntry.getBigDecimal("interestcalamount");
        }
        return actualInstAmt;
    }

    private void setSlInterestEntry(DynamicObject data, DynamicObject batchAutoIntObj, BigDecimal intAmount) {
        if (!LoanTypeEnum.isBanksLoan((String)data.getString("loantype"))) {
            return;
        }
        DynamicObjectCollection interestSlEntrys = batchAutoIntObj.getDynamicObjectCollection("slentryentity");
        DynamicObjectCollection slEntrys = data.getDynamicObjectCollection("banksyndicate_entry");
        DynamicObject currency = data.getDynamicObject("currency");
        for (DynamicObject slEntry : slEntrys) {
            DynamicObject entry = interestSlEntrys.addNew();
            entry.set("s_loanbillno", (Object)data.getLong("id"));
            entry.set("s_bankrole", (Object)slEntry.getString("e_bankrole"));
            entry.set("s_bank", (Object)slEntry.getDynamicObject("e_bank"));
            entry.set("s_loancurrency", (Object)currency);
            entry.set("s_loanamount", (Object)slEntry.getBigDecimal("e_shareamount"));
            entry.set("s_instcurrency", (Object)currency);
        }
        BatchIntBillHelper.setSlBankEntryAmount((List)interestSlEntrys, (BigDecimal)intAmount, (String)"s_repayinst", (DynamicObject)currency, (boolean)true);
    }

    public void handlerException(DynamicObject[] dataEntities) throws KDException {
        super.handlerException(dataEntities);
        if (EmptyUtil.isNoEmpty(this.batchBillIds)) {
            Object[] ids;
            QFilter filter = new QFilter("id", "in", this.batchBillIds).and("billstatus", "in", (Object)new String[]{BillStatusEnum.SUBMIT.getValue(), BillStatusEnum.SAVE.getValue()});
            DynamicObjectCollection batchBills = QueryServiceHelper.query((String)"ifm_intbill_batch_loan", (String)"id,billstatus", (QFilter[])filter.toArray());
            Object[] submitIds = batchBills.stream().filter(v -> BillStatusEnum.isSubmit((String)v.getString("billstatus"))).map(r -> r.get("id")).toArray();
            if (EmptyUtil.isNoEmpty((Object[])submitIds)) {
                TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)"ifm_intbill_batch_loan", (Object[])submitIds, (OperateOption)OperateOption.create(), (boolean)true);
            }
            if (EmptyUtil.isNoEmpty((Object[])(ids = batchBills.stream().map(v -> v.get("id")).toArray()))) {
                TmcOperateServiceHelper.execOperate((String)"delete", (String)"ifm_intbill_batch_loan", (Object[])ids, (OperateOption)OperateOption.create(), (boolean)true);
            }
        }
    }

    private boolean isInvestType(DynamicObject loanBill) {
        boolean isInvest = false;
        String dataSource = loanBill.getString("datasource");
        if (DataSourceEnum.isInvest((String)dataSource)) {
            String lenderNature = loanBill.getString("lendernature");
            isInvest = LenderNatureEnum.INGROUP.getValue().equals(lenderNature) ? loanBill.getDynamicObjectType().getName().equals("cim_invest_loanbill") : true;
        } else if (DataSourceEnum.isCfm((String)dataSource)) {
            String loanType = loanBill.getString("loantype");
            String lenderNature = loanBill.getString("lendernature");
            if ((LoanTypeEnum.isLinklend((String)loanType) || LoanTypeEnum.isEntrustLoan((String)loanType)) && LenderNatureEnum.INGROUP.getValue().equals(lenderNature)) {
                isInvest = loanBill.getDynamicObjectType().getName().equals("cim_invest_loanbill");
            }
        }
        return isInvest;
    }

    private String getDataSource(DynamicObject loanBill, boolean isInvestType) {
        String dataSource = loanBill.getString("datasource");
        dataSource = isInvestType ? DataSourceEnum.INVEST.getValue() : (DataSourceEnum.isInvest((String)dataSource) ? DataSourceEnum.CFM.getValue() : dataSource);
        return dataSource;
    }

    private void setEntryValueByLoanBill(DynamicObject entry, DynamicObject loanBill) {
        entry.set("loanbillid", loanBill.getPkValue());
        entry.set("company", (Object)loanBill.getDynamicObject("org"));
        entry.set("textdebtor", (Object)loanBill.getString("textdebtor"));
        entry.set("loanbillno", (Object)loanBill.getString("billno"));
        entry.set("creditorg", (Object)loanBill.getDynamicObject("creditorg"));
        entry.set("textcreditor", (Object)loanBill.getString("textcreditor"));
        entry.set("currency", (Object)loanBill.getDynamicObject("currency"));
        entry.set("loancurrency", (Object)loanBill.getDynamicObject("currency"));
    }

    private IntBillExtInfo getIntBillExtInfo(DynamicObject loanBill) {
        DynamicObjectCollection intPlanEntrys = loanBill.getDynamicObjectCollection("interest_entry");
        if (intPlanEntrys.size() > 0) {
            List intPlans = intPlanEntrys.stream().filter(o -> o.getBigDecimal("interestcalamount").compareTo(BigDecimal.ZERO) > 0).filter(o -> o.getInt("intstate") == 0).collect(Collectors.toList());
            if (intPlans.size() == 0) {
                return null;
            }
            DynamicObject intPlanEntry = intPlans.stream().min(Comparator.comparing(c -> c.getDate("interesdate"))).orElseGet(null);
            if (EmptyUtil.isNoEmpty((DynamicObject)intPlanEntry)) {
                if (InterestbillctgEnum.isPayprinandinte((String)intPlanEntry.getString("intway"))) {
                    return null;
                }
                DynamicObjectCollection interestSubEntrys = intPlanEntry.getDynamicObjectCollection("interest_subentry");
                logger.info("fillIntDetail  interestSubEntrys: " + interestSubEntrys.toString());
                if (interestSubEntrys.size() > 0) {
                    IntBillExtInfo extInfo = new IntBillExtInfo();
                    extInfo.setBeginDate(intPlanEntry.getDate("intstartdate"));
                    extInfo.setEndDate(intPlanEntry.getDate("intenddate"));
                    extInfo.setBizDate(intPlanEntry.getDate("interesdate"));
                    BigDecimal predictInstAmt = interestSubEntrys.stream().map(e -> e.getBigDecimal("interestamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    extInfo.setAmount(predictInstAmt);
                    BigDecimal floatInt = interestSubEntrys.stream().map(e -> e.getBigDecimal("floatint")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    BigDecimal benchmarkInt = interestSubEntrys.stream().map(e -> e.getBigDecimal("benchmarkint")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    if (benchmarkInt.compareTo(BigDecimal.ZERO) == 0) {
                        benchmarkInt = interestSubEntrys.stream().map(e -> e.getBigDecimal("interestamount").subtract(e.getBigDecimal("floatint"))).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    }
                    extInfo.setFloatInt(floatInt);
                    extInfo.setBenchmarkInt(benchmarkInt);
                    ArrayList<IntBillDetailExtInfo> extDetails = new ArrayList<IntBillDetailExtInfo>(interestSubEntrys.size());
                    for (DynamicObject entry : interestSubEntrys) {
                        IntBillDetailExtInfo extDetail = new IntBillDetailExtInfo();
                        extDetail.setBeginDate(entry.getDate("intereststartdate"));
                        extDetail.setEndDate(entry.getDate("interestenddate"));
                        extDetail.setDays(entry.getInt("interestdate"));
                        extDetail.setPrinciple(entry.getBigDecimal("interestbalance"));
                        extDetail.setBenchmarkInt(entry.getBigDecimal("benchmarkint"));
                        extDetail.setFloatRate(entry.getBigDecimal("floatrate"));
                        extDetail.setFloatInt(entry.getBigDecimal("floatint"));
                        extDetail.setRate(entry.getBigDecimal("interestrate"));
                        extDetail.setAmount(entry.getBigDecimal("interestamount"));
                        extDetail.setBasisDay(entry.getInt("interestdays"));
                        extDetails.add(extDetail);
                    }
                    extInfo.setExtDetails(extDetails);
                    logger.info("fillIntDetail  extInfo: " + extInfo.toString());
                    return extInfo;
                }
            }
        }
        return null;
    }

    private DynamicObject getPayIntAccount(DynamicObject loanBill, boolean isInvestType) {
        DynamicObject accountbank = loanBill.getDynamicObject("accountbank");
        DynamicObjectCollection intPlanEntrys = loanBill.getDynamicObjectCollection("interest_entry");
        DynamicObject intPlan = intPlanEntrys.stream().filter(r -> r.getInt("intstate") == 0).findFirst().orElse(null);
        if (intPlan != null) {
            accountbank = intPlan.getDynamicObject("intaccount");
        }
        if (isInvestType) {
            accountbank = loanBill.getDynamicObject("loaneracctbank");
        }
        if (DataSourceEnum.isIfm((String)loanBill.getString("datasource"))) {
            accountbank = loanBill.getDynamicObject("repayacctbank");
        }
        return accountbank;
    }
}

