/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.loanbill;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.bean.LoanWriteParam;
import kd.tmc.cfm.common.enums.ApplyBusinessStatusEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.CfmAttachmentHelper;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.LoanWriteBackHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;

public class LoanBillConfirmService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(LoanBillConfirmService.class);

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("drawtype");
        sic.add("sourcebillid");
        sic.add("confirmstatus");
        sic.add("confirmer");
        sic.add("confirmtime");
        sic.add("accountbank");
        sic.add("loaneracctbank");
        sic.add("calculaterateamount");
        sic.add("notrepayamount");
        sic.add("amount");
        sic.add("drawamount");
        sic.add("amount");
        sic.add("drawamount");
        sic.add("productfactory");
        sic.add("isinit");
        sic.add("lendernature");
        sic.add("creditorg");
        sic.add("creditor");
        sic.add("creditortype");
        sic.add("textcreditor");
        sic.add("debtortype");
        sic.add("debtor");
        sic.add("textdebtor");
        sic.add("loancontractbill");
        sic.add("loantype");
        sic.add("drawapplybill");
        sic.add("datasource");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject loanBill : dataEntities) {
            loanBill.set("drawtype", (Object)DrawTypeEnum.DRAWED.getValue());
        }
        List<DynamicObject> loanBills = Arrays.asList(dataEntities);
        BusinessHelper.fillConfirmInfo(loanBills);
        CfmBillCommonHelper.updateApplyBizStatus(loanBills, (String)"drawapplybill", (String)"cfm_draw_apply", (String)ApplyBusinessStatusEnum.HANDED.getValue());
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        LoanWriteBackHelper.writeBack((LoanWriteParam)LoanWriteParam.buildLoanBill(Arrays.asList(dataEntities), (LoanWBTypeEnum)LoanWBTypeEnum.UPDATECONTRACT));
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        CfmAttachmentHelper.dealAttachment((DynamicObject[])dataEntities);
    }
}

