/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.loanbill;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.enums.ApplyBusinessStatusEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.CfmContractBillHelper;
import kd.tmc.cfm.common.helper.CreditLimitHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillDelService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(20);
        sic.add("creditlimit");
        sic.add("billno");
        sic.add("datasource");
        sic.add("org");
        sic.add("creditorg");
        sic.add("registorg");
        sic.add("textdebtor");
        sic.add("textcreditor");
        sic.add("returnreason");
        sic.add("productfactory");
        sic.add("isinit");
        sic.add("lendernature");
        sic.add("creditorg");
        sic.add("creditor");
        sic.add("creditortype");
        sic.add("textcreditor");
        sic.add("debtortype");
        sic.add("debtor");
        sic.add("textdebtor");
        sic.add("loancontractbill");
        sic.add("drawamount");
        sic.add("loantype");
        sic.add("drawapplybill");
        sic.add("banksyndicate_entry");
        sic.add("banksyndicate_entry.e_bankcreditlimit");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject data : dataEntities) {
            DynamicObject applyBill;
            if (EmptyUtil.isNoEmpty((DynamicObject)data.getDynamicObject("creditlimit"))) {
                if (CfmContractBillHelper.creditPreUse((String)data.getString("loantype"), (String)data.getString("creditortype"))) {
                    applyBill = BusinessHelper.getLoanApplyBill((DynamicObject)data.getDynamicObject("loancontractbill"));
                    CreditLimitHelper.creditBizDel((DynamicObject)data, (DynamicObject)applyBill, null, null);
                }
            } else if (LoanTypeEnum.isBanksLoan((String)data.getString("loantype")) && CreditLimitHelper.isLoanBillEntryCredit((DynamicObject)data)) {
                applyBill = BusinessHelper.getLoanApplyBill((DynamicObject)data.getDynamicObject("loancontractbill"));
                CreditLimitHelper.creditBizDel((DynamicObject)data, (DynamicObject)applyBill, (String)"banksyndicate_entry", (String)"e_bankcreditlimit");
            }
            CreditLimitHelper.deleteCreditUse((Long)data.getLong("id"), (String)data.getDataEntityType().getName());
            if (!EmptyUtil.isNoEmpty((Object)data.get("drawapplybill"))) continue;
            DynamicObject drawApplyBill = data.getDynamicObject("drawapplybill");
            drawApplyBill = TmcDataServiceHelper.loadSingle((Object)drawApplyBill.getPkValue(), (String)"cfm_draw_apply");
            drawApplyBill.set("businessstatus", (Object)ApplyBusinessStatusEnum.NOTHAND.getValue());
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{drawApplyBill});
        }
    }
}

