/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.loanbill;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.bean.LoanWriteParam;
import kd.tmc.cfm.common.enums.ApplyBusinessStatusEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.LoanWriteBackHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;

public class LoanBillUnConfirmService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("sourcebillid");
        sic.add("drawtype");
        sic.add("creditlimit");
        sic.add("confirmstatus");
        sic.add("confirmer");
        sic.add("confirmtime");
        sic.add("contractbillno");
        sic.add("ratedeadline");
        sic.add("ratesign");
        sic.add("ratefloatpoint");
        sic.add("rateadjuststyle");
        sic.add("rateadjustdate");
        sic.add("rateadjustcycle");
        sic.add("renewalinterestrate");
        sic.add("amount");
        sic.add("drawamount");
        sic.add("interesttype");
        sic.add("referencerate");
        sic.add("clientorg");
        sic.add("repaymentway");
        sic.add("stageplan");
        sic.add("ratetype");
        sic.add("renewalinteresttype");
        sic.add("expiredate");
        sic.add("bizdate");
        sic.add("datasource");
        sic.add("loantype");
        sic.add("loaneracctbank");
        sic.add("accountbank");
        sic.add("productfactory");
        sic.add("ratehistory_entry");
        sic.add("creditortype");
        sic.add("isinit");
        sic.add("loancontractbill");
        sic.add("drawapplybill");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            dataEntity.set("drawtype", (Object)DrawTypeEnum.DRAWING.getValue());
        }
        List<DynamicObject> loanBills = Arrays.asList(dataEntities);
        BusinessHelper.clearConfirmInfo(loanBills);
        CfmBillCommonHelper.updateApplyBizStatus(loanBills, (String)"drawapplybill", (String)"cfm_draw_apply", (String)ApplyBusinessStatusEnum.HANDING.getValue());
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        LoanWriteBackHelper.writeBack((LoanWriteParam)LoanWriteParam.buildLoanBill(Arrays.asList(dataEntities), (LoanWBTypeEnum)LoanWBTypeEnum.UPDATECONTRACT));
    }
}

