/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.loanbill.save;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.business.opservice.loanbill.save.LoanBillSaveParam;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.CfmRateAdjustHelper;
import kd.tmc.fbp.business.opservice.common.chain.AbstractBusinessBatchHandler;
import kd.tmc.fbp.business.opservice.common.chain.BusinessHandleParam;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillSaveByBondHandler
extends AbstractBusinessBatchHandler {
    public void doBeforeProcess(DynamicObject[] bizBills, BusinessHandleParam param) {
        this.doBeforeWriteBack(bizBills, (LoanBillSaveParam)param.getInParam());
    }

    public void doProcess(DynamicObject[] bizBills, BusinessHandleParam param) {
        this.dealReorderPlusEntry(bizBills, (LoanBillSaveParam)param.getInParam());
    }

    public void doBeforeCommit(DynamicObject[] bizBills, BusinessHandleParam param) {
        this.doOnBeforeCommit(bizBills, (LoanBillSaveParam)param.getInParam());
    }

    public boolean doFilter(DynamicObject[] bizBills, BusinessHandleParam param) {
        LoanBillSaveParam saveParam = (LoanBillSaveParam)param.getInParam();
        return !saveParam.isByInit() && !saveParam.isFromIsc();
    }

    private boolean isBond(DynamicObject loanBill) {
        return StringUtils.equals((CharSequence)"cfm_loanbill_bond", (CharSequence)loanBill.getDynamicObjectType().getName());
    }

    private void doBeforeWriteBack(DynamicObject[] bizBills, LoanBillSaveParam saveParam) {
        if (!saveParam.isFromPerpetualBond()) {
            return;
        }
        for (DynamicObject loanBill : bizBills) {
            if (!this.isBond(loanBill)) continue;
            DynamicObject bondBill = TmcDataServiceHelper.loadSingle((Object)loanBill.getLong("id"), (String)"cfm_loanbill_bond");
            DynamicObjectCollection condEntry = bondBill.getDynamicObjectCollection("condition_entry_er");
            condEntry.clear();
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{bondBill});
            DynamicObjectCollection currentCondEntry = loanBill.getDynamicObjectCollection("condition_entry_er");
            currentCondEntry.clear();
        }
    }

    private void dealReorderPlusEntry(DynamicObject[] bizBills, LoanBillSaveParam saveParam) {
        for (DynamicObject data : bizBills) {
            if (!this.isBond(data) || !data.getBoolean("issetpluspoint") || !StringUtils.equals((CharSequence)InterestTypeEnum.AGREE.getValue(), (CharSequence)data.getString("interesttype"))) continue;
            DynamicObjectCollection conditionEntry = data.getDynamicObjectCollection("condition_entry_er");
            Map<Date, BigDecimal> rowMap = conditionEntry.stream().filter(r -> EmptyUtil.isNoEmpty((Object)r.getDate("effectdate_er"))).collect(Collectors.toMap(r -> r.getDate("effectdate_er"), r -> r.getBigDecimal("pluspoint_er")));
            conditionEntry.clear();
            TreeSet<Date> treeSet = new TreeSet<Date>(Date::compareTo);
            treeSet.addAll(rowMap.keySet());
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                DynamicObject newRow = conditionEntry.addNew();
                Date effectDate = (Date)iterator.next();
                newRow.set("effectdate_er", (Object)effectDate);
                newRow.set("pluspoint_er", (Object)rowMap.get(effectDate));
            }
        }
    }

    private void doOnBeforeCommit(DynamicObject[] bizBills, LoanBillSaveParam saveParam) {
        for (DynamicObject loanBill : bizBills) {
            if (!this.isBond(loanBill)) continue;
            this.doAfterWriteBack(saveParam.isFromPerpetualBond(), loanBill.getLong("id"));
        }
    }

    private void doAfterWriteBack(boolean isNeedExec, Long loanBillId) {
        DynamicObject bondBill = TmcDataServiceHelper.loadSingle((Object)loanBillId, (String)"cfm_loanbill_bond");
        if (isNeedExec) {
            CfmRateAdjustHelper.reInsertResetConditionEntry((DynamicObject)bondBill);
        } else if (bondBill.getBoolean("issetpluspoint") && EmptyUtil.isEmpty((DynamicObjectCollection)bondBill.getDynamicObjectCollection("condition_entry_er"))) {
            CfmRateAdjustHelper.autoFillResetConditionEntry((DynamicObject)bondBill);
            CfmBillCommonHelper.constomSaveOp((DynamicObject)bondBill);
        }
    }
}

