/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.loanbill.save;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.tmc.cfm.business.opservice.loanbill.save.LoanBillSaveParam;
import kd.tmc.cfm.common.bean.RepayPlanBean;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.cfm.common.enums.SettleCenterStatusEnum;
import kd.tmc.cfm.common.enums.SlBankRoleEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.helper.LoanWriteBackHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.opservice.common.chain.AbstractBusinessBatchHandler;
import kd.tmc.fbp.business.opservice.common.chain.BusinessHandleParam;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.InterestbillctgEnum;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.model.guaranteeuse.GuaranteeUseBean;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillSaveByInitHandler
extends AbstractBusinessBatchHandler {
    public void doBeforeProcess(DynamicObject[] bizBills, BusinessHandleParam param) {
        this.dealInitLoanFeeEntry(bizBills, (LoanBillSaveParam)param.getInParam());
    }

    public void doProcess(DynamicObject[] bizBills, BusinessHandleParam param) {
        this.doByInitOnProcess(bizBills, (LoanBillSaveParam)param.getInParam());
        this.dealInitGmSubEntry(bizBills, (LoanBillSaveParam)param.getInParam());
    }

    public void doBeforeCommit(DynamicObject[] bizBills, BusinessHandleParam param) {
        this.doByInitOnBeforeCommit(bizBills, (LoanBillSaveParam)param.getInParam());
    }

    public boolean doFilter(DynamicObject[] bizBills, BusinessHandleParam param) {
        return ((LoanBillSaveParam)param.getInParam()).isByInit();
    }

    private void dealInitLoanFeeEntry(DynamicObject[] loanBills, LoanBillSaveParam saveParam) {
        Map<String, String> operationVariable = saveParam.getOperationVariable();
        String loanFeeEntrySeriStr = operationVariable.get("loanFeeEntrySeriStr");
        if (EmptyUtil.isEmpty((String)loanFeeEntrySeriStr)) {
            return;
        }
        DynamicObjectType feeEnrtyType = ((DynamicCollectionProperty)((DynamicCollectionProperty)EntityMetadataCache.getDataEntityType((String)"cfm_initbill").getProperty("loanentry")).getDynamicCollectionItemPropertyType().getProperty("loan_feedetail")).getDynamicCollectionItemPropertyType();
        for (DynamicObject loanBill : loanBills) {
            Object[] loanFeeEntry = DynamicObjectSerializeUtil.deserialize((String)loanFeeEntrySeriStr, (DynamicObjectType)feeEnrtyType);
            DynamicObjectCollection feeDetails = loanBill.getDynamicObjectCollection("feedetail");
            feeDetails.clear();
            int seq = 1;
            for (Object initLBObj : loanFeeEntry) {
                DynamicObject feeDetail = feeDetails.addNew();
                feeDetail.set("seq", (Object)seq++);
                DynamicObject initLB = (DynamicObject)initLBObj;
                feeDetail.set("loanbillno", (Object)loanBill.getString("billno"));
                feeDetail.set("feescheme", initLB.get("lfeescheme"));
                feeDetail.set("feetype", initLB.get("lfeetype"));
                feeDetail.set("feepaydate", initLB.get("lfeepaydate"));
                feeDetail.set("feecurrency", initLB.get("lfeecurrency"));
                feeDetail.set("feeamt", initLB.get("lfeeamt"));
                feeDetail.set("feerate", initLB.get("lfeerate"));
                feeDetail.set("feesettletype", initLB.get("lfeesettletype"));
                feeDetail.set("feeacctbank", initLB.get("lfeeacctbank"));
                feeDetail.set("feeoppunittype", initLB.get("lfeeoppunittype"));
                feeDetail.set("feeoppunit", initLB.get("lfeeoppunit"));
                feeDetail.set("feeoppunittext", initLB.get("lfeeoppunittext"));
                feeDetail.set("feeoppacctbank", initLB.get("lfeeoppacctbank"));
                feeDetail.set("feeoppbebank", initLB.get("lfeeoppbebank"));
                feeDetail.set("feeissettle", (Object)"1");
                feeDetail.set("feesource", initLB.get("lfeesource"));
                feeDetail.set("feeremark", initLB.get("lfeeremark"));
                feeDetail.set("excrate", initLB.get("lexcrate"));
            }
        }
    }

    private void doByInitOnProcess(DynamicObject[] dataEntities, LoanBillSaveParam saveParam) {
        Map<String, String> operationVariable = saveParam.getOperationVariable();
        for (DynamicObject loan : dataEntities) {
            String plansJson;
            String dataSource = operationVariable.get("datasource");
            loan.set("datasource", (Object)dataSource);
            if (DataSourceEnum.IFM.getValue().equals(dataSource)) {
                loan.set("settlestatus", (Object)SettleCenterStatusEnum.ACCEPT.getValue());
            }
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(dataSource);
            loan.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            loan.set("auditor", (Object)RequestContext.get().getUserId());
            loan.set("auditdate", (Object)DateUtils.getCurrentTime());
            String loanId = operationVariable.get("loanbillid");
            if (!EmptyUtil.isEmpty((String)loanId) && !"0".equals(loanId)) {
                loan.set("id", (Object)Long.valueOf(loanId));
            }
            BigDecimal drawamount = this.getBigDecimalPro(operationVariable, "drawamount");
            loan.set("drawamount", (Object)drawamount);
            loan.set("convertrate", (Object)BigDecimal.ONE);
            loan.set("convertdrawamt", (Object)drawamount);
            this.setEntryShareAmount(loan);
            loan.set("bizdate", (Object)this.getDatePro(operationVariable, "loaddate"));
            loan.set("startintdate", (Object)this.getDatePro(operationVariable, "startinstdate"));
            loan.set("receivedate", (Object)this.getDatePro(operationVariable, "receivedate"));
            loan.set("expiredate", (Object)this.getDatePro(operationVariable, "expiredate"));
            loan.set("term", (Object)operationVariable.get("loanterm"));
            loan.set("accountbank", (Object)BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(operationVariable.get("loadacctbank")), (String)"bd_accountbanks", (String)"id"));
            BigDecimal repayAmount = this.getBigDecimalPro(operationVariable, "repayamount");
            loan.set("repayamount", (Object)repayAmount);
            loan.set("payinterestamount", (Object)this.getBigDecimalPro(operationVariable, "payinterestamount"));
            loan.set("endpreinstdate", (Object)this.getDatePro(operationVariable, "endpreinstdate"));
            loan.set("initendpreinstdate", (Object)this.getDatePro(operationVariable, "endpreinstdate"));
            loan.set("renewalexpiredate", (Object)this.getDatePro(operationVariable, "loanexpiredate"));
            loan.set("exrateadjustdate", (Object)this.getDatePro(operationVariable, "extrateajustdate"));
            loan.set("overduedate", (Object)0);
            loan.set("isinit", (Object)"1");
            loan.set("confirmstatus", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
            loan.set("drawtype", (Object)DrawTypeEnum.DRAWED.getValue());
            boolean isUnify = Boolean.parseBoolean(operationVariable.get("isunifyloanreturn"));
            loan.set("isunifyloanreturn", (Object)isUnify);
            loan.set("isunifycredit", (Object)isUnify);
            loan.set("notrepayamount", (Object)drawamount.subtract(repayAmount));
            String loanNo = operationVariable.get("loanbillno");
            if (!EmptyUtil.isEmpty((String)loanNo)) {
                loan.set("billno", (Object)loanNo);
            } else if (StringUtils.isEmpty((CharSequence)loan.getString("billno"))) {
                String mainOrgField = ((MainEntityType)loan.getDynamicObjectType()).getMainOrg();
                String codeNumber = CodeRuleHelper.generateNumber((String)this.getLoanEntityName(loan), (DynamicObject)loan, (String)loan.getDynamicObject(mainOrgField).getPkValue().toString(), (String)"");
                if (StringUtils.isEmpty((CharSequence)codeNumber)) {
                    throw new KDBizException(bizResource.getInbEndinitNolbill());
                }
                loan.set("billno", (Object)codeNumber);
            }
            this.setCreditLimit(loan, operationVariable);
            if (InterestTypeEnum.FLOAT.getValue().equals(loan.getString("interesttype"))) {
                loan.set("rateadjuststyle", (Object)operationVariable.get("loanrateadjuststyle"));
                loan.set("ratesign", (Object)operationVariable.get("loanratesign"));
                loan.set("ratefloatpoint", (Object)this.getBigDecimalPro(operationVariable, "loanratefloatpoint"));
                if (RateAdjustStyleEnum.CYCLE.getValue().equals(loan.getString("rateadjuststyle"))) {
                    loan.set("rateadjustdate", (Object)this.getDatePro(operationVariable, "loanrateadjustdate"));
                    loan.set("rateadjustcycletype", (Object)operationVariable.get("loanrateadjusttype"));
                    loan.set("rateadjustcycle", (Object)operationVariable.get("loanrateadjustcycle"));
                }
            } else {
                loan.set("loanrate", (Object)this.getBigDecimalPro(operationVariable, "loanrate"));
                loan.set("startloanrate", (Object)this.getBigDecimalPro(operationVariable, "loanrate"));
            }
            if ("true".equals(operationVariable.get("bondbyInit"))) {
                Long loanUseId;
                Long ratingAgencyId;
                Long interestPlanId;
                this.dealInitUnderWriterEntryInfo(operationVariable, loan);
                this.dealInitInvestorEntryInfo(operationVariable, loan);
                loan.set("contractno", (Object)operationVariable.get("loan_contractno"));
                loan.set("contractname", (Object)operationVariable.get("loan_contractname"));
                loan.set("shortname", (Object)operationVariable.get("loan_shortname"));
                loan.set("publishprice", (Object)this.getBigDecimalPro(operationVariable, "publishprice"));
                loan.set("ticketamt", (Object)this.getBigDecimalPro(operationVariable, "ticketamt"));
                loan.set("interesttype", (Object)operationVariable.get("loan_interesttype"));
                loan.set("repaymentway", (Object)operationVariable.get("loan_repaymentway"));
                loan.set("settleintmode", (Object)operationVariable.get("loan_settleintmode"));
                loan.set("basis", (Object)operationVariable.get("loan_basis"));
                Long stagePlanId = Long.valueOf(operationVariable.get("loan_stageplan"));
                if (EmptyUtil.isNoEmpty((Long)stagePlanId)) {
                    loan.set("stageplan", (Object)BusinessDataServiceHelper.loadSingle((Object)stagePlanId, (String)"cfm_repayagingcheme", (String)"id"));
                }
                if (EmptyUtil.isNoEmpty((Long)(interestPlanId = Long.valueOf(operationVariable.get("loan_interestsettledplan"))))) {
                    loan.set("interestsettledplan", (Object)BusinessDataServiceHelper.loadSingle((Object)interestPlanId, (String)"cfm_inscheme", (String)"id"));
                }
                if (EmptyUtil.isNoEmpty((Long)(ratingAgencyId = Long.valueOf(operationVariable.get("loan_ratingagency"))))) {
                    loan.set("ratingagency", (Object)BusinessDataServiceHelper.loadSingle((Object)ratingAgencyId, (String)"tbd_ratingagency", (String)"id"));
                }
                loan.set("ratingscale", (Object)operationVariable.get("loan_ratingscale"));
                loan.set("debtratingscale", (Object)operationVariable.get("loan_debtratingscale"));
                Long custodianFinorgId = Long.valueOf(operationVariable.get("loan_custodianfinorg"));
                if (EmptyUtil.isNoEmpty((Long)custodianFinorgId)) {
                    loan.set("custodianfinorg", (Object)BusinessDataServiceHelper.loadSingle((Object)custodianFinorgId, (String)"bd_finorginfo", (String)"id"));
                }
                if (EmptyUtil.isNoEmpty((Long)(loanUseId = Long.valueOf(operationVariable.get("loan_use"))))) {
                    loan.set("loanuse", (Object)BusinessDataServiceHelper.loadSingle((Object)loanUseId, (String)"cas_fundflowitem", (String)"id"));
                }
                loan.set("underwritemethod", (Object)operationVariable.get("loan_underwritemethod"));
                String bondLimit = operationVariable.get("occupybondlimit");
                if (!EmptyUtil.isEmpty((Long)Long.valueOf(bondLimit))) {
                    loan.set("occupybondlimit", (Object)BusinessDataServiceHelper.loadSingle((Object)bondLimit, (String)"bdim_bond_limit", (String)"id"));
                }
                if (InterestTypeEnum.FLOAT.getValue().equals(loan.getString("interesttype"))) {
                    Long referenceRateId = Long.valueOf(operationVariable.get("loan_referencerate"));
                    if (EmptyUtil.isNoEmpty((Long)referenceRateId)) {
                        loan.set("referencerate", (Object)BusinessDataServiceHelper.loadSingle((Object)referenceRateId, (String)"tbd_referrate", (String)"id"));
                    }
                    loan.set("rateadjuststyle", (Object)operationVariable.get("loanrateadjuststyle"));
                    loan.set("ratesign", (Object)operationVariable.get("loanratesign"));
                    loan.set("ratefloatpoint", (Object)this.getBigDecimalPro(operationVariable, "loanratefloatpoint"));
                    if (RateAdjustStyleEnum.CYCLE.getValue().equals(loan.getString("rateadjuststyle"))) {
                        loan.set("rateadjustdate", (Object)this.getDatePro(operationVariable, "loanrateadjustdate"));
                        loan.set("rateadjustcycletype", (Object)operationVariable.get("loanrateadjusttype"));
                        loan.set("rateadjustcycle", (Object)operationVariable.get("loanrateadjustcycle"));
                    }
                }
            }
            if (!EmptyUtil.isNoEmpty((String)(plansJson = operationVariable.get("repaysubentry")))) continue;
            List planList = SerializationUtils.fromJsonStringToList((String)plansJson, RepayPlanBean.class);
            DynamicObjectCollection plans = loan.getDynamicObjectCollection("repayplan_entry");
            for (RepayPlanBean plan : planList) {
                DynamicObject p = plans.addNew();
                p.set("exrepaymentdate", (Object)plan.getExrepaymentdate());
                p.set("exdrawamount", (Object)plan.getExdrawamount());
                p.set("enotrepayamount", (Object)plan.getExdrawamount());
                p.set("repaymentdesc", (Object)plan.getRepaymentdesc());
                p.set("repaymentmodifier", (Object)RequestContext.get().getUserId());
                p.set("repaymentmodifytime", (Object)DateUtils.getCurrentTime());
            }
        }
    }

    private void dealInitUnderWriterEntryInfo(Map<String, String> operationVariable, DynamicObject loanBill) {
        String loanUnderWriterEntrySeriStr = operationVariable.get("loanUnderWriterEntrySeriStr");
        if (EmptyUtil.isEmpty((String)loanUnderWriterEntrySeriStr)) {
            return;
        }
        DynamicObjectType underWriterEnrtyType = ((DynamicCollectionProperty)((DynamicCollectionProperty)EntityMetadataCache.getDataEntityType((String)"cfm_initbill_bond").getProperty("loanentry")).getDynamicCollectionItemPropertyType().getProperty("underwriter_entry")).getDynamicCollectionItemPropertyType();
        Object[] underWriterInitEnrtys = DynamicObjectSerializeUtil.deserialize((String)loanUnderWriterEntrySeriStr, (DynamicObjectType)underWriterEnrtyType);
        DynamicObjectCollection underWriterEnrtys = loanBill.getDynamicObjectCollection("underwriter_entry");
        underWriterEnrtys.clear();
        int seq = 1;
        for (Object initUWEntryObj : underWriterInitEnrtys) {
            DynamicObject underWriterEnrty = underWriterEnrtys.addNew();
            underWriterEnrty.set("seq", (Object)seq++);
            DynamicObject initUWEntry = (DynamicObject)initUWEntryObj;
            underWriterEnrty.set("e_underwritertype", initUWEntry.get("e_underwritertype"));
            underWriterEnrty.set("e_isbookrunner", initUWEntry.get("e_isbookrunner"));
            underWriterEnrty.set("e_underwriter", initUWEntry.get("e_underwriter"));
            underWriterEnrty.set("e_underwriteratio", initUWEntry.get("e_underwriteratio"));
            underWriterEnrty.set("e_underwriteamount", initUWEntry.get("e_underwriteamount"));
        }
    }

    private void dealInitInvestorEntryInfo(Map<String, String> operationVariable, DynamicObject loanBill) {
        String loaninvestorEntrySeriStr = operationVariable.get("loaninvestorEntrySeriStr");
        if (EmptyUtil.isEmpty((String)loaninvestorEntrySeriStr)) {
            return;
        }
        DynamicObjectType investorEnrtyType = ((DynamicCollectionProperty)((DynamicCollectionProperty)EntityMetadataCache.getDataEntityType((String)"cfm_initbill_bond").getProperty("loanentry")).getDynamicCollectionItemPropertyType().getProperty("investor_entry")).getDynamicCollectionItemPropertyType();
        Object[] investorInitEnrtys = DynamicObjectSerializeUtil.deserialize((String)loaninvestorEntrySeriStr, (DynamicObjectType)investorEnrtyType);
        DynamicObjectCollection investorEnrtys = loanBill.getDynamicObjectCollection("investor_entry");
        investorEnrtys.clear();
        int seq = 1;
        for (Object investorInitEnrty : investorInitEnrtys) {
            DynamicObject investorEnrty = investorEnrtys.addNew();
            investorEnrty.set("seq", (Object)seq++);
            DynamicObject initinvestorEntry = (DynamicObject)investorInitEnrty;
            Long investorEntryId = initinvestorEntry.getLong("e_investorentryid");
            if (EmptyUtil.isNoEmpty((Long)investorEntryId)) {
                investorEnrty.set("id", (Object)investorEntryId);
            }
            investorEnrty.set("e_investortype", initinvestorEntry.get("e_investortype"));
            investorEnrty.set("e_investorname", initinvestorEntry.get("e_investorname"));
            investorEnrty.set("e_investamount", initinvestorEntry.get("e_investamount"));
            investorEnrty.set("e_investorid", initinvestorEntry.get("e_investorid"));
            investorEnrty.set("e_creditlimit", initinvestorEntry.get("e_vrcreditlimit"));
            investorEnrty.set("e_creditcurrency", initinvestorEntry.get("e_vrcreditcurrency"));
            investorEnrty.set("e_creditamt", initinvestorEntry.get("e_vrcreditamt"));
            investorEnrty.set("e_isselfsubscribe", initinvestorEntry.get("e_isselfsubscribe"));
            investorEnrty.set("e_buybackedamt", initinvestorEntry.get("e_buybackedamt"));
            investorEnrty.set("describe", initinvestorEntry.get("describe"));
            investorEnrty.set("e_avalinvestamt", initinvestorEntry.get("e_avalinvestamt"));
        }
    }

    private void setCreditLimit(DynamicObject loan, Map<String, String> operationVariable) {
        String creditlimit = operationVariable.get("creditlimit");
        if (!EmptyUtil.isEmpty((String)creditlimit) && !"0".equals(creditlimit)) {
            DynamicObject creditlimitDy = TmcDataServiceHelper.loadSingle((Object)Long.valueOf(creditlimit), (String)"cfm_creditlimit");
            loan.set("creditlimit", (Object)creditlimitDy);
            loan.set("creditlimitcurrency", (Object)creditlimitDy.getDynamicObject("currency"));
            if (EmptyUtil.isEmpty((BigDecimal)loan.getBigDecimal("repayamount"))) {
                CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)loan, null, (boolean)false, (Date)loan.getDate("bizdate"));
            }
        }
    }

    private void setEntryShareAmount(DynamicObject loan) {
        DynamicObject srcBill = loan.getDynamicObject("loancontractbill");
        if (BizTypeEnum.SL.getValue().equals(srcBill.get("loantype"))) {
            BigDecimal loanAmount;
            DynamicObject mbEntry;
            BigDecimal shareAmount;
            srcBill = BusinessDataServiceHelper.loadSingle((Object)srcBill.getPkValue(), (String)"cfm_loancontractbill", (String)"amount,currency,banksyndicate_entry.e_bank,banksyndicate_entry.e_shareamount,banksyndicate_entry.e_bankrole,banksyndicate_entry.e_contractamount");
            BigDecimal amount = srcBill.getBigDecimal("amount");
            BigDecimal drawAmount = loan.getBigDecimal("drawamount");
            BigDecimal ratio = drawAmount.divide(amount, 18, 4);
            DynamicObjectCollection loanBillEntrys = loan.getDynamicObjectCollection("banksyndicate_entry");
            Map<Long, DynamicObject> srcEntryMap = srcBill.getDynamicObjectCollection("banksyndicate_entry").stream().collect(Collectors.toMap(entry -> entry.getDynamicObject("e_bank").getLong("id"), entry -> entry));
            int amtPrecision = srcBill.getDynamicObject("currency").getInt("amtprecision");
            for (DynamicObject loanBillEntryRow : loanBillEntrys) {
                DynamicObject contractEntryRow = srcEntryMap.get(loanBillEntryRow.getDynamicObject("e_bank").getLong("id"));
                BigDecimal shareAmount2 = contractEntryRow.getBigDecimal("e_shareamount");
                loanBillEntryRow.set("e_shareamount", (Object)ratio.multiply(shareAmount2).setScale(amtPrecision, RoundingMode.HALF_UP));
            }
            BigDecimal totalShareAmount = loanBillEntrys.stream().map(o -> o.getBigDecimal("e_shareamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal subAmount = drawAmount.subtract(totalShareAmount);
            if (EmptyUtil.isEmpty((BigDecimal)subAmount)) {
                return;
            }
            List entryList = loanBillEntrys.stream().filter(o -> SlBankRoleEnum.isMb((String)o.getString("e_bankrole"))).collect(Collectors.toList());
            if (EmptyUtil.isNoEmpty(entryList) && (shareAmount = (mbEntry = (DynamicObject)entryList.get(0)).getBigDecimal("e_contractamount")).subtract(loanAmount = mbEntry.getBigDecimal("e_shareamount")).compareTo(subAmount) > 0) {
                mbEntry.set("e_shareamount", (Object)loanAmount.add(subAmount));
                subAmount = BigDecimal.ZERO;
            }
            this.setScaleAmount(loanBillEntrys, subAmount);
        }
    }

    private void setScaleAmount(DynamicObjectCollection bankCateEntrys, BigDecimal subAmount) {
        if (EmptyUtil.isEmpty((BigDecimal)subAmount)) {
            return;
        }
        for (DynamicObject bankCateEntry : bankCateEntrys) {
            if (SlBankRoleEnum.isMb((String)bankCateEntry.getString("e_bankrole"))) continue;
            BigDecimal shareAmount = bankCateEntry.getBigDecimal("e_shareamount");
            BigDecimal loanAmount = bankCateEntry.getBigDecimal("e_contractamount");
            BigDecimal eAmount = shareAmount.subtract(loanAmount);
            if (subAmount.compareTo(BigDecimal.ZERO) > 0 && eAmount.compareTo(subAmount) < 0) {
                subAmount = subAmount.subtract(eAmount);
                bankCateEntry.set("e_shareamount", (Object)shareAmount.add(eAmount));
                continue;
            }
            bankCateEntry.set("e_shareamount", (Object)shareAmount.add(subAmount));
            break;
        }
    }

    private void dealInitGmSubEntry(DynamicObject[] dataEntities, LoanBillSaveParam saveParam) {
        Map<String, String> operationVariable = saveParam.getOperationVariable();
        String gmSubEntrySeriStr = operationVariable.get("gmSubEntrySeriStr");
        if (EmptyUtil.isEmpty((String)gmSubEntrySeriStr)) {
            return;
        }
        ArrayList<GuaranteeUseBean> gUseList = new ArrayList<GuaranteeUseBean>(8);
        for (DynamicObject loanBill : dataEntities) {
            DynamicObjectType gumSubEntryType = ((DynamicCollectionProperty)((DynamicCollectionProperty)EntityMetadataCache.getDataEntityType((String)"cfm_initbill").getProperty("loanentry")).getDynamicCollectionItemPropertyType().getProperty("gmsubentry")).getDynamicCollectionItemPropertyType();
            Object[] loanFeeEntry = DynamicObjectSerializeUtil.deserialize((String)gmSubEntrySeriStr, (DynamicObjectType)gumSubEntryType);
            long initPkId = loanBill.getLong("id");
            String formId = Optional.ofNullable(operationVariable.get("gmSubEntryPageSaveOp")).orElseGet(() -> loanBill.getDataEntityType().getName());
            String billNo = loanBill.getString("billno");
            String cParty = loanBill.getString("textcreditor");
            TreeMap<String, ArrayList<DynamicObject>> sumGcMap = new TreeMap<String, ArrayList<DynamicObject>>();
            for (Object initLBObj : loanFeeEntry) {
                DynamicObject initLB = (DynamicObject)initLBObj;
                if (EmptyUtil.isEmpty((DynamicObject)initLB.getDynamicObject("gcontract"))) continue;
                String creditorType = initLB.getString("gcreditortype");
                Long creditor = initLB.getLong("gcreditor");
                ArrayList<DynamicObject> gcTemp = (ArrayList<DynamicObject>)sumGcMap.get(creditorType + creditor);
                if (gcTemp == null) {
                    gcTemp = new ArrayList<DynamicObject>(loanFeeEntry.length);
                }
                gcTemp.add(initLB);
                sumGcMap.put(creditorType + creditor, gcTemp);
            }
            BigDecimal bizAmount = loanBill.getBigDecimal("drawamount");
            Map bizAmountMap = GuaranteeUseHelper.getBankSyncMap((String)loanBill.getDataEntityType().getName(), (DynamicObject)loanBill);
            Long debtOrg = Optional.ofNullable(loanBill.getDynamicObject("org")).map(r -> r.getLong("id")).orElse(0L);
            String debtOrgText = Optional.ofNullable(loanBill.getDynamicObject("org")).map(r -> r.getString("name")).orElse("");
            DynamicObject debtCurrency = loanBill.getDynamicObject("currency");
            Long debtCurrencyId = Optional.ofNullable(debtCurrency).map(r -> r.getLong("id")).orElse(0L);
            Date startDate = loanBill.getDate("bizdate");
            Date endDate = loanBill.getDate("expiredate");
            for (Map.Entry entry : sumGcMap.entrySet()) {
                List initLBList = (List)entry.getValue();
                if (EmptyUtil.isEmpty((Collection)initLBList)) continue;
                bizAmount = bizAmountMap.containsKey(entry.getKey()) ? (BigDecimal)bizAmountMap.get(entry.getKey()) : bizAmount;
                BigDecimal sumRatio = initLBList.stream().map(g -> g.getBigDecimal("gratio")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal sumAmount = BigDecimal.ZERO;
                for (int i = 0; i < initLBList.size(); ++i) {
                    BigDecimal gAmount;
                    DynamicObject initLB = (DynamicObject)initLBList.get(i);
                    if (Constants.ONE_HUNDRED.compareTo(sumRatio) == 0 && i == initLBList.size() - 1) {
                        gAmount = bizAmount.subtract(sumAmount);
                    } else {
                        gAmount = bizAmount.multiply(initLB.getBigDecimal("gratio")).divide(Constants.ONE_HUNDRED, EmptyUtil.isEmpty((DynamicObject)debtCurrency) ? 6 : debtCurrency.getInt("amtprecision"), RoundingMode.HALF_UP);
                        sumAmount = sumAmount.add(gAmount);
                    }
                    GuaranteeUseBean gUse = new GuaranteeUseBean();
                    gUse.setSrcBillId(Long.valueOf(initPkId));
                    gUse.setSrcBillType(formId);
                    gUse.setSrcBillNo(billNo);
                    gUse.setgContractId(Long.valueOf(initLB.getDynamicObject("gcontract").getLong("id")));
                    gUse.setBizAmount(bizAmount);
                    gUse.setComment(initLB.getString("gcomment"));
                    gUse.setgAmount(gAmount);
                    gUse.setgRatio(initLB.getBigDecimal("gratio"));
                    gUse.setExchrate(initLB.getBigDecimal("gexchrate"));
                    gUse.setDebtOrgId(debtOrg);
                    gUse.setDebtOrgText(debtOrgText);
                    gUse.setDebtCurrencyId(debtCurrencyId);
                    gUse.setCparty(cParty);
                    gUse.setDebtStartDate(startDate);
                    gUse.setDebtEndDate(endDate);
                    gUse.setgCreditorType(initLB.getString("gcreditortype"));
                    gUse.setgCreditor(Long.valueOf(initLB.getLong("gcreditor")));
                    gUse.setgCreditorText(initLB.getString("gcreditortext"));
                    gUseList.add(gUse);
                }
            }
        }
        if (EmptyUtil.isNoEmpty(gUseList)) {
            GuaranteeUseHelper.saveGuaranteeUse(gUseList);
            GuaranteeUseHelper.confirmGuaranteeUse((DynamicObject[])dataEntities);
        }
    }

    private void doByInitOnBeforeCommit(DynamicObject[] dataEntities, LoanBillSaveParam saveParam) {
        Map<String, String> operationVariable = saveParam.getOperationVariable();
        this.createRepaymentBill(dataEntities, operationVariable);
        this.createInterestBill(dataEntities, operationVariable);
        this.saveLoanbill(dataEntities, operationVariable);
    }

    private void saveLoanbill(DynamicObject[] dataEntities, Map<String, String> operationVariable) {
        for (DynamicObject loan : dataEntities) {
            Date endInstdate = this.getDatePro(operationVariable, "endinstdate");
            DynamicObject loanDb = BusinessDataServiceHelper.loadSingle((Object)loan.getPkValue(), (String)this.getLoanEntityName(loan));
            if (endInstdate == null) continue;
            loanDb.set("endinstdate", (Object)endInstdate);
            loanDb.set("lastpayinstdate", (Object)DateUtils.getNextDay((Date)endInstdate, (int)1));
            Date endPreInstDate = this.getDatePro(operationVariable, "endpreinstdate");
            if (endPreInstDate == null || endInstdate.compareTo(endPreInstDate) > 0) {
                loanDb.set("endpreinstdate", (Object)endInstdate);
                loanDb.set("initendpreinstdate", (Object)endInstdate);
            }
            String interestType = operationVariable.get("interesttype");
            if (InterestTypeEnum.FLOAT.getValue().equals(interestType)) {
                loanDb.set("interesttype", (Object)InterestTypeEnum.FLOAT.getValue());
                loanDb.set("ratesign", (Object)operationVariable.get("loanratesign"));
                loanDb.set("ratefloatpoint", (Object)this.getBigDecimalPro(operationVariable, "loanratefloatpoint"));
                String loanrateadjuststyle = operationVariable.get("loanrateadjuststyle");
                loanDb.set("rateadjuststyle", (Object)loanrateadjuststyle);
                if (RateAdjustStyleEnum.CYCLE.getValue().equals(loanrateadjuststyle)) {
                    loanDb.set("rateadjustdate", (Object)this.getDatePro(operationVariable, "loanrateadjustdate"));
                    loanDb.set("rateadjustcycle", (Object)this.getBigDecimalPro(operationVariable, "loanrateadjustcycle"));
                }
            }
            BusinessHelper.fillConfirmInfo((DynamicObject)loanDb);
            CfmBillCommonHelper.constomSaveOp((DynamicObject)loanDb);
        }
    }

    private void createInterestBill(DynamicObject[] dataEntities, Map<String, String> operationVariable) {
        for (DynamicObject loan : dataEntities) {
            BigDecimal payinterestamount = this.getBigDecimalPro(operationVariable, "payinterestamount");
            boolean isYkx = LoanBillHelper.isYkx((DynamicObject)loan);
            if (BigDecimal.ZERO.compareTo(payinterestamount) == 0 && !isYkx) continue;
            if (isYkx) {
                String props = "interest_entry.intenddate,interest_entry.interestcalamount";
                DynamicObjectCollection intPlans = QueryServiceHelper.query((String)loan.getDataEntityType().getName(), (String)props, (QFilter[])new QFilter("id", "=", loan.getPkValue()).toArray());
                if (intPlans.isEmpty()) continue;
                DynamicObject intPlan = (DynamicObject)intPlans.get(0);
                Date endIntDate = intPlan.getDate("interest_entry.intenddate");
                operationVariable.put("endinstdate", DateUtils.formatString((Date)endIntDate, (String)"yyyyMMdd"));
                operationVariable.put("instbillctg", InterestbillctgEnum.PREPAYINT.getValue());
                loan.set("payedintamount", (Object)operationVariable.get("payinterestamount"));
                loan.set("endinstdate", (Object)endIntDate);
            }
            OperateOption create = OperateOption.create();
            create.setVariableValue("byInit", "true");
            create.setVariableValue("endinstdate", operationVariable.get("endinstdate"));
            create.setVariableValue("payinterestamount", operationVariable.get("payinterestamount"));
            create.setVariableValue("loadacctbank", operationVariable.get("loadacctbank"));
            create.setVariableValue("renewalinterestrate", operationVariable.get("renewalinterestrate"));
            create.setVariableValue("instbillctg", operationVariable.get("instbillctg"));
            TmcOperateServiceHelper.execOperate((String)"intersetinitpushandsave", (String)this.getLoanEntityName(loan), (DynamicObject[])new DynamicObject[]{loan}, (OperateOption)create);
        }
    }

    private void createRepaymentBill(DynamicObject[] dataEntities, Map<String, String> operationVariable) {
        for (DynamicObject loan : dataEntities) {
            Long loanBillId = loan.getLong("id");
            String dataSource = loan.getString("datasource");
            if (DataSourceEnum.IFM.getValue().equals(dataSource)) {
                TmcBotpHelper.saveRelation((String)"cfm_loancontractbill", (Long)loan.getLong("sourcebillid"), (String)"cfm_loanbill", (Long)loanBillId);
            } else {
                BusinessHelper.fillConfirmInfo((DynamicObject)loan);
            }
            LoanWriteBackHelper.writeBack((Long)loanBillId, (LoanWBTypeEnum)LoanWBTypeEnum.REPAYPLAN);
            BigDecimal repayAmount = this.getBigDecimalPro(operationVariable, "repayamount");
            if (BigDecimal.ZERO.compareTo(repayAmount) == 0) continue;
            OperateOption create = OperateOption.create();
            create.setVariableValue("byInit", "true");
            create.setVariableValue("repaydate", operationVariable.get("repaydate"));
            create.setVariableValue("repayamount", operationVariable.get("repayamount"));
            create.setVariableValue("payinterestamount", operationVariable.get("payinterestamount"));
            create.setVariableValue("loadacctbank", operationVariable.get("loadacctbank"));
            TmcOperateServiceHelper.execOperate((String)"repaymentinitpushandsave", (String)this.getLoanEntityName(loan), (DynamicObject[])new DynamicObject[]{loan}, (OperateOption)create);
        }
    }

    private BigDecimal getBigDecimalPro(Map<String, String> operationVariable, String pro) {
        return new BigDecimal(operationVariable.get(pro));
    }

    private Date getDatePro(Map<String, String> operationVariable, String pro) {
        if (EmptyUtil.isEmpty((String)operationVariable.get(pro))) {
            return null;
        }
        return DateUtils.stringToDate((String)operationVariable.get(pro), (String)"yyyyMMdd");
    }

    private String getLoanEntityName(DynamicObject loanBill) {
        String dataSource = loanBill.getString("datasource");
        if (DataSourceEnum.IFM.getValue().equals(dataSource)) {
            return "ifm_loanbill";
        }
        if (DataSourceEnum.BOND.getValue().equals(dataSource)) {
            return "cfm_loanbill_bond";
        }
        if (DataSourceEnum.INVEST.getValue().equals(dataSource)) {
            return "cim_invest_loanbill";
        }
        return "cfm_loanbill";
    }
}

