/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.loanbill.save;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.cfm.business.opservice.loanbill.save.LoanBillSaveParam;
import kd.tmc.cfm.common.bean.LoanWriteParam;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.EasMigrateHelper;
import kd.tmc.cfm.common.helper.LoanBillRepayPlanHelper;
import kd.tmc.cfm.common.helper.LoanWriteBackHelper;
import kd.tmc.fbp.business.opservice.common.chain.AbstractBusinessBatchHandler;
import kd.tmc.fbp.business.opservice.common.chain.BusinessHandleParam;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillSaveFromIscHandler
extends AbstractBusinessBatchHandler {
    public void doBeforeProcess(DynamicObject[] bizBills, BusinessHandleParam param) {
        LoanBillRepayPlanHelper.autoGenRepayPlan((DynamicObject[])bizBills);
    }

    public void doProcess(DynamicObject[] bizBills, BusinessHandleParam param) {
    }

    public void doBeforeCommit(DynamicObject[] bizBills, BusinessHandleParam param) {
        this.handleOpFromIsc(bizBills);
    }

    public boolean doFilter(DynamicObject[] bizBills, BusinessHandleParam param) {
        return ((LoanBillSaveParam)param.getInParam()).isFromIsc();
    }

    private void handleOpFromIsc(DynamicObject[] dataEntities) {
        List<DynamicObject> loanBills = Arrays.asList(dataEntities);
        List loanBillIds = BusinessHelper.getBizBillIds(loanBills);
        Set contractIds = loanBills.stream().filter(d -> EmptyUtil.isNoEmpty((DynamicObject)d.getDynamicObject("loancontractbill"))).map(d -> d.getLong("loancontractbill.id")).collect(Collectors.toSet());
        LoanWriteBackHelper.writeBack((LoanWriteParam)LoanWriteParam.build((List)loanBillIds, (LoanWBTypeEnum)LoanWBTypeEnum.REPAYPLAN).setReSaveLoan(true).setFromIsc(true));
        LoanWriteBackHelper.writeBack((LoanWriteParam)LoanWriteParam.buildLoanBill(loanBills, (LoanWBTypeEnum)LoanWBTypeEnum.UPDATECONTRACT).setReSaveLoan(true).setFromIsc(true));
        for (Long contractId : contractIds) {
            EasMigrateHelper.mergeGuaranteeUseToContract((Long)contractId);
        }
    }
}

