/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.loanbill.save;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.tmc.cfm.business.opservice.loanbill.save.LoanBillSaveParam;
import kd.tmc.cfm.common.bean.LoanWriteParam;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.CfmContractBillHelper;
import kd.tmc.cfm.common.helper.CreditLimitHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.helper.LoanBillRepayPlanHelper;
import kd.tmc.cfm.common.helper.LoanWriteBackHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.opservice.common.chain.AbstractBusinessBatchHandler;
import kd.tmc.fbp.business.opservice.common.chain.BusinessHandleParam;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;

public class LoanBillSaveHandler
extends AbstractBusinessBatchHandler {
    public void doBeforeProcess(DynamicObject[] bizBills, BusinessHandleParam param) {
        LoanBillRepayPlanHelper.autoGenRepayPlan((DynamicObject[])bizBills);
    }

    public void doProcess(DynamicObject[] bizBills, BusinessHandleParam param) {
        this.doOnProcess(bizBills, (LoanBillSaveParam)param.getInParam());
    }

    public void doBeforeCommit(DynamicObject[] bizBills, BusinessHandleParam param) {
        this.doOnBeforeCommit(bizBills, param);
    }

    public boolean doFilter(DynamicObject[] bizBills, BusinessHandleParam param) {
        LoanBillSaveParam saveParam = (LoanBillSaveParam)param.getInParam();
        return !saveParam.isByInit() && !saveParam.isFromIsc() && !this.isLeaseLoanBill(bizBills[0]);
    }

    private void doOnBeforeCommit(DynamicObject[] bizBills, BusinessHandleParam param) {
        List loanBillIds = Arrays.stream(bizBills).map(d -> d.getLong("id")).collect(Collectors.toList());
        LoanWriteBackHelper.writeBack((LoanWriteParam)LoanWriteParam.build(loanBillIds, (LoanWBTypeEnum)LoanWBTypeEnum.REPAYPLAN).setBond(LoanBillHelper.isBond((DynamicObject)bizBills[0])));
    }

    private void doOnProcess(DynamicObject[] dataEntities, LoanBillSaveParam saveParam) {
        Map<String, String> operationVariable = saveParam.getOperationVariable();
        OperationResult operationResult = saveParam.getOperationResult();
        for (DynamicObject data : dataEntities) {
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(data.getString("datasource"));
            if (data.getBigDecimal("repayamount").compareTo(BigDecimal.ZERO) == 0 && data.getBigDecimal("notrepayamount").compareTo(BigDecimal.ZERO) == 0) {
                data.set("notrepayamount", (Object)data.getBigDecimal("drawamount"));
            }
            if (operationResult.isSuccess() && ("1".equals(operationVariable.get("showmessagetype")) || "2".equals(operationVariable.get("showmessagetype")))) {
                operationResult.setMessage(bizResource.getLbSaveSucc());
            }
            if (!this.checkRepayPlan(data).booleanValue()) {
                operationResult.setMessage(bizResource.getLbSaveTips());
            }
            if (BillStatusEnum.SAVE.getValue().equals(data.getString("billstatus")) && CfmContractBillHelper.creditPreUse((String)data.getString("loantype"), (String)data.getString("creditortype"))) {
                DynamicObject applybill = BusinessHelper.getLoanApplyBill((DynamicObject)data.getDynamicObject("loancontractbill"));
                String loanType = data.getString("loantype");
                if (LoanTypeEnum.isBanksLoan((String)loanType)) {
                    CreditLimitHelper.creditBizSave((DynamicObject)data, (DynamicObject)applybill, (String)"banksyndicate_entry", (String)"e_bankcreditlimit");
                } else {
                    CreditLimitHelper.creditBizSave((DynamicObject)data, (DynamicObject)applybill, null, null);
                }
            }
            if (StringUtils.equals((CharSequence)data.getDynamicObjectType().getName(), (CharSequence)"cfm_loanbill_bond")) continue;
            String term = DateUtils.getDiff_ymd((Date)data.getDate("startintdate"), (Date)data.getDate("expiredate"));
            data.set("term", (Object)term);
        }
    }

    private Boolean checkRepayPlan(DynamicObject loanBillDO) {
        DynamicObjectCollection loanBillScheduleDC = loanBillDO.getDynamicObjectCollection("repayplan_entry");
        if (loanBillScheduleDC.size() > 0) {
            Date loanDate = loanBillDO.getDate("bizdate");
            Date expireDate = loanBillDO.getDate("expiredate");
            Date startDate = ((DynamicObject)loanBillScheduleDC.get(0)).getDate("exrepaymentdate");
            Date endDate = ((DynamicObject)loanBillScheduleDC.get(loanBillScheduleDC.size() - 1)).getDate("exrepaymentdate");
            if (startDate.compareTo(loanDate) <= 0 || endDate.after(expireDate)) {
                return Boolean.FALSE;
            }
            BigDecimal exdrawamount = new BigDecimal(0);
            for (int i = 0; i < loanBillScheduleDC.size(); ++i) {
                exdrawamount = exdrawamount.add(((DynamicObject)loanBillScheduleDC.get(i)).getBigDecimal("exdrawamount"));
            }
            BigDecimal drawamount = loanBillDO.getBigDecimal("drawamount");
            if (exdrawamount.compareTo(drawamount) != 0) {
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    protected boolean isLeaseLoanBill(DynamicObject data) {
        return data.getDynamicObjectType().getName().equals("fl_receiptbill");
    }
}

