/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.loancontractbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.BondLimitHelper;
import kd.tmc.cfm.common.helper.CreditLimitHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.ReturnCreditLimitInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class LoanContractBillActiveService
extends AbstractTmcBizOppService {
    private static final String COMMA_CHAR = ",";
    private static final String PERIOD_CHAR = ".";
    private static final String[] LOAN_APPLY_PROP = new String[]{"id", "billno", "amount", "creditlimit"};
    private static final String[] LOAN_BOND_PROP = new String[]{"id", "drawtype", "repayamount", "notrepayamount", "calculaterateamount", "lastrepaydate", "lastpayinstdate", "ishandend", "creditlimit", "billno", "drawamount", "datasource", "occupybondlimit", "org", "bizdate", "expiredate", "currency", "closeoffdate", String.join((CharSequence)".", "investor_entry", "e_creditlimit"), String.join((CharSequence)".", "investor_entry", "e_creditamt"), String.join((CharSequence)".", "investor_entry", "e_investamount")};
    private static final String[] CFM_LOAN_PROP = new String[]{"id", "drawtype", "repayamount", "notrepayamount", "calculaterateamount", "lastrepaydate", "lastpayinstdate", "ishandend", "datasource", "creditlimit", "closeoffdate", "billno"};

    public List<String> getSelector() {
        List sl = super.getSelector();
        sl.add("contractstatus");
        sl.add("ishandend");
        sl.add("creditlimit");
        sl.add("lenderapplyno");
        sl.add("loantype");
        sl.add("closeoffdate");
        sl.add("issyncdraw");
        sl.add("banksyndicate_entry");
        sl.add("banksyndicate_entry.e_creditlimit");
        sl.add("banksyndicate_entry.e_creditamt");
        return sl;
    }

    public void process(DynamicObject[] contractBills) throws KDException {
        for (DynamicObject info : contractBills) {
            boolean creditLimitFlag = false;
            if (null != info.get("creditlimit")) {
                this.cancelReturnCreditLimit(info);
                creditLimitFlag = true;
            } else if (LoanTypeEnum.BANKSLOAN.getValue().equals(info.get("loantype"))) {
                creditLimitFlag = this.cancelReturnBanksLoanCreditLimit(info);
            } else {
                this.cancelLoanApplyCreditLimit(info);
            }
            String contractStatus = LoanContractStatusEnum.EXECUTING.getValue();
            Object[] downLoanBills = this.getDownLoadBills(info);
            this.dealDownLoadBill((DynamicObject[])downLoanBills, creditLimitFlag);
            if (EmptyUtil.isEmpty((Object[])downLoanBills)) {
                contractStatus = LoanContractStatusEnum.REGISTERED.getValue();
            }
            info.set("ishandend", (Object)false);
            info.set("contractstatus", (Object)contractStatus);
            info.set("closeoffdate", null);
        }
        SaveServiceHelper.save((DynamicObject[])contractBills);
    }

    private boolean cancelReturnBanksLoanCreditLimit(DynamicObject contract) {
        DynamicObject creditUseBill;
        DynamicObjectCollection bankEntries = contract.getDynamicObjectCollection("banksyndicate_entry");
        List entryCredList = bankEntries.stream().filter(o -> o.getDynamicObject("e_creditlimit") != null).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(entryCredList)) {
            return false;
        }
        boolean isSynLoan = contract.getBoolean("issyncdraw");
        if (isSynLoan && (EmptyUtil.isEmpty((DynamicObject)(creditUseBill = CreditLimitHelper.getCreditUseBill((Long)contract.getLong("id"), (String)contract.getDataEntityType().getName()))) || !BillStatusEnum.isAudit((String)creditUseBill.getString("billstatus")))) {
            return false;
        }
        HashMap<Long, BigDecimal> entryReturnAmtMap = new HashMap<Long, BigDecimal>(entryCredList.size());
        for (DynamicObject entryCred : entryCredList) {
            entryReturnAmtMap.put(entryCred.getLong("id"), entryCred.getBigDecimal("e_creditamt"));
        }
        ReturnCreditLimitInfo returnInfo = this.getReturnInfo(contract);
        returnInfo.setId(Long.valueOf(contract.getLong("id")));
        returnInfo.setEntityName(contract.getDataEntityType().getName());
        returnInfo.setReturnBillId(Long.valueOf(contract.getLong("id")));
        returnInfo.setEntryReturnAmtMap(entryReturnAmtMap);
        CreditLimitServiceHelper.cancelReturnCreditLimit((ReturnCreditLimitInfo)returnInfo);
        return true;
    }

    private ReturnCreditLimitInfo getReturnInfo(DynamicObject bill) {
        ReturnCreditLimitInfo param = new ReturnCreditLimitInfo();
        param.setPreOccupy(false);
        param.setPreEntityName(bill.getDynamicObjectType().getName());
        param.setBizBillId((Long)bill.getPkValue());
        param.setReturnTime(DateUtils.getCurrentDate());
        return param;
    }

    private void cancelLoanApplyCreditLimit(DynamicObject bill) {
        String lenderApplyNo = bill.getString("lenderapplyno");
        if (StringUtils.isEmpty((CharSequence)lenderApplyNo)) {
            return;
        }
        DynamicObject loanApply = TmcDataServiceHelper.loadSingle((String)"cfm_loan_apply", (String)String.join((CharSequence)COMMA_CHAR, LOAN_APPLY_PROP), (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)lenderApplyNo)});
        if (null != loanApply.get("creditlimit")) {
            CreditLimitServiceHelper.cancelReturnCreditLimit((DynamicObject)bill, (DynamicObject)loanApply, (boolean)true, (BigDecimal)loanApply.getBigDecimal("amount"), (Long)bill.getLong("id"));
        }
    }

    private void dealDownLoadBill(DynamicObject[] downLoanBills, boolean creditLimitFlag) {
        ArrayList<ReturnCreditLimitInfo> paramList = new ArrayList<ReturnCreditLimitInfo>(downLoanBills.length);
        for (DynamicObject downLoanBill : downLoanBills) {
            if (!downLoanBill.getBoolean("ishandend")) continue;
            String loanStatus = DrawTypeEnum.PARTPAYMENT.getValue();
            BigDecimal repayAmount = downLoanBill.getBigDecimal("repayamount");
            BigDecimal notRepayAmount = downLoanBill.getBigDecimal("notrepayamount");
            Date lastRepayDate = downLoanBill.getDate("lastrepaydate");
            Date lastPayInstDate = downLoanBill.getDate("lastpayinstdate");
            boolean isPayLastInst = false;
            if (EmptyUtil.isNoEmpty((Object)lastRepayDate) && EmptyUtil.isNoEmpty((Object)lastPayInstDate) && lastPayInstDate.compareTo(lastRepayDate) >= 0) {
                isPayLastInst = true;
            }
            if (repayAmount.compareTo(BigDecimal.ZERO) == 0) {
                loanStatus = DrawTypeEnum.DRAWED.getValue();
            } else if (!isPayLastInst && notRepayAmount.compareTo(BigDecimal.ZERO) == 0) {
                loanStatus = DrawTypeEnum.ALLPAYMENT.getValue();
            } else if (isPayLastInst && notRepayAmount.compareTo(BigDecimal.ZERO) == 0) {
                loanStatus = DrawTypeEnum.CLOSEOUT.getValue();
            }
            if (StringUtils.equals((CharSequence)downLoanBill.getDataEntityType().getName(), (CharSequence)"cfm_loanbill_bond")) {
                this.dealActiveBondLimit(downLoanBill, paramList);
            } else if (!creditLimitFlag && null != downLoanBill.get("creditlimit")) {
                paramList.add(this.getReturnCreditLimitInfo(downLoanBill));
            }
            downLoanBill.set("drawtype", (Object)loanStatus);
            downLoanBill.set("closeoffdate", null);
            downLoanBill.set("ishandend", (Object)false);
        }
        if (EmptyUtil.isNoEmpty((Object[])downLoanBills)) {
            SaveServiceHelper.save((DynamicObject[])downLoanBills);
        }
        if (!paramList.isEmpty()) {
            CreditLimitServiceHelper.batchCancelReturnCreditLimit(paramList);
        }
    }

    private ReturnCreditLimitInfo getReturnCreditLimitInfo(DynamicObject bill) {
        ReturnCreditLimitInfo param = new ReturnCreditLimitInfo();
        param.setId((Long)bill.getPkValue());
        param.setEntityName(LoanContractBillActiveService.getLoanEntityName(bill.getString("datasource")));
        DynamicObject creditUseBill = CreditLimitHelper.getCreditUseBill((Long)bill.getLong("id"), null);
        if (EmptyUtil.isNoEmpty((DynamicObject)creditUseBill)) {
            param.setEntityName(creditUseBill.getString("sourcetype"));
        }
        param.setPreOccupy(false);
        param.setReturnBillId(Long.valueOf(bill.getLong("id")));
        param.setBizBillId(Long.valueOf(bill.getLong("id")));
        return param;
    }

    private static String getLoanEntityName(String dataSource) {
        HashMap<String, String> entityMap = new HashMap<String, String>(8);
        entityMap.put(DataSourceEnum.CFM.getValue(), "cfm_loanbill");
        entityMap.put(DataSourceEnum.INVEST.getValue(), "cim_invest_loanbill");
        entityMap.put(DataSourceEnum.IFM.getValue(), "ifm_loanbill");
        entityMap.put(DataSourceEnum.BOND.getValue(), "cfm_loanbill_bond");
        return (String)entityMap.get(dataSource);
    }

    private void dealActiveBondLimit(DynamicObject bill, List<ReturnCreditLimitInfo> returnCreditLimitList) {
        if (null != bill.get("occupybondlimit")) {
            bill.getDynamicObjectType().setExtendName(bill.getDataEntityType().getName());
            BondLimitHelper.changeLimitOnSubmit((DynamicObject)bill, (Object)bill.getDynamicObject("occupybondlimit").getPkValue(), (BigDecimal)bill.getBigDecimal("drawamount"));
        }
        this.dealActiveBondCreditLimit(bill, returnCreditLimitList);
    }

    private void cancelReturnCreditLimit(DynamicObject bill) {
        CreditLimitServiceHelper.cancelReturnCreditLimit((DynamicObject)bill, (DynamicObject)bill, (boolean)false, (Long)bill.getLong("id"), (boolean)true);
    }

    private void dealActiveBondCreditLimit(DynamicObject bill, List<ReturnCreditLimitInfo> returnCreditLimitList) {
        DynamicObjectCollection investEntries = bill.getDynamicObjectCollection("investor_entry");
        long creditLimitEntries = investEntries.stream().filter(o -> o.getDynamicObject("e_creditlimit") != null).count();
        if (creditLimitEntries < 1L) {
            return;
        }
        returnCreditLimitList.add(this.getReturnCreditLimitInfo(bill));
    }

    private DynamicObject[] getDownLoadBills(DynamicObject contractBill) {
        QFilter qFilter = new QFilter("sourcebillid", "=", contractBill.getPkValue());
        if (StringUtils.equals((CharSequence)contractBill.getDataEntityType().getName(), (CharSequence)"cfm_loancontract_bo")) {
            return TmcDataServiceHelper.load((String)"cfm_loanbill_bond", (String)String.join((CharSequence)COMMA_CHAR, LOAN_BOND_PROP), (QFilter[])qFilter.toArray());
        }
        return TmcDataServiceHelper.load((String)"cfm_loanbill", (String)String.join((CharSequence)COMMA_CHAR, CFM_LOAN_PROP), (QFilter[])qFilter.toArray());
    }
}

