/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.loancontractbill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.cfm.common.enums.SettleCenterStatusEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.CfmContractBillHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;

public class LoanContractBillAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("confirmstatus");
        sic.add("lendernature");
        sic.add("contractstatus");
        sic.add("creditorg");
        sic.add("org");
        sic.add("sourcebillid");
        sic.add("lenderapplyno");
        sic.add("datasource");
        sic.add("textdebtor");
        sic.add("textcreditor");
        sic.add("confirmer");
        sic.add("confirmtime");
        sic.add("productfactory");
        sic.add("settlestatus");
        sic.add("creditortype");
        sic.add("loantype");
        sic.add("issyncdraw");
        sic.add("drawway");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject loanContractBill : dataEntities) {
            loanContractBill.set("confirmstatus", (Object)ConfirmStatusEnum.WAITCONFIRM.getValue());
            String creditorType = loanContractBill.getString("creditortype");
            if (CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType)) {
                loanContractBill.set("settlestatus", (Object)SettleCenterStatusEnum.ACCEPT.getValue());
                continue;
            }
            if (!BusinessHelper.isAutoConfirm((DynamicObject)loanContractBill)) continue;
            loanContractBill.set("contractstatus", (Object)LoanContractStatusEnum.REGISTER.getValue());
            loanContractBill.set("contractstatus", (Object)LoanContractStatusEnum.REGISTERED.getValue());
            BusinessHelper.fillConfirmInfo((DynamicObject)loanContractBill);
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        CfmContractBillHelper.setLoanApplyBillConfirmStatus((DynamicObject[])dataEntities, (boolean)false);
    }
}

