/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.loancontractbill;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.tmc.cfm.business.helper.LoanContractHelper;
import kd.tmc.cfm.common.enums.DrawWayEnum;
import kd.tmc.cfm.common.helper.CfmAttachmentHelper;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.CfmContractBillHelper;
import kd.tmc.cfm.common.helper.CreditLimitHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanContractBillSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("notdrawamount");
        sic.add("returnreason");
        sic.add("currency");
        sic.add("amount");
        sic.add("registorg");
        sic.add("datasource");
        sic.add("lendernature");
        sic.add("org");
        sic.add("sourcebillid");
        sic.add("lenderapplyno");
        sic.add("datasource");
        sic.add("rateadjustcycletype");
        sic.add("creditorg");
        sic.add("creditor");
        sic.add("creditortype");
        sic.add("textcreditor");
        sic.add("debtortype");
        sic.add("debtor");
        sic.add("textdebtor");
        sic.add("finproduct");
        sic.add("productfactory");
        sic.add("creditlimit");
        sic.add("loanapply");
        sic.add("e_creditlimit");
        sic.add("e_bank");
        sic.add("e_bankrole");
        sic.add("loantype");
        sic.add("startdate");
        sic.add("enddate");
        sic.add("iscycleloan");
        sic.add("drawway");
        sic.add("issyncdraw");
        sic.add("synccreditlimit");
        sic.add("isnofixedterm");
        sic.add("billstatus");
        sic.add("isinit");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        CfmBillCommonHelper.setNeedSaveFieldValue((DynamicObject[])dataEntities);
        CfmContractBillHelper.dealFieldValueOnSave((DynamicObject[])dataEntities);
        CfmContractBillHelper.resetApplyBillConfirmStatus((DynamicObject[])dataEntities);
        CfmContractBillHelper.setDrawPlanOrder((DynamicObject[])dataEntities);
        boolean isByInit = "true".equals(this.operationVariable.get("byInit"));
        for (DynamicObject contractDO : dataEntities) {
            LoanContractHelper.setCreditorInfo(contractDO);
            CfmBillCommonHelper.setLenderNature((DynamicObject)contractDO);
            String loanType = contractDO.getString("loantype");
            Date startDate = contractDO.getDate("startdate");
            Date endDate = contractDO.getDate("enddate");
            if (EmptyUtil.isNoEmpty((Object)startDate) && EmptyUtil.isNoEmpty((Object)endDate)) {
                String term = DateUtils.getDiff_ymd((Date)startDate, (Date)endDate);
                contractDO.set("term", (Object)term);
            }
            if (!CfmContractBillHelper.mayUseCreditLimit((DynamicObject)contractDO)) {
                contractDO.set("creditlimit", null);
            }
            if (isByInit) {
                CreditLimitHelper.creditBizSubmit((DynamicObject)contractDO, null, (String)"banksyndicate_entry", (String)"e_creditlimit");
                continue;
            }
            String billStatus = contractDO.getString("billstatus");
            if (BillStatusEnum.isSubmit((String)billStatus) || BillStatusEnum.isAudit((String)billStatus)) continue;
            contractDO.set("notdrawamount", (Object)contractDO.getBigDecimal("amount"));
            if (DrawWayEnum.ONCE.getValue().equals(contractDO.getString("drawway"))) {
                contractDO.set("iscycleloan", (Object)false);
            }
            if (!CfmContractBillHelper.creditPreUse((String)loanType, (String)contractDO.getString("creditortype"))) continue;
            CreditLimitHelper.createCreditUse((DynamicObject)contractDO, (boolean)true);
            DynamicObject applyBillF7 = contractDO.getDynamicObject("loanapply");
            DynamicObject applyBill = applyBillF7 != null ? TmcDataServiceHelper.loadSingle((Object)applyBillF7.getPkValue(), (String)"cfm_loan_apply", (String)"id,creditlimit") : null;
            CreditLimitHelper.creditBizSave((DynamicObject)contractDO, (DynamicObject)applyBill, (String)"banksyndicate_entry", (String)"e_creditlimit");
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        CfmContractBillHelper.setLoanApplyBillConfirmStatus((DynamicObject[])dataEntities, (boolean)false);
        CfmAttachmentHelper.dealAttachment((DynamicObject[])dataEntities);
    }
}

