/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.loancontractbill;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.tmc.cfm.business.helper.LoanContractHelper;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.DrawWayEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.CfmAttachmentHelper;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.CfmContractBillHelper;
import kd.tmc.cfm.common.helper.CreditLimitHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanContractBillSubmitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("loantype");
        sic.add("notdrawamount");
        sic.add("returnreason");
        sic.add("currency");
        sic.add("amount");
        sic.add("registorg");
        sic.add("datasource");
        sic.add("lendernature");
        sic.add("org");
        sic.add("sourcebillid");
        sic.add("lenderapplyno");
        sic.add("datasource");
        sic.add("rateadjustcycletype");
        sic.add("creditorg");
        sic.add("creditor");
        sic.add("creditortype");
        sic.add("textcreditor");
        sic.add("debtortype");
        sic.add("debtor");
        sic.add("textdebtor");
        sic.add("finproduct");
        sic.add("productfactory");
        sic.add("creditlimit");
        sic.add("loanapply");
        sic.add("e_creditlimit");
        sic.add("e_bankrole");
        sic.add("e_bank");
        sic.add("startdate");
        sic.add("enddate");
        sic.add("term");
        sic.add("iscycleloan");
        sic.add("drawway");
        sic.add("issyncdraw");
        sic.add("synccreditlimit");
        sic.add("isnofixedterm");
        sic.add("billstatus");
        sic.add("isinit");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        CfmBillCommonHelper.setNeedSaveFieldValue((DynamicObject[])dataEntities);
        CfmContractBillHelper.dealFieldValueOnSave((DynamicObject[])dataEntities);
        CfmContractBillHelper.resetApplyBillConfirmStatus((DynamicObject[])dataEntities);
        CfmContractBillHelper.setDrawPlanOrder((DynamicObject[])dataEntities);
        for (DynamicObject contractDO : dataEntities) {
            DynamicObject productFactory;
            boolean isBanksLoanLimit;
            CfmBillCommonHelper.setLenderNature((DynamicObject)contractDO);
            LoanContractHelper.setCreditorInfo(contractDO);
            String billStatus = contractDO.getString("billstatus");
            if (BillStatusEnum.isAudit((String)billStatus)) continue;
            BusinessHelper.clearReturnreason((DynamicObject)contractDO);
            contractDO.set("notdrawamount", (Object)contractDO.getBigDecimal("amount"));
            if (!CfmContractBillHelper.mayUseCreditLimit((DynamicObject)contractDO)) {
                contractDO.set("creditlimit", null);
            }
            if (DrawWayEnum.ONCE.getValue().equals(contractDO.getString("drawway"))) {
                contractDO.set("iscycleloan", (Object)false);
            }
            DynamicObject applybillF7 = contractDO.getDynamicObject("loanapply");
            DynamicObject applyBill = null;
            if (applybillF7 != null) {
                String applyEntity = BizTypeEnum.isFinLease((String)contractDO.getString("loantype")) ? "fl_financelease_apply" : "cfm_loan_apply";
                applyBill = TmcDataServiceHelper.loadSingle((Object)applybillF7.getPkValue(), (String)applyEntity, (String)"id,creditlimit");
            }
            Date startDate = contractDO.getDate("startdate");
            Date endDate = contractDO.getDate("enddate");
            if (EmptyUtil.isNoEmpty((Object)startDate) && EmptyUtil.isNoEmpty((Object)endDate)) {
                String term = DateUtils.getDiff_ymd((Date)startDate, (Date)endDate);
                contractDO.set("term", (Object)term);
            }
            CreditLimitHelper.createCreditUse((DynamicObject)contractDO, (boolean)false);
            if (LoanTypeEnum.BANKSLOAN.getValue().equals(contractDO.getString("loantype"))) {
                contractDO.set("creditlimit", null);
                contractDO.set("synccreditlimit", null);
            }
            if (isBanksLoanLimit = CreditLimitHelper.isBanksLoanLimit((DynamicObject)(productFactory = contractDO.getDynamicObject("productfactory")), (String)contractDO.getString("loantype"))) continue;
            CreditLimitHelper.creditBizSubmit((DynamicObject)contractDO, (DynamicObject)applyBill, (String)"banksyndicate_entry", (String)"e_creditlimit");
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        CfmContractBillHelper.setLoanApplyBillConfirmStatus((DynamicObject[])dataEntities, (boolean)false);
        CfmAttachmentHelper.dealAttachment((DynamicObject[])dataEntities);
    }
}

