/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.preinterestbill;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.tmc.cfm.common.bean.InterestCalcRequest;
import kd.tmc.cfm.common.helper.InterestCalcHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillExtInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PreInstCalService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List ias = super.getSelector();
        ias.add("sourcebillid");
        ias.add("predictpreinstamt");
        ias.add("actpreinstamt");
        ias.add("prestenddate");
        ias.add("entrys");
        ias.add("inststartdate");
        ias.add("instenddate");
        ias.add("instdays");
        ias.add("instprincipalamt");
        ias.add("rate");
        ias.add("ratetrandays");
        ias.add("instamt");
        ias.add("instctg");
        ias.add("calcoverint");
        return ias;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject preInterestEntity : dataEntities) {
            Date prestartdate = preInterestEntity.getDate("prestartdate");
            Date endinstdate = preInterestEntity.getDate("prestenddate");
            Long sourcebillid = preInterestEntity.getLong("sourcebillid");
            DynamicObject loanBill = TmcDataServiceHelper.loadSingle((Object)sourcebillid, (String)"cfm_loanbill");
            InterestCalcRequest request = InterestCalcRequest.build((DynamicObject)loanBill, (Date)prestartdate, (Date)(endinstdate = InterestCalcHelper.getEndIntDate((DynamicObject)loanBill, (Date)endinstdate)), (boolean)true).setCalcOverInt(preInterestEntity.getBoolean("calcoverint"));
            IntBillExtInfo intBill = InterestCalcHelper.callInt((InterestCalcRequest)request);
            if (!EmptyUtil.isNoEmpty((Object)intBill)) continue;
            preInterestEntity.set("predictpreinstamt", (Object)intBill.getAmount());
            if (EmptyUtil.isEmpty((BigDecimal)preInterestEntity.getBigDecimal("actpreinstamt"))) {
                preInterestEntity.set("actpreinstamt", (Object)intBill.getAmount());
            }
            DynamicObjectCollection interest_entry = preInterestEntity.getDynamicObjectCollection("entrys");
            InterestCalcHelper.addDetail((DynamicObjectCollection)interest_entry, (List)intBill.getExtDetails());
        }
    }
}

