/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.preinterestbill;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.tmc.cfm.common.enums.AutoConfirmParamEnum;
import kd.tmc.cfm.common.enums.CfmEntityEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.PreIntOperateTypeEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.CfmSysParamHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PreInterestBillAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("datasource");
        selector.add("org");
        selector.add("creditorg");
        selector.add("creator");
        selector.add("calcoverint");
        selector.add("confirmstatus");
        selector.add("confirmer");
        selector.add("confirmtime");
        selector.add("loantype");
        selector.add("loanbillno");
        selector.add("batchnoid");
        selector.add("creditortype");
        selector.add("datasource");
        selector.add("bizdate");
        selector.add("operatetype");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        Map operationVariable = this.getOperationVariable();
        OperateOption option = OperateOption.create();
        operationVariable.forEach((key, value) -> option.setVariableValue(key, value));
        for (DynamicObject preInterestBill : dataEntities) {
            if (LoanTypeEnum.isEntrustLoan((String)preInterestBill.getString("loantype")) || LoanTypeEnum.isLinklend((String)preInterestBill.getString("loantype"))) {
                if (this.isAutoConfirm(preInterestBill) || PreIntOperateTypeEnum.isReverseInt((String)preInterestBill.getString("operatetype"))) {
                    preInterestBill.set("confirmstatus", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
                    preInterestBill.set("confirmer", (Object)RequestContext.get().getCurrUserId());
                    preInterestBill.set("confirmtime", (Object)DateUtils.getCurrentTime());
                    LoanBillHelper.autoRedWriteOffOneSelf((DynamicObject)preInterestBill);
                    continue;
                }
                preInterestBill.set("confirmstatus", (Object)ConfirmStatusEnum.WAITCONFIRM.getValue());
                continue;
            }
            if (!LoanTypeEnum.isBankLoan((String)preInterestBill.getString("loantype")) && !LoanTypeEnum.isBanksLoan((String)preInterestBill.getString("loantype")) && !LoanTypeEnum.isBond((String)preInterestBill.getString("loantype"))) continue;
            preInterestBill.set("confirmstatus", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
            preInterestBill.set("confirmer", (Object)RequestContext.get().getCurrUserId());
            preInterestBill.set("confirmtime", (Object)DateUtils.getCurrentTime());
            LoanBillHelper.autoRedWriteOffOneSelf((DynamicObject)preInterestBill);
        }
    }

    private boolean isAutoConfirm(DynamicObject preInterestBill) {
        String dataSource = preInterestBill.getString("datasource");
        String creditorType = preInterestBill.getString("creditortype");
        String orgFieldName = CfmBillCommonHelper.getFundOrgFieldName((String)dataSource, (boolean)false, (String)creditorType);
        String entityName = preInterestBill.getDataEntityType().getName();
        DynamicObject org = preInterestBill.getDynamicObject(orgFieldName);
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            return true;
        }
        HashSet autoOps = new HashSet(5);
        if (DataSourceEnum.INVEST.getValue().equals(dataSource)) {
            autoOps.addAll(CfmSysParamHelper.getParameterComboxs((long)org.getLong("id"), (String)"cfm001"));
        } else {
            autoOps.addAll(CfmSysParamHelper.getParameterComboxs((long)org.getLong("id"), (String)"cim001"));
        }
        return (CfmEntityEnum.PREINTERESTBILL.getValue().equals(entityName) || CfmEntityEnum.CIM_PREINTERESTBILL.getValue().equals(entityName)) && autoOps.contains(AutoConfirmParamEnum.PREINTEREST.getValue());
    }
}

