/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.preinterestbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.constant.CfmBizConstant;
import kd.tmc.cfm.common.enums.PreIntOperateTypeEnum;
import kd.tmc.cfm.common.enums.WriteOffStatusEnum;
import kd.tmc.cfm.common.helper.BatchIntBillHelper;
import kd.tmc.cfm.common.helper.IntBillWriteOffHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PreInterestBillRedWriteOffService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List ias = super.getSelector();
        ias.add("writeoffpreintbillid");
        ias.add("sourcebillid");
        ias.add("nowriteoffamt");
        return ias;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        HashSet<Long> loanBillIds = new HashSet<Long>(0);
        Object[] pks = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).toArray();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)dataEntities[0].getDynamicObjectType().getName());
        DynamicObject[] preInts = TmcDataServiceHelper.load((Object[])pks, (DynamicObjectType)entityType);
        ArrayList<DynamicObject> redWriteOffPreInt = new ArrayList<DynamicObject>(dataEntities.length);
        Long userId = RequestContext.get().getCurrUserId();
        String batchNoParam = (String)this.getOperationVariable().get(CfmBizConstant.PARAM_REDWRITEOFFBATCH);
        long batchNoId = EmptyUtil.isEmpty((String)batchNoParam) ? 0L : Long.parseLong(batchNoParam);
        for (DynamicObject preInt : preInts) {
            DynamicObject newPreInt = TmcDataServiceHelper.clone((DynamicObject)preInt);
            newPreInt.set("billhead_lk", null);
            newPreInt.set("billno", (Object)"");
            newPreInt.set("actpreinstamt", (Object)Constants._ONE.multiply(preInt.getBigDecimal("actpreinstamt")));
            newPreInt.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            newPreInt.set("writeoffpreintbillid", preInt.getPkValue());
            newPreInt.set("operatetype", (Object)PreIntOperateTypeEnum.REVERSEINT.getValue());
            newPreInt.set("writeoffamt", preInt.get("nowriteoffamt"));
            newPreInt.set("nowriteoffamt", (Object)BigDecimal.ZERO);
            newPreInt.set("createtime", (Object)new Date());
            newPreInt.set("creator", (Object)TmcDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user"));
            newPreInt.set("writeoffstatus", (Object)WriteOffStatusEnum.RED_WRITEOFF.getValue());
            newPreInt.set("batchnoid", (Object)batchNoId);
            newPreInt.set("eassrcid", (Object)"");
            newPreInt.set("isvoucher", (Object)Boolean.FALSE);
            redWriteOffPreInt.add(newPreInt);
            preInt.set("writeoffstatus", (Object)WriteOffStatusEnum.RED_WRITEOFF.getValue());
            preInt.set("writeoffamt", preInt.get("nowriteoffamt"));
            preInt.set("nowriteoffamt", (Object)BigDecimal.ZERO);
            preInt.set("modifier", (Object)userId);
            preInt.set("modifytime", (Object)new Date());
            preInt.set("batchnoid", (Object)batchNoId);
            loanBillIds.add(preInt.getLong("sourcebillid"));
        }
        OperateOption opOption = OperateOption.create();
        opOption.setVariableValue("redwriteoffop", "redwriteoffop");
        OperationResult submitRes = TmcOperateServiceHelper.execOperate((String)"submit", (String)dataEntities[0].getDataEntityType().getName(), (DynamicObject[])redWriteOffPreInt.toArray(new DynamicObject[0]), (OperateOption)opOption);
        List redWriteOffPreIntPkIds = submitRes.getSuccessPkIds();
        TmcOperateServiceHelper.execOperate((String)"audit", (String)dataEntities[0].getDataEntityType().getName(), (Object[])redWriteOffPreIntPkIds.toArray(), (OperateOption)opOption);
        SaveServiceHelper.save((DynamicObject[])preInts);
        String entityTypeName = entityType.getName();
        if (BatchIntBillHelper.isDepostPreInt((String)entityTypeName)) {
            IntBillWriteOffHelper.writeBackDepositLastPreIntDate(loanBillIds, (String)entityTypeName);
        } else {
            IntBillWriteOffHelper.writeBackLastPreIntDate(loanBillIds);
        }
    }
}

