/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.rateadjust;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.enums.AdjustEleEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.helper.CfmRateAdjustWriteBackHelper;
import kd.tmc.cfm.common.helper.LoanWriteBackHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RateAdjustBillUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(10);
        sic.add("adjustele");
        sic.add("afterrefrate");
        sic.add("afterrateadjustkey");
        sic.add("afterrateadjustval");
        sic.add("afterratesign");
        sic.add("afterinterestrate");
        sic.add("afterratefloatpoint");
        sic.add("adjusteffectdate");
        sic.add("loancontractbill");
        sic.add("ratefloatpoint");
        sic.add("ratesign");
        sic.add("refrate");
        sic.add("interestrate");
        sic.add("rateadjustkey");
        sic.add("rateadjustval");
        sic.add("isadjusttofloat");
        sic.add("rateadjuststyle");
        sic.add("rateadjustdate");
        sic.add("beforeinteresttype");
        sic.add("settleintmode");
        sic.add("interestsettledplan");
        sic.add("rateresetdays");
        sic.add("issofrrate");
        sic.add("entry");
        sic.add("entry.afterlloanrate");
        sic.add("entry.afterlratesign");
        sic.add("entry.lratefloatpoint");
        sic.add("entry.afterlratefloatpoint");
        sic.add("entry.ldrawbill");
        sic.add("entry.lisadjust");
        sic.add("entry.lratesign");
        sic.add("entry.lloanrate");
        sic.add("entry.lsettleintmode");
        sic.add("entry.linterestsettledplan");
        sic.add("entry.lrateadjustdate");
        sic.add("entry.lissofrrate");
        sic.add("entry.lrefrate");
        sic.add("entry.afterlrefrate");
        sic.add("entry.lrateadjustkey");
        sic.add("entry.lrateadjustval");
        sic.add("entry.afterlrateadjustkey");
        sic.add("entry.afterlrateadjustval");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        HashMap<Long, DynamicObject> loanIdEntryMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, DynamicObject> loanIdHeadMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, Long> loanIdContractIdMap = new HashMap<Long, Long>(16);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                if (entry.getBoolean("lisadjust")) {
                    loanIdHeadMap.put(entry.getDynamicObject("ldrawbill").getLong("id"), dataEntity);
                    loanIdEntryMap.put(entry.getDynamicObject("ldrawbill").getLong("id"), entry);
                }
                if (!AdjustEleEnum.ADJUSTCONTRACT.getValue().equals(dataEntity.getString("adjustele"))) continue;
                loanIdContractIdMap.put(entry.getDynamicObject("ldrawbill").getLong("id"), dataEntity.getDynamicObject("loancontractbill").getLong("id"));
            }
        }
        DynamicObject[] drawBills = TmcDataServiceHelper.load((Object[])loanIdEntryMap.keySet().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cfm_loanbill"));
        if (EmptyUtil.isNoEmpty(loanIdContractIdMap)) {
            DynamicObject[] contractBills = TmcDataServiceHelper.load((Object[])loanIdContractIdMap.values().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cfm_loancontractbill"));
            HashMap<Long, DynamicObject> loanIdContractMap = new HashMap<Long, DynamicObject>(16);
            for (Map.Entry entry : loanIdContractIdMap.entrySet()) {
                Long loanId = (Long)entry.getKey();
                Long contractId = (Long)entry.getValue();
                for (DynamicObject contractBill : contractBills) {
                    if (!contractBill.getPkValue().equals(contractId)) continue;
                    loanIdContractMap.put(loanId, contractBill);
                }
            }
            this.reWriteBackContractLoanBillOp(loanIdHeadMap, loanIdEntryMap, loanIdContractMap, drawBills);
            SaveServiceHelper.save((DynamicObject[])loanIdContractMap.values().toArray(new DynamicObject[0]));
        } else {
            this.reWriteBackContractLoanBillOp(loanIdHeadMap, loanIdEntryMap, new HashMap<Long, DynamicObject>(), drawBills);
        }
        SaveServiceHelper.save((DynamicObject[])drawBills);
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        List loanIds = Arrays.stream(dataEntities).map(o -> o.getDynamicObjectCollection("entry")).flatMap(Collection::stream).filter(o -> o.getBoolean("lisadjust")).map(o -> o.getDynamicObject("ldrawbill").getLong("id")).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(loanIds)) {
            LoanWriteBackHelper.writeBack(loanIds, (LoanWBTypeEnum)LoanWBTypeEnum.REPAYPLAN);
        }
    }

    private void reWriteBackContractLoanBillOp(Map<Long, DynamicObject> loanIdHeadMap, Map<Long, DynamicObject> loanIdEntryMap, Map<Long, DynamicObject> loanIdContractMap, DynamicObject[] drawBills) {
        for (DynamicObject drawBill : drawBills) {
            Long loanId = drawBill.getLong("id");
            DynamicObject adjustHeadInfo = loanIdHeadMap.get(loanId);
            DynamicObject adjustEntryInfo = loanIdEntryMap.get(loanId);
            DynamicObject loanContractBill = adjustHeadInfo.getDynamicObject("loancontractbill");
            boolean isAdjustToFloat = adjustHeadInfo.getBoolean("isadjusttofloat");
            String interestType = loanContractBill.getString("interesttype");
            if (LoanTypeEnum.isBond((String)drawBill.getString("loantype"))) {
                interestType = CfmRateAdjustWriteBackHelper.reCalInterestType((DynamicObject)loanContractBill, (String)interestType);
            }
            DynamicObject contractBill = loanIdContractMap.get(loanId);
            if (AdjustEleEnum.ADJUSTCONTRACT.getValue().equals(adjustHeadInfo.getString("adjustele"))) {
                if (InterestTypeEnum.FIXED.getValue().equals(interestType) || InterestTypeEnum.AGREE.getValue().equals(interestType)) {
                    BigDecimal interestRate = adjustHeadInfo.getBigDecimal("interestrate");
                    BigDecimal afterInterestrRate = adjustHeadInfo.getBigDecimal("afterinterestrate");
                    if (afterInterestrRate.compareTo(interestRate) != 0 && EmptyUtil.isNoEmpty((DynamicObject)contractBill)) {
                        contractBill.set("interestrate", (Object)interestRate);
                    }
                    this.writeBackLoanByFixed(adjustEntryInfo, drawBill);
                } else {
                    RateAdjustBillUnAuditService.writeBackContractByFloat(adjustHeadInfo, contractBill, isAdjustToFloat);
                    RateAdjustBillUnAuditService.writeBackLoanByFloat(adjustEntryInfo, drawBill, isAdjustToFloat);
                    if (isAdjustToFloat) {
                        String beforeInterestType = adjustHeadInfo.getString("beforeinteresttype");
                        beforeInterestType = EmptyUtil.isEmpty((String)beforeInterestType) ? InterestTypeEnum.FIXED.getValue() : beforeInterestType;
                        contractBill.set("interesttype", (Object)beforeInterestType);
                        drawBill.set("interesttype", (Object)beforeInterestType);
                        contractBill.set("rateadjuststyle", null);
                        drawBill.set("rateadjuststyle", null);
                        contractBill.set("rateadjustdate", null);
                        drawBill.set("rateadjustdate", null);
                        drawBill.set("israteadjustbyhand", (Object)Boolean.FALSE);
                    }
                }
            } else if (InterestTypeEnum.FIXED.getValue().equals(interestType) || InterestTypeEnum.AGREE.getValue().equals(interestType)) {
                this.writeBackLoanByFixed(adjustEntryInfo, drawBill);
            } else {
                RateAdjustBillUnAuditService.writeBackLoanByFloat(adjustEntryInfo, drawBill, false);
            }
            this.delLoanRateAdjustEntry(adjustHeadInfo, drawBill);
        }
    }

    private static void writeBackContractByFloat(DynamicObject adjustHeadInfo, DynamicObject contractBill, boolean isAdjustToFloat) {
        if (EmptyUtil.isEmpty((DynamicObject)contractBill)) {
            return;
        }
        String rateSign = adjustHeadInfo.getString("ratesign");
        String afterRateSign = adjustHeadInfo.getString("afterratesign");
        if (!afterRateSign.equals(rateSign) || isAdjustToFloat) {
            contractBill.set("ratesign", (Object)(isAdjustToFloat ? null : rateSign));
        }
        BigDecimal rateFloatPoint = adjustHeadInfo.getBigDecimal("ratefloatpoint");
        BigDecimal afterRateFloatPoint = adjustHeadInfo.getBigDecimal("afterratefloatpoint");
        if (afterRateFloatPoint.compareTo(rateFloatPoint) != 0 || isAdjustToFloat) {
            contractBill.set("ratefloatpoint", (Object)(isAdjustToFloat ? null : rateFloatPoint));
        }
        String rateAdjustKey = adjustHeadInfo.getString("rateadjustkey");
        String afterRateAdjustKey = adjustHeadInfo.getString("afterrateadjustkey");
        if (!afterRateAdjustKey.equals(rateAdjustKey) || isAdjustToFloat) {
            contractBill.set("rateadjustcycletype", (Object)(isAdjustToFloat ? null : rateAdjustKey));
        }
        BigDecimal rateAdjustVal = adjustHeadInfo.getBigDecimal("rateadjustval");
        BigDecimal afterRateAdjustVal = adjustHeadInfo.getBigDecimal("afterrateadjustval");
        if (afterRateAdjustVal.compareTo(rateAdjustVal) != 0 || isAdjustToFloat) {
            contractBill.set("rateadjustcycle", (Object)(isAdjustToFloat ? Integer.valueOf(0) : rateAdjustVal));
        }
        DynamicObject refRate = adjustHeadInfo.getDynamicObject("refrate");
        DynamicObject afterRefRate = adjustHeadInfo.getDynamicObject("afterrefrate");
        if (!afterRefRate.equals(refRate) || isAdjustToFloat) {
            contractBill.set("referencerate", isAdjustToFloat ? null : refRate.getPkValue());
        }
    }

    private static void writeBackLoanByFloat(DynamicObject adjustEntryInfo, DynamicObject drawBill, boolean isAdjustToFloat) {
        String lRateSign = adjustEntryInfo.getString("lratesign");
        String afterLRateSign = adjustEntryInfo.getString("afterlratesign");
        if (!afterLRateSign.equals(lRateSign) || isAdjustToFloat) {
            drawBill.set("ratesign", (Object)(isAdjustToFloat ? null : lRateSign));
        }
        BigDecimal lrateFloatPoint = adjustEntryInfo.getBigDecimal("lratefloatpoint");
        BigDecimal afterLRateFloatPoint = adjustEntryInfo.getBigDecimal("afterlratefloatpoint");
        if (afterLRateFloatPoint.compareTo(lrateFloatPoint) != 0 || isAdjustToFloat) {
            drawBill.set("ratefloatpoint", (Object)(isAdjustToFloat ? null : lrateFloatPoint));
        }
        String lRateAdjustKey = adjustEntryInfo.getString("lrateadjustkey");
        String afterLRateAdjustKey = adjustEntryInfo.getString("afterlrateadjustkey");
        if (!afterLRateAdjustKey.equals(lRateAdjustKey) || isAdjustToFloat) {
            drawBill.set("rateadjustcycletype", (Object)(isAdjustToFloat ? null : lRateAdjustKey));
        }
        BigDecimal lRateAdjustVal = adjustEntryInfo.getBigDecimal("lrateadjustval");
        BigDecimal afterLRateAdjustVal = adjustEntryInfo.getBigDecimal("afterlrateadjustval");
        if (afterLRateAdjustVal.compareTo(lRateAdjustVal) != 0 || isAdjustToFloat) {
            drawBill.set("rateadjustcycle", (Object)(isAdjustToFloat ? Integer.valueOf(0) : lRateAdjustVal));
        }
        DynamicObject lRefRate = adjustEntryInfo.getDynamicObject("lrefrate");
        DynamicObject afterLRefRate = adjustEntryInfo.getDynamicObject("afterlrefrate");
        if (!afterLRefRate.equals(lRefRate) || isAdjustToFloat) {
            drawBill.set("referencerate", isAdjustToFloat ? null : lRefRate.getPkValue());
        }
    }

    private void delLoanRateAdjustEntry(DynamicObject adjustInfo, DynamicObject drawBill) {
        DynamicObjectCollection rateHistorys = drawBill.getDynamicObjectCollection("ratehistory_entry");
        String billno = adjustInfo.getString("billno");
        List delEntryObj = rateHistorys.stream().filter(o -> billno.equals(o.getString("rh_rateadjno"))).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(delEntryObj)) {
            rateHistorys.removeAll(delEntryObj);
        }
    }

    private void writeBackLoanByFixed(DynamicObject adjustEntryInfo, DynamicObject drawBill) {
        BigDecimal lLoanRate = adjustEntryInfo.getBigDecimal("lloanrate");
        BigDecimal afterLLoanRate = adjustEntryInfo.getBigDecimal("afterlloanrate");
        if (afterLLoanRate.compareTo(lLoanRate) != 0) {
            drawBill.set("loanrate", (Object)lLoanRate);
        }
        if (BigDecimal.ZERO.compareTo(drawBill.getBigDecimal("startloanrate")) == 0 && BigDecimal.ZERO.compareTo(lLoanRate) == 0) {
            if (RepaymentWayEnum.isZdyhk((String)drawBill.getString("repaymentway"))) {
                drawBill.set("settleintmode", (Object)SettleIntModeEnum.gdpljx.getValue());
            }
            drawBill.set("interestsettledplan", null);
        }
    }
}

