/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.repaymentbill;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepaymentBillBuyBackUnAuditService
extends AbstractTmcBizOppService {
    private static final String LOAN_BILL_PROPS = String.join((CharSequence)",", "id", "investor_entry", String.join((CharSequence)".", "investor_entry", "e_buybackedamt"), String.join((CharSequence)".", "investor_entry", "e_investorname"), String.join((CharSequence)".", "investor_entry", "e_investorid"), String.join((CharSequence)".", "investor_entry", "e_investamount"), String.join((CharSequence)".", "investor_entry", "e_avalinvestamt"));

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("buyback_entry");
        sic.add("loans");
        sic.add(String.join((CharSequence)".", "buyback_entry", "e_investorid"));
        sic.add(String.join((CharSequence)".", "buyback_entry", "e_avalinvestamt"));
        sic.add(String.join((CharSequence)".", "buyback_entry", "e_buybackamt"));
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        List repayBills = Arrays.stream(dataEntities).sorted(Comparator.comparing(d -> d.getDate("bizdate"))).collect(Collectors.toList());
        for (DynamicObject repayBill : repayBills) {
            if (!repayBill.containsProperty("isbuyback") || !repayBill.getBoolean("isbuyback")) continue;
            RepaymentBillBuyBackUnAuditService.revertBondLoanBillInvestInfo(repayBill);
        }
    }

    private static void revertBondLoanBillInvestInfo(DynamicObject repayBill) {
        DynamicObject[] loanBillDbs;
        Map<Long, DynamicObjectCollection> loanIdAndBbCols = RepaymentBillBuyBackUnAuditService.getLoanIdAndBuyBackCols(repayBill);
        if (EmptyUtil.isEmpty(loanIdAndBbCols)) {
            return;
        }
        for (DynamicObject loanBillDb : loanBillDbs = TmcDataServiceHelper.load((String)"cfm_loanbill_bond", (String)LOAN_BILL_PROPS, (QFilter[])new QFilter[]{new QFilter("id", "in", loanIdAndBbCols.keySet())})) {
            DynamicObjectCollection buyBackCols = loanIdAndBbCols.get(loanBillDb.getLong("id"));
            Map<Long, DynamicObject> buyBackMap = buyBackCols.stream().collect(Collectors.toMap(k -> k.getLong("e_investentryid"), v -> v));
            DynamicObjectCollection investCols = loanBillDb.getDynamicObjectCollection("investor_entry");
            for (DynamicObject investCol : investCols) {
                DynamicObject buyBackCol = buyBackMap.get(investCol.getLong("id"));
                investCol.set("e_buybackedamt", (Object)investCol.getBigDecimal("e_buybackedamt").subtract(buyBackCol.getBigDecimal("e_buybackamt")));
                investCol.set("e_avalinvestamt", (Object)investCol.getBigDecimal("e_investamount").subtract(investCol.getBigDecimal("e_buybackedamt")));
                buyBackCol.set("e_avalinvestamt", (Object)investCol.getBigDecimal("e_avalinvestamt"));
            }
        }
        SaveServiceHelper.save((DynamicObject[])loanBillDbs);
    }

    private static Map<Long, DynamicObjectCollection> getLoanIdAndBuyBackCols(DynamicObject repayBill) {
        DynamicObjectCollection loans = repayBill.getDynamicObjectCollection("loans");
        HashMap<Long, DynamicObjectCollection> loanIdAndBbCols = new HashMap<Long, DynamicObjectCollection>(16);
        for (DynamicObject loan : loans) {
            DynamicObject loanBill = loan.getDynamicObject("e_loanbill");
            if (!EmptyUtil.isNoEmpty((DynamicObject)loanBill)) continue;
            loanIdAndBbCols.put(loanBill.getLong("id"), loan.getDynamicObjectCollection("buyback_entry"));
        }
        return loanIdAndBbCols;
    }
}

