/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.repaymentbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.business.service.repay.RepayServiceHelper;
import kd.tmc.cfm.common.enums.ApplyBusinessStatusEnum;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.CfmAttachmentHelper;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.InterestServiceHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.helper.LoanWriteBackHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepaymentBillConfirmService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(RepaymentBillConfirmService.class);
    private List<DynamicObject> payInterests = new ArrayList<DynamicObject>(10);

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("loans");
        sic.add("e_ispayinst");
        sic.add("repayapplyf7");
        sic.add("e_loanbill");
        sic.add("e_repayamount");
        sic.add("e_convertrepayamt");
        sic.add("amount");
        sic.add("confirmstatus");
        sic.add("confirmer");
        sic.add("confirmtime");
        sic.add("accountbank");
        sic.add("loaneracctbank");
        sic.add("datasource");
        sic.add("lendernature");
        sic.add("bizdate");
        sic.add("loantype");
        sic.add("slentryentity");
        sic.add("s_repayinst");
        sic.add("s_repayamount");
        sic.add("s_bank");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject repay : dataEntities) {
            BusinessHelper.fillConfirmInfo((DynamicObject)repay);
            CfmBillCommonHelper.updateApplyBizStatus((DynamicObject)repay, (String)"repayapplyf7", (String)"cfm_repayapplybill", (String)ApplyBusinessStatusEnum.HANDED.getValue());
            for (DynamicObject repayEntry : repay.getDynamicObjectCollection("loans")) {
                boolean ispayinst = repayEntry.getBoolean("e_ispayinst");
                DynamicObject loanBill = repayEntry.getDynamicObject("e_loanbill");
                if (!ispayinst) continue;
                QFilter instFilter = new QFilter("repaymentid", "=", repay.getPkValue()).and(new QFilter("sourcebillid", "=", loanBill.getPkValue()));
                DynamicObject interestBill = TmcDataServiceHelper.loadSingle((String)"cfm_interestbill", (String)String.join((CharSequence)",", InterestServiceHelper.getAuditSelector()), (QFilter[])instFilter.toArray());
                InterestServiceHelper.confirmProcess((DynamicObject)interestBill);
                InterestServiceHelper.updatePayIntAcct((DynamicObject)interestBill, (DynamicObject)repay);
                this.payInterests.add(interestBill);
            }
            if (EmptyUtil.isEmpty(this.payInterests)) continue;
            SaveServiceHelper.save((DynamicObject[])this.payInterests.toArray(new DynamicObject[0]));
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        HashSet loanBillIds = new HashSet(8);
        for (DynamicObject repayBill : dataEntities) {
            loanBillIds.addAll(repayBill.getDynamicObjectCollection("loans").stream().map(d -> d.getDynamicObject("e_loanbill").getLong("id")).collect(Collectors.toSet()));
        }
        logger.info("========\u8fd8\u6b3e\u5904\u7406\u6267\u884c\u786e\u8ba4\u64cd\u4f5c\u65f6\u53cd\u5199\u63d0\u6b3e\u5904\u7406,\u53ca\u8ba1\u7b97\u5229\u606f\u64cd\u4f5c,\u63d0\u6b3e\u5355id: {}", loanBillIds);
        LoanWriteBackHelper.writeBack(new ArrayList(loanBillIds), (LoanWBTypeEnum)LoanWBTypeEnum.REPAYMENT);
        RepayServiceHelper.returnCreditLimit(Arrays.asList(dataEntities));
        List intLoanBillIds = this.payInterests.stream().map(d -> d.getLong("sourcebillid")).collect(Collectors.toList());
        LoanWriteBackHelper.writeBack(intLoanBillIds, (LoanWBTypeEnum)LoanWBTypeEnum.INTEREST);
        String settleInfoStr = (String)this.getOperationVariable().get("settleinfo");
        for (DynamicObject interestEntity : this.payInterests) {
            LoanBillHelper.autoWriteOff((DynamicObject)interestEntity, (String)settleInfoStr);
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        CfmAttachmentHelper.dealAttachment((DynamicObject[])dataEntities);
    }
}

