/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.repaymentbill;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepaymentBillSuretyRepayCancelService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("bizdate");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        List repayBills = Arrays.stream(dataEntities).sorted((d1, d2) -> d2.getDate("bizdate").compareTo(d1.getDate("bizdate"))).collect(Collectors.toList());
        for (DynamicObject repay : repayBills) {
            this.dealSuretyRepay(repay);
        }
    }

    private void dealSuretyRepay(DynamicObject repay) {
        QFilter qFilter = new QFilter("repaybillid", "=", repay.getPkValue()).and("repaybilltype", "=", (Object)repay.getDataEntityType().getName());
        DynamicObjectCollection suretyReleases = QueryServiceHelper.query((String)"fbd_suretyreleasebill", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)suretyReleases)) {
            return;
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("debitType", repay.getDataEntityType().getName());
        List suretyIds = suretyReleases.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
        TmcOperateServiceHelper.execOperate((String)"cancelsuretyrepay", (String)"fbd_suretyreleasebill", (Object[])suretyIds.toArray(), (OperateOption)operateOption);
    }
}

