/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.repaymentbill;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.DynamicObjectCompareHelper;
import kd.tmc.fbp.common.helper.SuretyHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepaymentBillSuretyRepayService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("bizdate");
        sic.add("entry_surety");
        sic.add("billno");
        sic.add("issuretyrepay");
        sic.add("loancontractbill");
        sic.add(String.join((CharSequence)".", "entry_surety", "suretyrepayamt"));
        sic.add(String.join((CharSequence)".", "entry_surety", "suretybill"));
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        List repayBills = Arrays.stream(dataEntities).sorted(Comparator.comparing(d -> d.getDate("bizdate"))).collect(Collectors.toList());
        for (DynamicObject repay : repayBills) {
            this.dealSuretyRepay(repay);
        }
    }

    private void dealSuretyRepay(DynamicObject repay) {
        if (!repay.getBoolean("issuretyrepay")) {
            return;
        }
        DynamicObjectCollection suretyEntries = repay.getDynamicObjectCollection("entry_surety");
        for (DynamicObject suretyEntry : suretyEntries) {
            OperateOption operateOption = OperateOption.create();
            HashMap<String, Object> returnDataMap = new HashMap<String, Object>(16);
            returnDataMap.put("srcEntity", repay.getDataEntityType().getName());
            returnDataMap.put("bizno", repay.get("billno"));
            Map repayEntry = DynamicObjectCompareHelper.dynamicObj2Map((DynamicObject)suretyEntry);
            HashMap<String, Map> repayMap = new HashMap<String, Map>(2);
            DynamicObject suretyBill = suretyEntry.getDynamicObject("suretybill");
            if (EmptyUtil.isEmpty((DynamicObject)suretyBill) && EmptyUtil.isNoEmpty((DynamicObject)repay.getDynamicObject("loancontractbill"))) {
                suretyBill = SuretyHelper.loadSuretyBillByDebit((Long)repay.getDynamicObject("loancontractbill").getLong("id"));
            }
            if (EmptyUtil.isEmpty((DynamicObject)suretyBill)) continue;
            long suretyId = suretyBill.getLong("id");
            repayMap.put(String.valueOf(suretyId), repayEntry);
            repayEntry.put("repaydate", repay.getDate("bizdate"));
            repayEntry.put("repayamount", suretyEntry.getBigDecimal("suretyrepayamt"));
            returnDataMap.put("valueMap", repayMap);
            String returnData = SerializationUtils.toJsonString(returnDataMap);
            operateOption.setVariableValue("returnDataMap", returnData);
            operateOption.setVariableValue("debitId", String.valueOf(repay.getPkValue()));
            operateOption.setVariableValue("debitType", repay.getDataEntityType().getName());
            TmcOperateServiceHelper.execOperate((String)"suretyrepay", (String)"fbd_suretybill", (Object[])new Object[]{suretyId}, (OperateOption)operateOption);
        }
    }
}

