/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.repaymentbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.business.service.repay.RepayServiceHelper;
import kd.tmc.cfm.common.enums.ApplyBusinessStatusEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.enums.SettleCenterStatusEnum;
import kd.tmc.cfm.common.helper.BondLimitHelper;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.LoanWriteBackHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepaymentBillUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("loans");
        sic.add("e_ispayinst");
        sic.add("e_loanbill");
        sic.add("e_repayamount");
        sic.add("repayapplyf7");
        sic.add("billno");
        sic.add("paybill");
        sic.add("confirmstatus");
        sic.add("lendernature");
        sic.add("confirmer");
        sic.add("confirmtime");
        sic.add("creditortype");
        sic.add("settlestatus");
        sic.add("loantype");
        sic.add("creditorg");
        sic.add("org");
        sic.add("datasource");
        sic.add("bizdate");
        sic.add("bankcheckflag");
        sic.add("bitbackinfo");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        List<DynamicObject> repayBills = Arrays.stream(dataEntities).sorted((d1, d2) -> d2.getDate("bizdate").compareTo(d1.getDate("bizdate"))).collect(Collectors.toList());
        CfmBillCommonHelper.updateApplyBizStatus(repayBills, (String)"repayapplyf7", (String)"cfm_repayapplybill", (String)ApplyBusinessStatusEnum.HANDING.getValue());
        if (EmptyUtil.isEmpty((String)((String)this.getOperationVariable().get("back")))) {
            BusinessHelper.clearConfirmInfoForUnAudit(repayBills);
        } else {
            BusinessHelper.clearConfirmInfoForBack(repayBills);
        }
        for (DynamicObject repay : repayBills) {
            repay.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            repay.set("paybill", null);
            this.updateSettleStatus(repay);
        }
        this.updateBondLimit(repayBills);
        this.deleleInterest(repayBills);
    }

    private void updateBondLimit(List<DynamicObject> repayBills) {
        if (EmptyUtil.isEmpty(repayBills = repayBills.stream().filter(d -> LoanTypeEnum.isBond((String)d.getString("loantype"))).collect(Collectors.toList()))) {
            return;
        }
        Map<Long, Set<Long>> repayLoanBillIdMap = RepayServiceHelper.getRepayLoanBillIdMap(repayBills);
        HashSet loanBillIds = new HashSet(10);
        repayLoanBillIdMap.values().forEach(loanBillIds::addAll);
        QFilter qFilter = new QFilter("id", "in", loanBillIds).and("occupybondlimit", ">", (Object)0L);
        DynamicObjectCollection loanBillBondColl = QueryServiceHelper.query((String)"cfm_loanbill_bond", (String)"id,occupybondlimit,billno,drawamount", (QFilter[])qFilter.toArray());
        if (loanBillBondColl.isEmpty()) {
            return;
        }
        Map<Long, DynamicObject> loanBillBondMap = loanBillBondColl.stream().collect(Collectors.toMap(d -> d.getLong("id"), d -> d));
        for (DynamicObject dynamicObject : repayBills) {
            for (DynamicObject entry : dynamicObject.getDynamicObjectCollection("loans")) {
                long occupyBondLimitId;
                long loanBillId = entry.getLong("e_loanbill.id");
                DynamicObject loanBillBond = loanBillBondMap.get(loanBillId);
                if (loanBillBond == null || (occupyBondLimitId = loanBillBond.getLong("occupybondlimit")) == 0L) continue;
                BigDecimal repayamount = entry.getBigDecimal("e_repayamount");
                BondLimitHelper.changeLimitOnRepaymentUnAudit((DynamicObject)loanBillBond, (Object)occupyBondLimitId, (BigDecimal)repayamount);
            }
        }
    }

    private void updateSettleStatus(DynamicObject repay) {
        String creditorType = repay.getString("creditortype");
        if (CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType)) {
            String entityName = repay.getDataEntityType().getName();
            if ("cfm_repaymentbill".equals(entityName)) {
                repay.set("settlestatus", (Object)"");
                repay.set("bitbackinfo", null);
            } else {
                repay.set("settlestatus", (Object)SettleCenterStatusEnum.ADDNEW.getValue());
                repay.set("bankcheckflag", null);
            }
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        List repayBills = Arrays.stream(dataEntities).sorted((d1, d2) -> d2.getDate("bizdate").compareTo(d1.getDate("bizdate"))).collect(Collectors.toList());
        HashSet loanBillIds = new HashSet(8);
        for (DynamicObject repayBill : repayBills) {
            loanBillIds.addAll(repayBill.getDynamicObjectCollection("loans").stream().map(d -> d.getDynamicObject("e_loanbill").getLong("id")).collect(Collectors.toSet()));
        }
        LoanWriteBackHelper.writeBack(new ArrayList(loanBillIds), (LoanWBTypeEnum)LoanWBTypeEnum.REPAYMENT);
        RepayServiceHelper.batchCancelReturnCreditLimit(repayBills.stream().filter(this::isAudotConfirm).collect(Collectors.toList()));
    }

    private boolean isAudotConfirm(DynamicObject repayBill) {
        return !CreditorTypeEnum.SETTLECENTER.getValue().equals(repayBill.getString("creditortype")) && BusinessHelper.isAutoConfirm((DynamicObject)repayBill);
    }

    private void deleleInterest(List<DynamicObject> repayBills) {
        Map<Long, Set<Long>> repayLoanBillIdMap = RepayServiceHelper.getIsPayIntRepayLoanBillIdMap(repayBills);
        ArrayList<Long> repayIds = new ArrayList<Long>(repayLoanBillIdMap.keySet());
        HashSet loanBillIds = new HashSet(10);
        repayLoanBillIdMap.values().forEach(loanBillIds::addAll);
        if (repayIds.isEmpty() || loanBillIds.isEmpty()) {
            return;
        }
        QFilter instFilter = new QFilter("repaymentid", "in", repayIds).and(new QFilter("sourcebillid", "in", loanBillIds));
        DynamicObjectCollection interestBills = QueryServiceHelper.query((String)"cfm_interestbill", (String)"id,billstatus", (QFilter[])instFilter.toArray());
        if (interestBills.isEmpty()) {
            return;
        }
        String entityName = repayBills.get(0).getDataEntityType().getName();
        OperateOption create = OperateOption.create();
        create.setVariableValue("repaymentFlag", "true");
        String interestBillEntity = "cfm_interestbill";
        if ("cim_invest_repaybill".equals(entityName)) {
            interestBillEntity = "cim_invest_interestbill";
        } else if ("ifm_repaymentbill".equals(entityName)) {
            interestBillEntity = "ifm_interestbill";
        }
        OperationResult opResult = null;
        List auditIntBillIds = interestBills.stream().filter(d -> BillStatusEnum.isAudit((String)d.getString("billstatus"))).map(d -> d.getLong("id")).collect(Collectors.toList());
        if (!auditIntBillIds.isEmpty() && null != (opResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"unaudit", (String)interestBillEntity, (Object[])auditIntBillIds.toArray(), (OperateOption)create)) && !opResult.isSuccess()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4ed8\u606f\u5355/\u6536\u606f\u5355\u53cd\u5ba1\u6838\u5931\u8d25,\u5931\u8d25\u4fe1\u606f: %s\u3002", (String)"RepaymentBillUnAuditService_0", (String)"tmc-cfm-business", (Object[])new Object[0]), opResult.getMessage()));
        }
        List submitIntBillIds = interestBills.stream().filter(d -> BillStatusEnum.isSubmit((String)d.getString("billstatus"))).map(d -> d.getLong("id")).collect(Collectors.toList());
        if (!submitIntBillIds.isEmpty()) {
            opResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"unsubmit", (String)interestBillEntity, (Object[])submitIntBillIds.toArray(), (OperateOption)create);
        }
        if (null != opResult && !opResult.isSuccess()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4ed8\u606f\u5355/\u6536\u606f\u5355\u53cd\u5ba1\u6838\u5931\u8d25,\u5931\u8d25\u4fe1\u606f: %s\u3002", (String)"RepaymentBillUnAuditService_0", (String)"tmc-cfm-business", (Object[])new Object[0]), opResult.getMessage()));
        }
        List intBillIds = interestBills.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
        opResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"deleteinit", (String)interestBillEntity, (Object[])intBillIds.toArray(), (OperateOption)create);
        if (null != opResult && !opResult.isSuccess()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5220\u9664\u4ed8\u606f\u5355/\u6536\u606f\u5355\u5931\u8d25,\u5931\u8d25\u4fe1\u606f: %s\u3002", (String)"RepaymentBillUnAuditService_1", (String)"tmc-cfm-business", (Object[])new Object[0]), opResult.getMessage()));
        }
    }
}

