/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.repaymentbill;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepaymentBillUnSubmitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("loans");
        sic.add("e_ispayinst");
        sic.add("e_loanbill");
        sic.add("e_repayamount");
        sic.add("billno");
        sic.add("bizdate");
        sic.add("billstatus");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        this.deleleInterest(Arrays.asList(dataEntities));
    }

    private void deleleInterest(List<DynamicObject> repayBills) {
        List allErrorInfo;
        Map<Object, DynamicObject> repayBillMap = repayBills.stream().collect(Collectors.toMap(d -> d.get("id"), d -> d));
        DynamicObjectCollection interestBills = QueryServiceHelper.query((String)"cfm_interestbill", (String)"id,repaymentid", (QFilter[])new QFilter("repaymentid", "in", repayBillMap.keySet()).toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)interestBills)) {
            return;
        }
        Map<Object, DynamicObject> interestBillMap = interestBills.stream().collect(Collectors.toMap(d -> d.get("id"), d -> d));
        OperateOption create = OperateOption.create();
        create.setVariableValue("repaymentFlag", "true");
        OperationResult deleteResult = TmcOperateServiceHelper.execOperate((String)"deleteinit", (String)"cfm_interestbill", (Object[])interestBillMap.keySet().toArray(), (OperateOption)create);
        List successPkIds = deleteResult.getSuccessPkIds();
        if (EmptyUtil.isNoEmpty((Object)successPkIds)) {
            for (Object successPkId : successPkIds) {
                DynamicObject interestBill = interestBillMap.get(successPkId);
                if (interestBill == null) continue;
                DynamicObject repayBill = repayBillMap.get(interestBill.get("repaymentid"));
                repayBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            }
        }
        if (EmptyUtil.isNoEmpty((Object)(allErrorInfo = deleteResult.getAllErrorInfo()))) {
            for (OperateErrorInfo operateErrorInfo : allErrorInfo) {
                DynamicObject interestBill = interestBillMap.get(operateErrorInfo.getPkValue());
                if (interestBill == null) continue;
                DynamicObject repayBill = repayBillMap.get(interestBill.get("repaymentid"));
                repayBill.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
                OperateErrorInfo error = new OperateErrorInfo();
                error.setMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7:%1$s, \u64a4\u9500\u5931\u8d25,\u5220\u9664\u4ed8\u606f\u5355\u5931\u8d25,\u5931\u8d25\u4fe1\u606f: %2$s\u3002", (String)"RepaymentBillUnSubmitService_0", (String)"tmc-cfm-business", (Object[])new Object[0]), repayBill.getString("billno"), operateErrorInfo.getMessage()));
                error.setLevel(ErrorLevel.Error);
                this.getOperationResult().addErrorInfo(error);
            }
        }
    }
}

