/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.opservice.scheme;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinancingSchemeSaveService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] data) throws KDException {
        List loanApplyIds = Arrays.stream(data).map(v -> v.getDynamicObject("loanapply").getPkValue()).collect(Collectors.toList());
        List schemeIds = Arrays.stream(data).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        DynamicObjectCollection schemesFromDB = QueryServiceHelper.query((String)EntityMetadataCache.getDataEntityType((String)"cfm_financingscheme").getName(), (String)"id,loanapply", (QFilter[])new QFilter[]{new QFilter("id", "in", schemeIds)});
        loanApplyIds.addAll(schemesFromDB.stream().map(v -> v.get("loanapply")).collect(Collectors.toList()));
        HashMap schemeApplyMap = schemesFromDB.stream().collect(Collectors.toMap(k -> k.get("id"), v -> v.get("loanapply"), (o1, o2) -> o1, HashMap::new));
        DynamicObject[] loanApplys = TmcDataServiceHelper.load((Object[])loanApplyIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cfm_loan_apply"));
        HashMap loanApplysMap = Arrays.stream(loanApplys).collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v, (o1, o2) -> o1, HashMap::new));
        ArrayList<DynamicObject> waiteSaveLoanBills = new ArrayList<DynamicObject>(10);
        for (DynamicObject financingScheme : data) {
            DynamicObject loanapply = financingScheme.getDynamicObject("loanapply");
            financingScheme.set("org", loanapply.getDynamicObject("org").getPkValue());
            financingScheme.set("applydate", (Object)DateUtils.getCurrentTime());
            Object schemeId = financingScheme.getPkValue();
            Object loanApplyId = loanapply.getPkValue();
            Object oldLoanApplyId = schemeApplyMap.get(schemeId);
            DynamicObject loanApply = (DynamicObject)loanApplysMap.get(loanApplyId);
            financingScheme.set("status", (Object)loanApply.getString("billstatus"));
            if (EmptyUtil.isNoEmpty(oldLoanApplyId) && oldLoanApplyId.equals(loanApplyId)) continue;
            DynamicObjectCollection schemeEntry = loanApply.getDynamicObjectCollection("entrys");
            DynamicObject addNew = schemeEntry.addNew();
            addNew.set("e_scheme", (Object)financingScheme);
            waiteSaveLoanBills.add(loanApply);
            if (!EmptyUtil.isNoEmpty(oldLoanApplyId)) continue;
            DynamicObject oldLoanApply = (DynamicObject)loanApplysMap.get(oldLoanApplyId);
            DynamicObjectCollection relEntrys = oldLoanApply.getDynamicObjectCollection("entrys");
            for (DynamicObject relEntry : relEntrys) {
                if (!relEntry.getDynamicObject("e_scheme").getPkValue().equals(schemeId)) continue;
                relEntrys.remove((Object)relEntry);
                break;
            }
            if (waiteSaveLoanBills.contains(oldLoanApply)) continue;
            waiteSaveLoanBills.add(oldLoanApply);
        }
        SaveServiceHelper.save((DynamicObject[])waiteSaveLoanBills.toArray(new DynamicObject[waiteSaveLoanBills.size()]));
    }
}

