/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.service.loanbill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.LoanWBTypeEnum;
import kd.tmc.cfm.common.helper.LoanWriteBackHelper;
import kd.tmc.fbp.common.bean.LoanMarketRateBean;
import kd.tmc.fbp.common.constant.RpcResult;
import kd.tmc.fbp.common.constant.RpcResultStatusCode;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanMarketRateWriterBackService {
    private static final Log logger = LogFactory.getLog(LoanMarketRateWriterBackService.class);
    private static final String LOAN_MARKET_PROP = "currency,lendingmarket,termcategory";

    public String loanMarketRateWriterBack(List<String> params) {
        RpcResult recResult = new RpcResult();
        try {
            String loanMarketRateStr = params.get(0);
            List loanMarketRateBeans = (List)JSON.parseObject((String)loanMarketRateStr, (TypeReference)new TypeReference<List<LoanMarketRateBean>>(){}, (Feature[])new Feature[0]);
            Set currencySet = loanMarketRateBeans.stream().map(LoanMarketRateBean::getCurrencyId).collect(Collectors.toSet());
            Set lendMarketSet = loanMarketRateBeans.stream().map(LoanMarketRateBean::getLendingMarketId).collect(Collectors.toSet());
            Set termCategorySet = loanMarketRateBeans.stream().map(LoanMarketRateBean::getTremCodeId).collect(Collectors.toSet());
            List loanMarketRateIds = loanMarketRateBeans.stream().map(LoanMarketRateBean::getId).collect(Collectors.toList());
            DynamicObjectCollection dbLoanMarketRateDos = QueryServiceHelper.query((String)MetadataServiceHelper.getDataEntityType((String)"fbd_loanmarketrate").getName(), (String)LOAN_MARKET_PROP, (QFilter[])new QFilter[]{new QFilter("id", "in", loanMarketRateIds)});
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)dbLoanMarketRateDos)) {
                Set currencyDBSet = dbLoanMarketRateDos.stream().map(o -> o.get("currency")).collect(Collectors.toSet());
                currencySet.addAll(currencyDBSet);
                Set lendMarketDBSet = dbLoanMarketRateDos.stream().map(o -> o.get("lendingmarket")).collect(Collectors.toSet());
                lendMarketSet.addAll(lendMarketDBSet);
                Set termCategoryDBSet = dbLoanMarketRateDos.stream().map(o -> o.get("termcategory")).collect(Collectors.toSet());
                termCategorySet.addAll(termCategoryDBSet);
            }
            QFilter filter = new QFilter("interesttype", "=", (Object)InterestTypeEnum.FLOAT.getValue()).or(new QFilter("renewalinteresttype", "=", (Object)InterestTypeEnum.FLOAT.getValue())).and(new QFilter("drawtype", "!=", (Object)DrawTypeEnum.CLOSEOUT.getValue()));
            QFilter currenyFilter = new QFilter("currency", "in", currencySet);
            QFilter ratetypeFilter = new QFilter("exratetype", "in", lendMarketSet).or(new QFilter("ratetype", "in", lendMarketSet));
            QFilter rateDeadlineFilter = new QFilter("exratedeadline", "in", termCategorySet).or(new QFilter("ratedeadline", "in", termCategorySet));
            List loanBillIds = QueryServiceHelper.queryPrimaryKeys((String)"cfm_loanbill", (QFilter[])new QFilter[]{filter, currenyFilter, ratetypeFilter, rateDeadlineFilter}, null, (int)-1);
            if (EmptyUtil.isNoEmpty((Object)loanBillIds)) {
                LoanWriteBackHelper.writeBack(loanBillIds.stream().map(d -> (Long)d).collect(Collectors.toList()), (LoanWBTypeEnum)LoanWBTypeEnum.REPAYPLAN);
            }
        }
        catch (Exception e) {
            recResult.setStatusCode(RpcResultStatusCode.ERROR);
            recResult.setMessage(e.getMessage());
            logger.error((Throwable)e);
        }
        return JSON.toJSONString((Object)recResult);
    }
}

