/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.service.repay;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.ReturnCreditLimitInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepayServiceHelper {
    private static final String SELECT_LOANBILL_FIELDS = String.join((CharSequence)",", "id", "creditlimit", "datasource", "loancontractbill", "banksyndicate_entry", "banksyndicate_entry.e_bankcreditlimit", "banksyndicate_entry.e_shareamount", "drawamount", "currency", "productfactory", "productfactory.isloancommit");
    private static final String SELECT_BOND_PROP = "id,billno,currency,notrepayamount,drawamount,investor_entry.e_creditlimit,investor_entry.e_investamount,investor_entry.e_avalinvestamt";

    public static void returnCreditLimit(List<DynamicObject> repayBills) {
        if (EmptyUtil.isEmpty(repayBills)) {
            return;
        }
        ArrayList<DynamicObject> repayBillBondList = new ArrayList<DynamicObject>(repayBills.size());
        ArrayList<DynamicObject> repayBillList = new ArrayList<DynamicObject>(repayBills.size());
        for (DynamicObject repayBill : repayBills) {
            String dataSource = repayBill.getString("datasource");
            if (DataSourceEnum.isCfm((String)dataSource) || DataSourceEnum.isFl((String)dataSource) || DataSourceEnum.isInvest((String)dataSource) || DataSourceEnum.isIfm((String)dataSource)) {
                repayBillList.add(repayBill);
                continue;
            }
            if (!DataSourceEnum.isBond((String)dataSource)) continue;
            repayBillBondList.add(repayBill);
        }
        if (!repayBillList.isEmpty()) {
            RepayServiceHelper.returnCreditLimitFromCfm(repayBillList);
        }
        if (!repayBillBondList.isEmpty()) {
            RepayServiceHelper.returnCreditLimitFromBond(repayBillBondList);
        }
    }

    public static void returnCreditLimit(DynamicObject repayBill) {
        RepayServiceHelper.returnCreditLimit(Collections.singletonList(repayBill));
    }

    public static void returnCreditLimitFromCfm(List<DynamicObject> repayBills) {
        Map<Long, Set<Long>> repayLoanBillIdMap = RepayServiceHelper.getRepayLoanBillIdMap(repayBills);
        HashSet loanBillIds = new HashSet(10);
        repayLoanBillIdMap.values().forEach(loanBillIds::addAll);
        String loanSelectProps = String.join((CharSequence)",", "amount", "notrepayamount", "creditlimit", "datasource", "loancontractbill", "banksyndicate_entry", "banksyndicate_entry.e_bankcreditlimit", "banksyndicate_entry.e_shareamount", "banksyndicate_entry.e_bank", "drawamount", "currency", "productfactory", "productfactory.isloancommit");
        Map loanBillMap = TmcDataServiceHelper.loadDataAndMapById((String)"cfm_loanbill", (String)loanSelectProps, loanBillIds);
        Set<Long> contractIds = loanBillMap.values().stream().filter(o -> EmptyUtil.isEmpty((DynamicObject)o.getDynamicObject("creditlimit"))).map(t -> t.getLong("loancontractbill.id")).collect(Collectors.toSet());
        Map<Long, DynamicObject> contractMap = RepayServiceHelper.getContractMap(contractIds);
        ArrayList<ReturnCreditLimitInfo> paramList = new ArrayList<ReturnCreditLimitInfo>(repayBills.size());
        for (DynamicObject repayBill : repayBills) {
            Set<Long> loanBillIdSet = repayLoanBillIdMap.get(repayBill.getLong("id"));
            List<DynamicObject> loandBills = loanBillMap.values().stream().filter(d -> loanBillIdSet.contains(d.getLong("id"))).collect(Collectors.toList());
            List<ReturnCreditLimitInfo> returnCreditLimit = RepayServiceHelper.getReturnCreditLimitParam(repayBill, loandBills, contractMap);
            paramList.addAll(returnCreditLimit);
        }
        if (paramList.size() > 0) {
            CreditLimitServiceHelper.batchRreturnCreditLimit(paramList);
        }
    }

    public static void returnCreditLimitFromCfm(DynamicObject repayBill) {
        RepayServiceHelper.returnCreditLimitFromCfm(Collections.singletonList(repayBill));
    }

    private static List<ReturnCreditLimitInfo> getReturnCreditLimitParam(DynamicObject repayBill, List<DynamicObject> loandBills, Map<Long, DynamicObject> contractMap) {
        ArrayList<ReturnCreditLimitInfo> paramList = new ArrayList<ReturnCreditLimitInfo>(loandBills.size());
        DynamicObjectCollection entrys = repayBill.getDynamicObjectCollection("loans");
        Map<Object, Object> slBankAmountMap = new HashMap();
        if (LoanTypeEnum.isBanksLoan((String)repayBill.getString("loantype"))) {
            DynamicObjectCollection slBankEntrys = repayBill.getDynamicObjectCollection("slentryentity");
            slBankAmountMap = slBankEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("s_loanbillno")) && EmptyUtil.isNoEmpty((BigDecimal)o.getBigDecimal("s_repayamount"))).collect(Collectors.toMap(o -> o.getDynamicObject("s_bank").getLong("id"), o -> o.getBigDecimal("s_repayamount"), (v1, v2) -> v2));
        }
        Map<Long, BigDecimal> repayMap = entrys.stream().collect(Collectors.toMap(v -> v.getLong("e_loanbill.id"), v -> v.getBigDecimal("e_repayamount")));
        Map<Long, BigDecimal> repayConTractMap = entrys.stream().collect(Collectors.toMap(v -> v.getLong("e_loanbill.id"), v -> v.getBigDecimal("e_convertrepayamt")));
        for (DynamicObject loandBill : loandBills) {
            Object loandContract;
            Long creditUseSourceBillId = loandBill.getLong("id");
            BigDecimal returnAmt = repayMap.get(creditUseSourceBillId);
            String entityName = RepayServiceHelper.getLoanEntityName(loandBill.getString("datasource"));
            BigDecimal notRepayAmount = loandBill.getBigDecimal("notrepayamount");
            HashMap<Long, Object> entryReturnAmtMap = null;
            DynamicObjectCollection bankSyndicateEntry = loandBill.getDynamicObjectCollection("banksyndicate_entry");
            List loanbillCreditLimitEntry = bankSyndicateEntry.stream().filter(o -> o.getDynamicObject("e_bankcreditlimit") != null).collect(Collectors.toList());
            boolean isContractCreditLimit = false;
            if ((EmptyUtil.isEmpty((Object)loandBill.get("creditlimit")) && EmptyUtil.isEmpty(loanbillCreditLimitEntry) || !RepayServiceHelper.isCreditUse(loandBill.getLong("id"), null)) && EmptyUtil.isNoEmpty((DynamicObject)(loandContract = loandBill.getDynamicObject("loancontractbill")))) {
                DynamicObject contract = contractMap.get(loandContract.getLong("id"));
                DynamicObject creditLimit = contract.getDynamicObject("creditlimit");
                bankSyndicateEntry = contract.getDynamicObjectCollection("banksyndicate_entry");
                List entryCredList = bankSyndicateEntry.stream().filter(o -> o.getDynamicObject("e_creditlimit") != null).collect(Collectors.toList());
                if (EmptyUtil.isNoEmpty(entryCredList) || EmptyUtil.isNoEmpty((DynamicObject)creditLimit)) {
                    isContractCreditLimit = true;
                    if (contract.getBoolean("iscycleloan") || contract.getBoolean("issyncdraw") && !RepayServiceHelper.isCreditUse(contract.getLong("id"), null)) continue;
                }
                notRepayAmount = contract.getBigDecimal("notrepayamount").add(contract.getBigDecimal("notdrawamount"));
                entityName = RepayServiceHelper.getConEntityName(loandBill.getString("datasource"));
                creditUseSourceBillId = loandContract.getLong("id");
                returnAmt = repayConTractMap.get(loandBill.getLong("id"));
                if (EmptyUtil.isNoEmpty(entryCredList)) {
                    entryReturnAmtMap = new HashMap(entryCredList.size());
                    for (DynamicObject entryCred : entryCredList) {
                        DynamicObject bank;
                        BigDecimal shareAmount = entryCred.getBigDecimal("e_shareamount");
                        if (EmptyUtil.isEmpty((BigDecimal)shareAmount) || EmptyUtil.isEmpty((DynamicObject)(bank = entryCred.getDynamicObject("e_bank"))) || !slBankAmountMap.containsKey(bank.getLong("id")) || EmptyUtil.isEmpty((Long)bank.getLong("id"))) continue;
                        entryReturnAmtMap.put(entryCred.getLong("id"), slBankAmountMap.get(bank.getLong("id")));
                    }
                }
            }
            if (!isContractCreditLimit && EmptyUtil.isNoEmpty(loanbillCreditLimitEntry)) {
                entryReturnAmtMap = new HashMap<Long, Object>(loanbillCreditLimitEntry.size());
                creditUseSourceBillId = loandBill.getLong("id");
                entityName = RepayServiceHelper.getLoanEntityName(loandBill.getString("datasource"));
                notRepayAmount = loandBill.getBigDecimal("notrepayamount");
                returnAmt = repayMap.get(creditUseSourceBillId);
                loandContract = loanbillCreditLimitEntry.iterator();
                while (loandContract.hasNext()) {
                    DynamicObject bank;
                    DynamicObject entryCred = (DynamicObject)loandContract.next();
                    BigDecimal shareAmount = entryCred.getBigDecimal("e_shareamount");
                    if (EmptyUtil.isEmpty((BigDecimal)shareAmount) || EmptyUtil.isEmpty((DynamicObject)(bank = entryCred.getDynamicObject("e_bank"))) || !slBankAmountMap.containsKey(bank.getLong("id")) || EmptyUtil.isEmpty((Long)bank.getLong("id"))) continue;
                    entryReturnAmtMap.put(entryCred.getLong("id"), slBankAmountMap.get(bank.getLong("id")));
                }
            }
            if (EmptyUtil.isEmpty((Object)loandBill.get("creditlimit")) && EmptyUtil.isEmpty(loanbillCreditLimitEntry) && !isContractCreditLimit) continue;
            ReturnCreditLimitInfo returnInfo = RepayServiceHelper.getReturnInfo(repayBill);
            if (entryReturnAmtMap != null) {
                returnInfo.setEntryReturnAmtMap(entryReturnAmtMap);
            } else {
                returnInfo.setReturnAmt(returnAmt);
            }
            returnInfo.setId(creditUseSourceBillId);
            returnInfo.setEntityName(entityName);
            returnInfo.setLast(notRepayAmount.compareTo(BigDecimal.ZERO) == 0);
            returnInfo.setReturnBillId(creditUseSourceBillId);
            returnInfo.setBizBillId(Long.valueOf(repayBill.getLong("id")));
            paramList.add(returnInfo);
        }
        return paramList;
    }

    public static void returnCreditLimitFromBond(List<DynamicObject> repayBills) {
        Map<Long, Set<Long>> repayLoanBillIdMap = RepayServiceHelper.getRepayLoanBillIdMap(repayBills);
        HashSet loanBillIds = new HashSet(10);
        repayLoanBillIdMap.values().forEach(loanBillIds::addAll);
        Map loanBillMap = TmcDataServiceHelper.loadDataAndMapById((String)"cfm_loanbill_bond", (String)SELECT_BOND_PROP, loanBillIds);
        ArrayList<ReturnCreditLimitInfo> paramList = new ArrayList<ReturnCreditLimitInfo>(10);
        for (DynamicObject repayBill : repayBills) {
            long repayBillId = repayBill.getLong("id");
            Set<Long> loanBillIdSet = repayLoanBillIdMap.get(repayBillId);
            List<DynamicObject> bondBills = loanBillMap.values().stream().filter(d -> loanBillIdSet.contains(d.getLong("id"))).collect(Collectors.toList());
            paramList.addAll(RepayServiceHelper.getReturnCreditLimitParamForBond(repayBill, bondBills));
        }
        if (EmptyUtil.isNoEmpty(paramList)) {
            CreditLimitServiceHelper.batchRreturnCreditLimit(paramList);
        }
    }

    public static void returnCreditLimitFromBond(DynamicObject repayBill) {
        RepayServiceHelper.returnCreditLimitFromBond(Collections.singletonList(repayBill));
    }

    private static List<ReturnCreditLimitInfo> getReturnCreditLimitParamForBond(DynamicObject repayBill, List<DynamicObject> bondBills) {
        ArrayList<ReturnCreditLimitInfo> paramList = new ArrayList<ReturnCreditLimitInfo>(bondBills.size());
        DynamicObjectCollection entries = repayBill.getDynamicObjectCollection("loans");
        Map repayMap = entries.stream().collect(HashMap::new, (k, v) -> k.put(v.getLong("e_loanbill.id"), v.getBigDecimal("e_repayamount")), HashMap::putAll);
        for (DynamicObject bondBill : bondBills) {
            DynamicObjectCollection investEntries = bondBill.getDynamicObjectCollection("investor_entry");
            List entryCredList = investEntries.stream().filter(o -> o.getDynamicObject("e_creditlimit") != null).collect(Collectors.toList());
            if (EmptyUtil.isEmpty(entryCredList)) continue;
            BigDecimal returnAmt = (BigDecimal)repayMap.get(bondBill.getLong("id"));
            int currencyPres = bondBill.getDynamicObject("currency").getInt("amtprecision");
            DynamicObjectCollection repayments = QueryServiceHelper.query((String)"cfm_repaymentbill", (String)("id," + String.join((CharSequence)".", "loans.e_repayamount")), (QFilter[])new QFilter[]{new QFilter("loans.e_loanbill", "=", (Object)bondBill.getLong("id")).and("isbuyback", "=", (Object)false).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())});
            BigDecimal sumRepayAmt = repayments.stream().map(d -> d.getBigDecimal(String.join((CharSequence)".", "loans", "e_repayamount"))).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal notRepayAmount = bondBill.getBigDecimal("notrepayamount").add(sumRepayAmt);
            HashMap<Long, BigDecimal> entryReturnAmtMap = new HashMap<Long, BigDecimal>(entryCredList.size());
            for (DynamicObject entryCred : entryCredList) {
                BigDecimal avaInvestAmt = entryCred.getBigDecimal("e_avalinvestamt");
                entryReturnAmtMap.put(entryCred.getLong("id"), avaInvestAmt.multiply(returnAmt).divide(notRepayAmount, currencyPres));
            }
            ReturnCreditLimitInfo returnInfo = RepayServiceHelper.getReturnInfo(repayBill);
            returnInfo.setId(Long.valueOf(bondBill.getLong("id")));
            returnInfo.setEntityName(bondBill.getDataEntityType().getName());
            returnInfo.setLast(bondBill.getBigDecimal("notrepayamount").compareTo(BigDecimal.ZERO) == 0);
            returnInfo.setReturnBillId(Long.valueOf(bondBill.getLong("id")));
            returnInfo.setEntryReturnAmtMap(entryReturnAmtMap);
            paramList.add(returnInfo);
        }
        return paramList;
    }

    public static ReturnCreditLimitInfo getReturnInfo(DynamicObject bill) {
        ReturnCreditLimitInfo param = new ReturnCreditLimitInfo();
        param.setPreOccupy(false);
        param.setPreEntityName(bill.getDynamicObjectType().getName());
        param.setBizBillId(Long.valueOf(bill.getLong("id")));
        param.setReturnTime(bill.getDate("bizdate"));
        return param;
    }

    private static Map<Long, DynamicObject> getContractMap(Set<Long> contractIds) {
        if (EmptyUtil.isEmpty(contractIds)) {
            return Collections.emptyMap();
        }
        String selectProps = String.join((CharSequence)",", "creditlimit", "notrepayamount", "notdrawamount", "e_bank", "e_shareamount", "e_creditlimit", "iscycleloan", "issyncdraw");
        return TmcDataServiceHelper.loadDataAndMapById((String)"cfm_loancontractbill", (String)selectProps, contractIds);
    }

    public static void batchCancelReturnCreditLimit(List<DynamicObject> repayBills) {
        if (EmptyUtil.isEmpty(repayBills)) {
            return;
        }
        ArrayList<ReturnCreditLimitInfo> paramList = new ArrayList<ReturnCreditLimitInfo>(repayBills.size());
        ArrayList<DynamicObject> bondRepayBillList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> repayBillList = new ArrayList<DynamicObject>(10);
        for (DynamicObject repayBill : repayBills) {
            String dataSource = repayBill.getString("datasource");
            if (DataSourceEnum.isBond((String)dataSource)) {
                bondRepayBillList.add(repayBill);
                continue;
            }
            if (!DataSourceEnum.isCfm((String)dataSource) && !DataSourceEnum.isFl((String)dataSource) && !DataSourceEnum.isInvest((String)dataSource) && !DataSourceEnum.isIfm((String)dataSource)) continue;
            repayBillList.add(repayBill);
        }
        RepayServiceHelper.buildCreditParamBond(bondRepayBillList, paramList);
        RepayServiceHelper.buildCreditParamCfm(repayBillList, paramList);
        if (!paramList.isEmpty()) {
            CreditLimitServiceHelper.batchCancelReturnCreditLimit(paramList);
        }
    }

    public static void batchCancelReturnCreditLimit(DynamicObject repayBill) {
        RepayServiceHelper.batchCancelReturnCreditLimit(Collections.singletonList(repayBill));
    }

    private static void buildCreditParamBond(List<DynamicObject> repayBills, List<ReturnCreditLimitInfo> paramList) {
        if (EmptyUtil.isEmpty(repayBills)) {
            return;
        }
        Map<Long, Set<Long>> repayLoanBillIdMap = RepayServiceHelper.getRepayLoanBillIdMap(repayBills);
        HashSet loanBillIds = new HashSet(10);
        repayLoanBillIdMap.values().forEach(loanBillIds::addAll);
        QFilter qFilter = new QFilter("id", "in", loanBillIds).and("investor_entry.e_creditlimit", ">", (Object)0L);
        DynamicObjectCollection bondBillColls = QueryServiceHelper.query((String)"cfm_loanbill_bond", (String)"id,billno,investor_entry.e_creditlimit", (QFilter[])qFilter.toArray());
        if (bondBillColls.isEmpty()) {
            return;
        }
        for (DynamicObject repayBill : repayBills) {
            long repayBillId = repayBill.getLong("id");
            Set<Long> loanBillIdSet = repayLoanBillIdMap.get(repayBillId);
            List bondBills = bondBillColls.stream().filter(d -> loanBillIdSet.contains(d.getLong("id"))).collect(Collectors.toList());
            for (DynamicObject bondBill : bondBills) {
                long loanBillId = bondBill.getLong("id");
                ReturnCreditLimitInfo param = new ReturnCreditLimitInfo();
                param.setId(Long.valueOf(loanBillId));
                param.setEntityName("cfm_loanbill_bond");
                param.setPreOccupy(false);
                param.setReturnBillId(Long.valueOf(loanBillId));
                param.setBizBillId(Long.valueOf(repayBillId));
                paramList.add(param);
            }
        }
    }

    public static Map<Long, Set<Long>> getRepayLoanBillIdMap(List<DynamicObject> repayBills) {
        HashMap<Long, Set<Long>> repayLoanBillIdMap = new HashMap<Long, Set<Long>>(10);
        for (DynamicObject repayBill : repayBills) {
            Set loanBillIdSet = repayBill.getDynamicObjectCollection("loans").stream().map(o -> o.getLong("e_loanbill.id")).collect(Collectors.toSet());
            repayLoanBillIdMap.put(repayBill.getLong("id"), loanBillIdSet);
        }
        return repayLoanBillIdMap;
    }

    public static Map<Long, Set<Long>> getIsPayIntRepayLoanBillIdMap(List<DynamicObject> repayBills) {
        HashMap<Long, Set<Long>> repayLoanBillIdMap = new HashMap<Long, Set<Long>>(10);
        for (DynamicObject repayBill : repayBills) {
            Set loanIds = repayBill.getDynamicObjectCollection("loans").stream().filter(d -> d.getBoolean("e_ispayinst")).map(d -> d.getLong("e_loanbill.id")).collect(Collectors.toSet());
            if (!EmptyUtil.isNoEmpty(loanIds)) continue;
            repayLoanBillIdMap.put(repayBill.getLong("id"), loanIds);
        }
        return repayLoanBillIdMap;
    }

    private static void buildCreditParamCfm(List<DynamicObject> repayBills, List<ReturnCreditLimitInfo> paramList) {
        if (EmptyUtil.isEmpty(repayBills)) {
            return;
        }
        Map<Long, Set<Long>> repayLoanBillIdMap = RepayServiceHelper.getRepayLoanBillIdMap(repayBills);
        HashSet loanBillIds = new HashSet(10);
        repayLoanBillIdMap.values().forEach(loanBillIds::addAll);
        DynamicObject[] loanBills = TmcDataServiceHelper.load((String)"cfm_loanbill", (String)SELECT_LOANBILL_FIELDS, (QFilter[])new QFilter("id", "in", loanBillIds).toArray());
        Set<Long> contractIds = Arrays.stream(loanBills).filter(o -> EmptyUtil.isEmpty((Object)o.get("creditlimit"))).map(t -> t.getLong("loancontractbill.id")).collect(Collectors.toSet());
        Map<Long, DynamicObject> contractMap = RepayServiceHelper.getContractMap(contractIds);
        for (DynamicObject repayBill : repayBills) {
            long repayBillId = repayBill.getLong("id");
            Set<Long> loanBillIdSet = repayLoanBillIdMap.get(repayBillId);
            List<DynamicObject> loanBillList = Arrays.stream(loanBills).filter(d -> loanBillIdSet.contains(d.getLong("id"))).collect(Collectors.toList());
            RepayServiceHelper.buildCreditParamCfm(paramList, repayBillId, loanBillList, contractMap);
        }
    }

    private static void buildCreditParamCfm(List<ReturnCreditLimitInfo> paramList, long repayBillId, List<DynamicObject> LoanBills, Map<Long, DynamicObject> contractMap) {
        Long id = null;
        String entityName = null;
        for (DynamicObject loanBill : LoanBills) {
            DynamicObjectCollection bankSyndicateEntry = loanBill.getDynamicObjectCollection("banksyndicate_entry");
            List entryCredList = bankSyndicateEntry.stream().filter(o -> o.getDynamicObject("e_bankcreditlimit") != null).collect(Collectors.toList());
            boolean isReturn = false;
            if ((EmptyUtil.isNoEmpty((Object)loanBill.get("creditlimit")) || EmptyUtil.isNoEmpty(entryCredList)) && RepayServiceHelper.isCreditUse(loanBill.getLong("id"), null)) {
                isReturn = true;
                entityName = RepayServiceHelper.getLoanEntityName(loanBill.getString("datasource"));
                id = loanBill.getLong("id");
            } else {
                DynamicObject contractBill = loanBill.getDynamicObject("loancontractbill");
                if (EmptyUtil.isEmpty((DynamicObject)contractBill)) continue;
                long loanContractId = contractBill.getLong("id");
                DynamicObject contract = contractMap.get(loanContractId);
                if (EmptyUtil.isNoEmpty((DynamicObject)contract.getDynamicObject("creditlimit"))) {
                    isReturn = true;
                } else {
                    bankSyndicateEntry = contract.getDynamicObjectCollection("banksyndicate_entry");
                    entryCredList = bankSyndicateEntry.stream().filter(o -> o.getDynamicObject("e_creditlimit") != null).collect(Collectors.toList());
                    if (EmptyUtil.isNoEmpty(entryCredList) && RepayServiceHelper.isCreditUse(contract.getLong("id"), null)) {
                        isReturn = true;
                    }
                }
                entityName = RepayServiceHelper.getConEntityName(loanBill.getString("datasource"));
                id = contract.getLong("id");
            }
            if (!isReturn) continue;
            ReturnCreditLimitInfo param = new ReturnCreditLimitInfo();
            param.setId(id);
            param.setEntityName(entityName);
            param.setPreOccupy(false);
            param.setReturnBillId(id);
            param.setBizBillId(Long.valueOf(repayBillId));
            paramList.add(param);
        }
    }

    private static String getLoanEntityName(String dataSource) {
        HashMap<String, String> entityMap = new HashMap<String, String>();
        entityMap.put(DataSourceEnum.CFM.getValue(), "cfm_loanbill");
        entityMap.put(DataSourceEnum.INVEST.getValue(), "cim_invest_loanbill");
        entityMap.put(DataSourceEnum.IFM.getValue(), "ifm_loanbill");
        return (String)entityMap.get(dataSource);
    }

    private static String getConEntityName(String dataSource) {
        HashMap<String, String> entityMap = new HashMap<String, String>();
        entityMap.put(DataSourceEnum.CFM.getValue(), "cfm_loancontractbill");
        entityMap.put(DataSourceEnum.INVEST.getValue(), "cim_invest_contract");
        entityMap.put(DataSourceEnum.IFM.getValue(), "ifm_loancontractbill");
        entityMap.put(DataSourceEnum.FL.getValue(), "fl_leasecontractbill");
        return (String)entityMap.get(dataSource);
    }

    private static boolean isCreditUse(long billid, Set<Long> entryIds) {
        QFilter filter = new QFilter("sourcebillid", "=", (Object)billid).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        if (EmptyUtil.isNoEmpty(entryIds)) {
            filter.and("sourcebillentryid", "in", entryIds);
        }
        return QueryServiceHelper.exists((String)"cfm_credituse", (QFilter[])new QFilter[]{filter});
    }
}

