/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.apply;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.CreditLimitHelper;
import kd.tmc.cfm.common.helper.LoanApplyHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.CreditLimitF7ResBean;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanApplySelectSchemeValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("isneedscheme");
        selector.add("entrys");
        selector.add("e_isselect");
        selector.add("creditlimit");
        selector.add("creditortype");
        selector.add("textcreditor");
        selector.add("creditor");
        selector.add("loantype");
        selector.add("finproduct");
        selector.add("company");
        selector.add("startdate");
        selector.add("enddate");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity data : dataEntity) {
            boolean isNeedScheme;
            Date endDate;
            Date startDate;
            DynamicObject creditor;
            DynamicObject loanApply = data.getDataEntity();
            String creditType = loanApply.getString("creditortype");
            String creditName = loanApply.getString("textcreditor");
            if (!CreditorTypeEnum.OTHER.getValue().equals(creditType) && !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{creditType, creditName}) && EmptyUtil.isEmpty((DynamicObject)(creditor = TmcDataServiceHelper.loadSingleFromCache((String)CreditorTypeEnum.getFormIdByValue((String)creditType), (String)"id,name", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)creditName)})))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u503a\u6743\u4eba'%s'\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"LoanApplySelectSchemeValidator_1", (String)"tmc-cfm-business", (Object[])new Object[]{creditName}));
            }
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{startDate = loanApply.getDate("startdate"), endDate = loanApply.getDate("enddate")}) && startDate.compareTo(endDate) >= 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u9884\u8ba1\u5f00\u59cb\u65e5\u5fc5\u987b\u5c0f\u4e8e\u9884\u8ba1\u7ed3\u675f\u65e5\u671f\u3002", (String)"LoanApplySelectSchemeValidator_2", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            if (!(isNeedScheme = loanApply.getBoolean("isneedscheme"))) {
                this.checkCreditType(data);
                this.checkCreditLimitAmt(data);
            }
            if (!StringUtils.equals((CharSequence)loanApply.getString("billstatus"), (CharSequence)BillStatusEnum.SUBMIT.getValue())) continue;
            DynamicObjectCollection entrys = loanApply.getDynamicObjectCollection("entrys");
            long selectSchemeCount = entrys.stream().filter(v -> v.getBoolean("e_isselect")).count();
            if (!isNeedScheme || selectSchemeCount != 0L) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65b9\u6848\u3002", (String)"LoanApplySelectSchemeValidator_0", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
    }

    private void checkCreditType(ExtendedDataEntity data) {
        DynamicObject applyBill = data.getDataEntity();
        String creditType = applyBill.getString("creditortype");
        String loanType = applyBill.getString("loantype");
        if (LoanTypeEnum.BANKLOAN.getValue().equals(loanType) && !CreditorTypeEnum.BANK.getValue().equals(creditType) && !CreditorTypeEnum.FINORG.getValue().equals(creditType) && !CreditorTypeEnum.SETTLECENTER.getValue().equals(creditType)) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u878d\u8d44\u4e1a\u52a1\u5206\u7c7b\u4e3a\u666e\u901a\u8d37\u6b3e\uff0c\u503a\u6743\u4eba\u7c7b\u578b\u53ea\u80fd\u4e3a\u94f6\u884c\u3001\u975e\u94f6\u884c\u91d1\u878d\u673a\u6784\u6216\u7ed3\u7b97\u4e2d\u5fc3\u3002", (String)"LoanApplySelectSchemeValidator_9", (String)"tmc-cfm-business", (Object[])new Object[0]));
        } else if (LoanTypeEnum.BANKSLOAN.getValue().equals(loanType) && !CreditorTypeEnum.BANK.getValue().equals(creditType)) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u878d\u8d44\u4e1a\u52a1\u5206\u7c7b\u4e3a\u94f6\u56e2\u8d37\u6b3e\uff0c\u503a\u6743\u4eba\u7c7b\u578b\u53ea\u80fd\u4e3a\u94f6\u884c\u3002", (String)"LoanApplySelectSchemeValidator_10", (String)"tmc-cfm-business", (Object[])new Object[0]));
        } else if (!(!LoanTypeEnum.ENTRUSTLOAN.getValue().equals(loanType) && !LoanTypeEnum.LINKLEND.getValue().equals(loanType) || CreditorTypeEnum.INNERUNIT.getValue().equals(creditType) || CreditorTypeEnum.CUSTOM.getValue().equals(creditType) || CreditorTypeEnum.OTHER.getValue().equals(creditType))) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u878d\u8d44\u4e1a\u52a1\u5206\u7c7b\u4e3a\u59d4\u6258\u8d37\u6b3e\u6216\u4f01\u4e1a\u5f80\u6765\uff0c\u503a\u6743\u4eba\u7c7b\u578b\u53ea\u80fd\u4e3a\u5185\u90e8\u5355\u4f4d\u3001\u5ba2\u5546\u6216\u5176\u4ed6\u3002", (String)"LoanApplySelectSchemeValidator_11", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
    }

    private void checkCreditLimitAmt(ExtendedDataEntity data) {
        DynamicObject applyBill = data.getDataEntity();
        DynamicObject creditLimit = applyBill.getDynamicObject("creditlimit");
        String creditorType = applyBill.getString("creditortype");
        if (EmptyUtil.isNoEmpty((DynamicObject)creditLimit)) {
            if (CreditorTypeEnum.OTHER.getValue().equals(creditorType)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u503a\u6743\u4eba\u7c7b\u578b\u5176\u4ed6\uff0c\u4e0d\u652f\u6301\u9884\u5360\u6388\u4fe1\u3002", (String)"LoanApplySelectSchemeValidator_4", (String)"tmc-cfm-business", (Object[])new Object[0]));
                return;
            }
            DynamicObject creditUseBill = CreditLimitServiceHelper.getCreditUseBill((Long)applyBill.getLong("id"), (String)applyBill.getDataEntityType().getName());
            if (EmptyUtil.isEmpty((DynamicObject)creditUseBill)) {
                Object creditLimitBankCateId;
                CreditLimitUseBean bean = new CreditLimitUseBean();
                bean.setPkId(Long.valueOf(applyBill.getLong("id")));
                DynamicObject product = applyBill.getDynamicObject("finproduct");
                DynamicObject credittype = product != null ? product.getDynamicObject("credittype") : null;
                DynamicObject org = applyBill.getDynamicObject("company");
                String billStatus = creditLimit.getString("status");
                if (!BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6\u5355\u975e\u5df2\u5ba1\u6838\u72b6\u6001\u3002", (String)"LoanApplySelectSchemeValidator_6", (String)"tmc-cfm-business", (Object[])new Object[0]));
                    return;
                }
                boolean isClose = creditLimit.getBoolean("isclose");
                if (isClose) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6\u5355\u5df2\u5173\u95ed\u3002", (String)"LoanApplySelectSchemeValidator_7", (String)"tmc-cfm-business", (Object[])new Object[0]));
                    return;
                }
                Object useBankCateId = CreditLimitHelper.getBankCateIdByFinOrgId((Long)LoanApplyHelper.getCreditorId((DynamicObject)applyBill));
                if (!useBankCateId.equals(creditLimitBankCateId = CreditLimitHelper.getBankCateIdByFinOrgId((Long)((Long)creditLimit.getDynamicObject("bank").getPkValue())))) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u503a\u6743\u4eba\u548c\u6388\u4fe1\u673a\u6784\u5bf9\u5e94\u7684\u94f6\u884c\u7c7b\u522b\u4e0d\u5339\u914d\u3002", (String)"LoanApplySelectSchemeValidator_8", (String)"tmc-cfm-business", (Object[])new Object[0]));
                    return;
                }
                bean.setCreditTypeId(Long.valueOf(credittype != null ? credittype.getLong("id") : 0L));
                bean.setOrgId(Long.valueOf(org.getLong("id")));
                bean.setCurrencyId(Long.valueOf(applyBill.getDynamicObject("currency").getLong("id")));
                bean.setCreditLimitId(Long.valueOf(creditLimit.getLong("id")));
                bean.setBizAmt(applyBill.getBigDecimal("amount"));
                bean.setSourceBillId(bean.getPkId());
                bean.setSourceType(applyBill.getDataEntityType().getName());
                bean.setCreditRatio(Constants.ONE_HUNDRED);
                CreditLimitF7ResBean result = CreditLimitServiceHelper.validataCreditLimitAmt((CreditLimitUseBean)bean);
                if (!result.getSuccess().booleanValue()) {
                    this.addErrorMessage(data, result.getMsg());
                }
            }
        }
    }
}

