/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.bill;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.AmountProp;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.resource.TmcBizResource;

public class BizBillAmountMaxValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.checkAmountMaxValue(dataEntity);
        }
    }

    private void checkAmountMaxValue(ExtendedDataEntity data) {
        DynamicObject bill = data.getDataEntity();
        for (IDataEntityProperty prop : bill.getDataEntityType().getProperties()) {
            BigDecimal amount;
            if (!(prop instanceof AmountProp) || (amount = bill.getBigDecimal(prop.getName())) == null || amount.compareTo(Constants.MAX_AMOUNT) <= 0) continue;
            this.addErrorMessage(data, new TmcBizResource().checkAmountMaxValue(prop.getDisplayName().getLocaleValue()));
        }
    }
}

