/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.bond;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class BondBillLimitOccupyValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            Optional<DynamicObject> firstEntryOptional;
            DynamicObject entity = extendedDataEntity.getDataEntity();
            DynamicObject occupybondlimit = entity.getDynamicObject("occupybondlimit");
            Date bizdate = entity.getDate("bizdate");
            BigDecimal drawAmount = entity.getBigDecimal("drawamount");
            if (occupybondlimit == null) continue;
            DynamicObject limit = TmcDataServiceHelper.loadSingle((Object)occupybondlimit.getPkValue(), (String)"bdim_bond_limit", (String)"status,enable,effectdate,expirydate,availamt,entry.limitbillid,entry.limitadvanceamt");
            String billstatus = limit.getString("status");
            Date effectdate = limit.getDate("effectdate");
            Date expirydate = limit.getDate("expirydate");
            String enable = limit.getString("enable");
            BigDecimal availamt = limit.getBigDecimal("availamt");
            DynamicObjectCollection entry = limit.getDynamicObjectCollection("entry");
            if (!"C".equals(billstatus)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6ce8\u518c\u989d\u5ea6\u7684\u5355\u636e\u72b6\u6001\u4e0d\u662f\u5df2\u5ba1\u6838\uff0c\u8bf7\u4fee\u6539\u5360\u7528\u6ce8\u518c\u989d\u5ea6\u3002", (String)"BondLimitOccupyOpValidator_0", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            if ("0".equals(enable)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6ce8\u518c\u989d\u5ea6\u7684\u4f7f\u7528\u72b6\u6001\u4e0d\u53ef\u7528\uff0c\u8bf7\u4fee\u6539\u5360\u7528\u6ce8\u518c\u989d\u5ea6\u3002", (String)"BondLimitOccupyOpValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            if (bizdate.after(expirydate) || bizdate.before(effectdate)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53d1\u884c\u65e5\u671f\u4e0d\u5728\u53d1\u884c\u989d\u5ea6\u6709\u6548\u671f\u5185\uff0c\u8bf7\u4fee\u6539\u5360\u7528\u6ce8\u518c\u989d\u5ea6\u3002", (String)"BondLimitOccupyOpValidator_2", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            if ((firstEntryOptional = entry.stream().filter(e -> e.getLong("limitbillid") == ((Long)entity.getPkValue()).longValue()).findFirst()).isPresent()) {
                DynamicObject dynamicObject = firstEntryOptional.get();
                BigDecimal limitadvanceamt = dynamicObject.getBigDecimal("limitadvanceamt");
                availamt = availamt.add(limitadvanceamt);
            }
            if (drawAmount.compareTo(availamt) <= 0) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6ce8\u518c\u989d\u5ea6\u53ef\u7528\u989d\u5ea6\u4e0d\u8db3\uff0c\u8bf7\u4fee\u6539\u5360\u7528\u6ce8\u518c\u989d\u5ea6\u3002", (String)"BondLimitOccupyOpValidator_3", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
    }
}

