/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.bondbillplan;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BondBillPlanValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> selectorList = new ArrayList<String>(20);
        selectorList.add("issyncdraw");
        selectorList.add("productfactory");
        selectorList.add("interesttype");
        selectorList.add("referencerate");
        selectorList.add("rateadjuststyle");
        selectorList.add("ratefloatpoint");
        selectorList.add("ratesign");
        selectorList.add("rateadjustdate");
        selectorList.add("expiredate");
        selectorList.add("rateadjustcycletype");
        selectorList.add("rateadjustcycle");
        selectorList.add("syncbizdate");
        selectorList.add("startintdate");
        selectorList.add("expiredate");
        selectorList.add("issyncdraw");
        selectorList.add("amount");
        selectorList.add("syncdrawamount");
        selectorList.add("fixedrepayamount");
        selectorList.add("investor_entry");
        selectorList.add("investor_entry.e_investamount");
        selectorList.add("investor_entry.e_investortype");
        selectorList.add("investor_entry.e_investorname");
        selectorList.add("investor_entry.e_investorid");
        return selectorList;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource(DataSourceEnum.BOND.getValue());
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject bondPlan = dataEntity.getDataEntity();
            if (!bondPlan.getBoolean("issyncdraw")) continue;
            this.validateFloatRate(dataEntity, bondPlan, bizResource);
            this.validateInvestEntry(dataEntity, bondPlan);
            this.validateSyncDrawInfo(dataEntity);
        }
    }

    private void validateFloatRate(ExtendedDataEntity dataEntity, DynamicObject loanContract, AbstractBizResource bizResource) {
        DynamicObject productFactory = loanContract.getDynamicObject("productfactory");
        if ((EmptyUtil.isEmpty((DynamicObject)productFactory) || productFactory.getBoolean("iscallint")) && InterestTypeEnum.FLOAT.getValue().equals(loanContract.getString("interesttype"))) {
            if (EmptyUtil.isEmpty((String)loanContract.getString("interesttype"))) {
                this.addErrorMessage(dataEntity, bizResource.getRateTypeNotNull());
            }
            if (EmptyUtil.isEmpty((DynamicObject)loanContract.getDynamicObject("referencerate"))) {
                this.addErrorMessage(dataEntity, bizResource.getReferenceRateNotNull());
            }
            if (EmptyUtil.isEmpty((String)loanContract.getString("rateadjuststyle"))) {
                this.addErrorMessage(dataEntity, bizResource.getRateAdjustStyleNotNull());
            }
            if (EmptyUtil.isNoEmpty((BigDecimal)loanContract.getBigDecimal("ratefloatpoint")) && EmptyUtil.isEmpty((String)loanContract.getString("ratesign"))) {
                this.addErrorMessage(dataEntity, bizResource.getRatesignNotNull());
            }
            if (RateAdjustStyleEnum.CYCLE.getValue().equals(loanContract.getString("rateadjuststyle"))) {
                Date rateAdjustDate = loanContract.getDate("rateadjustdate");
                if (EmptyUtil.isEmpty((Object)rateAdjustDate)) {
                    this.addErrorMessage(dataEntity, bizResource.getRateadjustDateNotNull());
                } else {
                    Date endDate = loanContract.getDate("expiredate");
                    if (rateAdjustDate.compareTo(endDate) >= 0) {
                        this.addErrorMessage(dataEntity, bizResource.getLoanRateadjustDateRange());
                    }
                }
                String rateAdjustCycleType = loanContract.getString("rateadjustcycletype");
                BigDecimal rateAdjustCycle = loanContract.getBigDecimal("rateadjustcycle");
                if (EmptyUtil.isEmpty((BigDecimal)rateAdjustCycle) || EmptyUtil.isEmpty((String)rateAdjustCycleType)) {
                    this.addErrorMessage(dataEntity, bizResource.getRateAdjustCycleNotNull());
                }
            }
        }
    }

    private void validateInvestEntry(ExtendedDataEntity dataEntity, DynamicObject bondPlan) {
        BigDecimal amount = bondPlan.getBigDecimal("syncdrawamount");
        DynamicObjectCollection investEntrys = bondPlan.getDynamicObjectCollection("investor_entry");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)investEntrys)) {
            BigDecimal investTotalAmt = investEntrys.stream().map(o -> o.getBigDecimal("e_investamount")).reduce(BigDecimal::add).get();
            if (investTotalAmt.compareTo(amount) > 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e3b\u8981\u6295\u8d44\u4eba\u7684\u5408\u8ba1\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u53d1\u884c\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BondBillSaveValidator_0", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            HashSet<String> investSet = new HashSet<String>(investEntrys.size());
            for (int i = 0; i < investEntrys.size(); ++i) {
                DynamicObject investEntry = (DynamicObject)investEntrys.get(i);
                String investType = investEntry.getString("e_investortype");
                String prop = CreditorTypeEnum.OTHER.getValue().equals(investType) ? "e_investorname" : "e_investorid";
                String key = investType + investEntry.get(prop);
                if (investSet.contains(key)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7b2c%s\u884c\u6295\u8d44\u4eba\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BondBillSaveValidator_1", (String)"tmc-cfm-business", (Object[])new Object[]{i + 1}));
                    continue;
                }
                investSet.add(key);
            }
        }
    }

    private void validateSyncDrawInfo(ExtendedDataEntity dataEntity) {
        BigDecimal syncTicketAmt;
        BigDecimal syncPublishPrice;
        BigDecimal fixedRepayAmount;
        DynamicObject loanContract = dataEntity.getDataEntity();
        BigDecimal amount = loanContract.getBigDecimal("amount");
        BigDecimal syncDrawAmount = loanContract.getBigDecimal("syncdrawamount");
        if (syncDrawAmount.compareTo(BigDecimal.ZERO) <= 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u540c\u6b65\u53d1\u884c\u7684\u53d1\u884c\u91d1\u989d\u8981\u5927\u4e8e0\u3002", (String)"BondBillPlanValidator_0", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
        if (syncDrawAmount.compareTo(amount) > 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u540c\u6b65\u53d1\u884c\u7684\u53d1\u884c\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u53d1\u884c\u603b\u989d\u3002", (String)"BondBillPlanValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
        if (EmptyUtil.isNoEmpty((BigDecimal)(fixedRepayAmount = loanContract.getBigDecimal("fixedrepayamount"))) && fixedRepayAmount.compareTo(syncDrawAmount) > 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u56fa\u5b9a\u8fd8\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u53d1\u884c\u91d1\u989d\u3002", (String)"BondBillPlanValidator_2", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty((BigDecimal)(syncPublishPrice = loanContract.getBigDecimal("syncpublishprice")))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u53d1\u884c\u4ef7\u683c\u3002", (String)"BondBillPlanValidator_3", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty((BigDecimal)(syncTicketAmt = loanContract.getBigDecimal("syncticketamt")))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7968\u9762\u91d1\u989d\u3002", (String)"BondBillPlanValidator_4", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
        Date syncBizDate = loanContract.getDate("syncbizdate");
        Date syncStartIntDate = loanContract.getDate("startintdate");
        Date expireDate = loanContract.getDate("expiredate");
        if (EmptyUtil.isNoEmpty((Object)expireDate) && EmptyUtil.isNoEmpty((Object)syncBizDate) && syncBizDate.after(expireDate)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53d1\u884c\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5230\u671f\u65e5\u671f\u3002", (String)"BondBillPlanValidator_5", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
        if (EmptyUtil.isNoEmpty((Object)expireDate) && EmptyUtil.isNoEmpty((Object)syncStartIntDate) && syncStartIntDate.after(expireDate)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d77\u606f\u65e5\u4e0d\u80fd\u665a\u4e8e\u5230\u671f\u65e5\u3002", (String)"BondBillPlanValidator_6", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
    }
}

