/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.contractbill;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.AmountProp;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.resource.TmcBizResource;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ContractBondSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("lendernature");
        sic.add("creditorg");
        sic.add("textcreditor");
        sic.add("interesttype");
        sic.add("interestrate");
        sic.add("isclientloan");
        sic.add("clientorg");
        sic.add("repaymentway");
        sic.add("stageplan");
        sic.add("bizdate");
        sic.add("startdate");
        sic.add("enddate");
        sic.add("islimitclause");
        sic.add("limitclauseexplain");
        sic.add("rateadjuststyle");
        sic.add("interesttype");
        sic.add("ratetype");
        sic.add("ratedeadline");
        sic.add("ratesign");
        sic.add("ratefloatpoint");
        sic.add("rateadjuststyle");
        sic.add("rateadjustdate");
        sic.add("rateadjustcycle");
        sic.add("textdebtor");
        sic.add("datasource");
        sic.add("loantype");
        sic.add("loaneracctbank");
        sic.add("accountbank");
        sic.add("productfactory");
        sic.add("iscallint");
        sic.add("banksyndicate_entry");
        sic.add("supplychainfin_entry");
        sic.add("tradefin_entry");
        sic.add("e_tf_relatebillno");
        sic.add("e_sc_coreenterprise");
        sic.add("e_bankrole");
        sic.add("e_bank");
        sic.add("e_shareamount");
        sic.add("finproduct");
        sic.add("term");
        sic.add("billstatus");
        return sic;
    }

    protected String getOpVatidateName() {
        return "save";
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.checkAmountMaxValue(dataEntity);
            this.validateDate(dataEntity);
            DynamicObject contractBill = dataEntity.getDataEntity();
            BigDecimal contractAmt = contractBill.getBigDecimal("amount");
            if (contractAmt != null && contractAmt.compareTo(BigDecimal.ZERO) < 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53d1\u884c\u603b\u989d\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"ContractBondSaveValidator_01", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            this.validateUnderwriter(dataEntity, contractBill);
        }
    }

    private void validateDate(ExtendedDataEntity dataEntity) {
        String term;
        int diffDays;
        DynamicObject contractBill = dataEntity.getDataEntity();
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource(contractBill.getString("datasource"));
        DynamicObject finProduct = contractBill.getDynamicObject("finproduct");
        boolean isPerpetual = LoanBillHelper.isLoanBillBondAndPerpetual((DynamicObject)finProduct);
        if (isPerpetual || "save".equals(this.getOpVatidateName())) {
            return;
        }
        Date startDate = contractBill.getDate("startdate");
        Date endDate = contractBill.getDate("enddate");
        if (startDate != null && endDate != null && (diffDays = DateUtils.getDiffDays((Date)startDate, (Date)endDate)) <= 1) {
            this.addErrorMessage(dataEntity, bizResource.getCbEnddateMin());
        }
        if (EmptyUtil.isEmpty((String)(term = contractBill.getString("term")))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u671f\u9650\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ContractBondSaveValidator_08", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty((Object)endDate)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ContractBondSaveValidator_09", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
    }

    private void validateUnderwriter(ExtendedDataEntity dataEntity, DynamicObject contractBill) {
        DynamicObjectCollection underwriterEntrys = contractBill.getDynamicObjectCollection("underwriter_entry");
        if (underwriterEntrys.size() > 0) {
            long isbookrunnerCount = underwriterEntrys.stream().filter(v -> v.getBoolean("e_isbookrunner")).count();
            if (isbookrunnerCount > 1L) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7c3f\u8bb0\u7ba1\u7406\u4eba\u53ea\u80fd\u6709\u4e00\u4e2a\u3002", (String)"ContractBondSaveValidator_02", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            BigDecimal contractAmount = contractBill.getBigDecimal("amount");
            BigDecimal uwAmtSum = BigDecimal.ZERO;
            BigDecimal uwRatioSum = BigDecimal.ZERO;
            for (DynamicObject underwriterEntry : underwriterEntrys) {
                DynamicObject underwriter = underwriterEntry.getDynamicObject("e_underwriter");
                if (EmptyUtil.isEmpty((DynamicObject)underwriter)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u627f\u9500\u5546\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ContractBondSaveValidator_03", (String)"tmc-cfm-business", (Object[])new Object[0]));
                }
                BigDecimal uwRatio = underwriterEntry.getBigDecimal("e_underwriteratio");
                BigDecimal uwAmount = underwriterEntry.getBigDecimal("e_underwriteamount");
                if (BigDecimal.ZERO.compareTo(uwAmount) > 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u627f\u9500\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"ContractBondSaveValidator_04", (String)"tmc-cfm-business", (Object[])new Object[0]));
                }
                if (BigDecimal.ZERO.compareTo(uwRatio) > 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u627f\u9500\u6bd4\u4f8b\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"ContractBondSaveValidator_05", (String)"tmc-cfm-business", (Object[])new Object[0]));
                }
                uwAmtSum = uwAmtSum.add(uwAmount);
                uwRatioSum = uwRatioSum.add(uwRatio);
            }
            if (BigDecimal.valueOf(100L).compareTo(uwRatioSum) < 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u627f\u9500\u603b\u6bd4\u4f8b\u4e0d\u80fd\u5927\u4e8e100%\u3002", (String)"ContractBondSaveValidator_06", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            if (contractAmount.compareTo(uwAmtSum) < 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u627f\u9500\u603b\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5408\u540c\u91d1\u989d\u3002", (String)"ContractBondSaveValidator_07", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
        }
    }

    private void checkAmountMaxValue(ExtendedDataEntity data) {
        DynamicObject bill = data.getDataEntity();
        for (IDataEntityProperty prop : bill.getDataEntityType().getProperties()) {
            if (!(prop instanceof AmountProp) || bill.getBigDecimal(prop.getName()).compareTo(Constants.MAX_AMOUNT) <= 0) continue;
            this.addErrorMessage(data, new TmcBizResource().checkAmountMaxValue(prop.getDisplayName().getLocaleValue()));
        }
    }
}

