/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.contractbill;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import org.apache.commons.lang3.StringUtils;

public class ContractBondUnauditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        super.getSelector();
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("billstatus");
        sic.add("contractstatus");
        sic.add("datasource");
        return sic;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.validate(dataEntity);
        }
    }

    private void validate(ExtendedDataEntity dataEntity) {
        String checkTargetBillsMsg;
        DynamicObject contractBill = dataEntity.getDataEntity();
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource(contractBill.getString("datasource"));
        String contractStatus = contractBill.getString("contractstatus");
        if (!StringUtils.equals((CharSequence)LoanContractStatusEnum.REGISTERED.getValue(), (CharSequence)contractStatus)) {
            this.addErrorMessage(dataEntity, bizResource.getCbUnauditContractStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)(checkTargetBillsMsg = BusinessHelper.checkTargetBills((String)contractBill.getDataEntityType().getName(), (Long)contractBill.getLong("id"))))) {
            this.addErrorMessage(dataEntity, checkTargetBillsMsg);
        }
    }
}

