/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.drawapply;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DrawApplyBillSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("loancontractbill");
        sic.add("predrawdate");
        sic.add("predrawamount");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Date contractStartDate;
            Date preDrawDate;
            BigDecimal notDrawAmount;
            DynamicObject drawApplyBill = dataEntity.getDataEntity();
            DynamicObject contractBill = drawApplyBill.getDynamicObject("loancontractbill");
            if (EmptyUtil.isEmpty((DynamicObject)contractBill)) continue;
            BigDecimal preDrawAmount = drawApplyBill.getBigDecimal("predrawamount");
            if (preDrawAmount.compareTo(notDrawAmount = contractBill.getBigDecimal("notdrawamount")) > 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u8bf7\u63d0\u6b3e\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u5269\u4f59\u672a\u63d0\u6b3e\u91d1\u989d\u3002", (String)"DrawApplyBillSubmitValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((Object)(preDrawDate = drawApplyBill.getDate("predrawdate")))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9884\u8ba1\u63d0\u6b3e\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DrawApplyBillSubmitValidator_4", (String)"tmc-cfm-business", (Object[])new Object[0]));
                continue;
            }
            Date contractEndDate = contractBill.getDate("enddate");
            Date renewalExpiredate = contractBill.getDate("renewalexpiredate");
            if (EmptyUtil.isNoEmpty((Object)renewalExpiredate)) {
                contractEndDate = renewalExpiredate;
            }
            if (EmptyUtil.isNoEmpty((Object)contractEndDate) && preDrawDate.after(contractEndDate)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9884\u8ba1\u63d0\u6b3e\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5408\u540c\u7ed3\u675f\u65e5\u671f\u6216\u5c55\u671f\u540e\u5230\u671f\u65e5\u671f\u3002", (String)"DrawApplyBillSubmitValidator_2", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            if (!EmptyUtil.isNoEmpty((Object)(contractStartDate = contractBill.getDate("startdate"))) || !preDrawDate.before(contractStartDate)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9884\u8ba1\u63d0\u6b3e\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5408\u540c\u5f00\u59cb\u65e5\u671f\u3002", (String)"DrawApplyBillSubmitValidator_3", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
    }
}

