/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.extapplybill;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.business.resource.CfmBusinessResourceEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.cfm.common.helper.DefaultProductFactoryHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ExtApplyBillSaveOrSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("ratesign");
        sic.add("ratefloatpoint");
        sic.add("rateadjuststyle");
        sic.add("rateadjustcycle");
        sic.add("datasource");
        sic.add("productfactory");
        sic.add("renewalexpiredate");
        sic.add("referencerate");
        sic.add("rateadjustcycletype");
        sic.add("isadjustinterestrate");
        sic.add("loantype");
        sic.add("e_isrenewal");
        sic.add("e_lrenewalexpiredate");
        sic.add("e_prevrenewalexpiredate");
        sic.add("e_loanbill");
        sic.add("loans");
        sic.add("e_exrateadjustdate");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject extApplyBill = dataEntity.getDataEntity();
            DynamicObject contractF7 = extApplyBill.getDynamicObject("loancontractbill");
            if (EmptyUtil.isEmpty((DynamicObject)contractF7)) {
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.ExtApplyBillSaveOrSubmitValidator_11.loadKDString());
                continue;
            }
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(extApplyBill.getString("datasource"));
            this.validateIsAllowedExt(dataEntity, extApplyBill, contractF7);
            this.validateTerm(dataEntity, extApplyBill, contractF7);
            this.validateInterestRate(dataEntity, extApplyBill, contractF7, bizResource);
            this.validateLoanBill(dataEntity, extApplyBill);
        }
    }

    private void validateIsAllowedExt(ExtendedDataEntity dataEntity, DynamicObject extApplyBill, DynamicObject contractF7) {
        int count;
        Integer renewalLimitObj;
        DynamicObject pf = extApplyBill.getDynamicObject("productfactory");
        if (EmptyUtil.isNoEmpty((DynamicObject)pf) && !pf.getBoolean("iscandefer")) {
            this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.ExtApplyBillSaveOrSubmitValidator_1.loadKDString());
            return;
        }
        long contractId = contractF7.getLong("id");
        QFilter conFilter = new QFilter("sourcebillid", "=", (Object)contractId);
        QFilter extendBillQF = new QFilter("billstatus", "in", (Object)new Object[]{BillStatusEnum.SAVE.getValue(), BillStatusEnum.SUBMIT.getValue()});
        QFilter unconfirmStatus = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        unconfirmStatus.and("confirmstatus", "!=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
        extendBillQF = extendBillQF.or(unconfirmStatus);
        extendBillQF = extendBillQF.and(conFilter);
        QFilter excludeQF = new QFilter("id", "!=", (Object)extApplyBill.getLong("id"));
        extendBillQF = extendBillQF.and(excludeQF);
        int ongoningBillCount = TmcDataServiceHelper.count((String)"cfm_contractextendbill", (QFilter[])extendBillQF.toArray());
        if (ongoningBillCount > 0) {
            this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.ExtApplyBillSaveOrSubmitValidator_2.loadKDString());
            return;
        }
        int renewalLimit = 99;
        if (EmptyUtil.isNoEmpty((DynamicObject)pf) && EmptyUtil.isNoEmpty((Integer)(renewalLimitObj = Integer.valueOf(pf.getInt("defermaxcount"))))) {
            renewalLimit = renewalLimitObj;
        }
        if ((count = TmcDataServiceHelper.count((String)"cfm_contractextendbill", (QFilter[])(conFilter = conFilter.and(excludeQF)).toArray())) >= renewalLimit) {
            this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.ExtApplyBillSaveOrSubmitValidator_3.loadKDString());
        }
    }

    private void validateTerm(ExtendedDataEntity dataEntity, DynamicObject extApplyBill, DynamicObject contractF7) {
        DynamicObject pfDO = DefaultProductFactoryHelper.getProductFactoryOrDefault((DynamicObject)extApplyBill);
        Date renewalExpireDate = extApplyBill.getDate("renewalexpiredate");
        if (renewalExpireDate != null) {
            Date prevRenewalExpireDate;
            int renewalDateDiffDays;
            if (!pfDO.getBoolean("iscanoverterm")) {
                Date contractEndDate = contractF7.getDate("enddate");
                Date contractStartDate = contractF7.getDate("startdate");
                int contractDiffDays = DateUtils.getDiffDays((Date)contractStartDate, (Date)contractEndDate);
                int extendDiffDays = DateUtils.getDiffDays((Date)contractEndDate, (Date)renewalExpireDate);
                if (extendDiffDays > contractDiffDays) {
                    this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.ExtApplyBillSaveOrSubmitValidator_4.loadKDString());
                }
            }
            if ((renewalDateDiffDays = DateUtils.getDiffDays((Date)(prevRenewalExpireDate = extApplyBill.getDate("prevrenewalexpiredate")), (Date)renewalExpireDate) - 1) < 0) {
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.ExtApplyBillSaveOrSubmitValidator_5.loadKDString());
            }
        }
    }

    private void validateInterestRate(ExtendedDataEntity dataEntity, DynamicObject extApplyBill, DynamicObject contractF7, AbstractBizResource bizResource) {
        if (!extApplyBill.getBoolean("isadjustinterestrate")) {
            return;
        }
        if (InterestTypeEnum.FLOAT.getValue().equals(contractF7.getString("interesttype"))) {
            if (EmptyUtil.isEmpty((String)extApplyBill.getString("rateadjuststyle"))) {
                this.addErrorMessage(dataEntity, bizResource.getRateAdjustStyleNotNull());
            }
            if (EmptyUtil.isEmpty((String)extApplyBill.getString("ratesign"))) {
                this.addErrorMessage(dataEntity, bizResource.getRatesignNotNull());
            }
            if (EmptyUtil.isEmpty((DynamicObject)extApplyBill.getDynamicObject("referencerate"))) {
                this.addErrorMessage(dataEntity, bizResource.getReferenceRateNotNull());
            }
            if (RateAdjustStyleEnum.CYCLE.getValue().equals(extApplyBill.getString("rateadjuststyle"))) {
                BigDecimal rateAdjustCycle;
                String rateAdjustCycleType = extApplyBill.getString("rateadjustcycletype");
                if (EmptyUtil.isEmpty((String)rateAdjustCycleType)) {
                    this.addErrorMessage(dataEntity, bizResource.getRateAdjustCycleTypeNotNull());
                }
                if (EmptyUtil.isEmpty((BigDecimal)(rateAdjustCycle = extApplyBill.getBigDecimal("rateadjustcycle"))) || BigDecimal.ZERO.compareTo(rateAdjustCycle) >= 0) {
                    this.addErrorMessage(dataEntity, bizResource.getRateAdjustCycleNotNull());
                }
            }
        }
    }

    protected void validateLoanBill(ExtendedDataEntity dataEntity, DynamicObject extApplyBill) {
        DynamicObjectCollection entrys = extApplyBill.getDynamicObjectCollection("loans");
        Date headRenewalExpireDate = extApplyBill.getDate("renewalexpiredate");
        for (DynamicObject entry : entrys) {
            if (!entry.getBoolean("e_isrenewal")) continue;
            Date renewalExpireDate = entry.getDate("e_lrenewalexpiredate");
            Date prevRenewalExpireDate = entry.getDate("e_prevrenewalexpiredate");
            Date rateAdjustDate = entry.getDate("e_exrateadjustdate");
            DynamicObject loanBillF7 = entry.getDynamicObject("e_loanbill");
            String loanBillNo = loanBillF7.getString("number");
            if (renewalExpireDate != null) {
                Date expiredate;
                Date loandate;
                int loanDiffDate;
                DynamicObject pfDO;
                int diffDays = DateUtils.getDiffDays((Date)prevRenewalExpireDate, (Date)renewalExpireDate);
                if (diffDays <= 0) {
                    this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.ExtApplyBillSaveOrSubmitValidator_6.loadKDString(loanBillNo));
                }
                if (renewalExpireDate.compareTo(headRenewalExpireDate) > 0) {
                    this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.ExtApplyBillSaveOrSubmitValidator_10.loadKDString(loanBillNo));
                }
                if (!(pfDO = DefaultProductFactoryHelper.getProductFactoryOrDefault((DynamicObject)extApplyBill)).getBoolean("iscandefer") && diffDays > (loanDiffDate = DateUtils.getDiffDays((Date)(loandate = loanBillF7.getDate("bizdate")), (Date)(expiredate = loanBillF7.getDate("expiredate"))))) {
                    this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.ExtApplyBillSaveOrSubmitValidator_7.loadKDString(loanBillNo));
                }
                if (!extApplyBill.getBoolean("isadjustinterestrate") || !EmptyUtil.isNoEmpty((Object)rateAdjustDate) || rateAdjustDate.compareTo(prevRenewalExpireDate) >= 0 && rateAdjustDate.compareTo(renewalExpireDate) <= 0) continue;
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.ExtApplyBillSaveOrSubmitValidator_9.loadKDString(loanBillNo));
                continue;
            }
            this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.ExtApplyBillSaveOrSubmitValidator_8.loadKDString(loanBillNo));
        }
    }
}

