/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.extendbill;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.business.helper.LoanBillApplyHelper;
import kd.tmc.cfm.business.resource.CfmBusinessResourceEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.cfm.common.helper.DefaultProductFactoryHelper;
import kd.tmc.cfm.common.helper.ExtendHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class ExtendBillSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("ratetype");
        sic.add("ratedeadline");
        sic.add("ratesign");
        sic.add("ratefloatpoint");
        sic.add("renewalinteresttype");
        sic.add("rateadjuststyle");
        sic.add("rateadjustcycle");
        sic.add("loanbilllist");
        sic.add("datasource");
        sic.add("loanbilllist.drawbillno");
        sic.add("loanbilllist.lrenewalexpiredate");
        sic.add("loanbilllist.isrenewal");
        sic.add("loanbilllist.expiredate");
        sic.add("loanbilllist.exrateadjustdate");
        sic.add("loanbilllist.e_prevrenewalexpiredate");
        sic.add("loanbilllist.interesttype");
        sic.add("loanbilllist.lreferencerate");
        sic.add("loanbilllist.loanrate");
        sic.add("loanbilllist.lisadjustinterestrate");
        sic.add("productfactory");
        sic.add("renewalexpiredate");
        sic.add("enddate");
        sic.add("prevrenewalexpiredate");
        sic.add("startdate");
        sic.add("referencerate");
        sic.add("rateadjustcycletype");
        sic.add("isadjustinterestrate");
        sic.add("loantype");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        if ("true".equals(this.getOption().getVariableValue("byInit", "false"))) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject extendBill = dataEntity.getDataEntity();
            Pair result = ExtendHelper.isExtendAllowed((DynamicObject)extendBill, (String)"extend");
            if (!((Boolean)result.getLeft()).booleanValue()) {
                this.addErrorMessage(dataEntity, (String)result.getRight());
                continue;
            }
            this.validateTerm(dataEntity, extendBill);
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(extendBill.getString("datasource"));
            this.validateInterestRate(dataEntity, extendBill, bizResource);
            this.validateLoanBill(dataEntity, extendBill, bizResource);
            this.validateOnWayApply(dataEntity, extendBill);
        }
    }

    private void validateTerm(ExtendedDataEntity dataEntity, DynamicObject extendBill) {
        DynamicObject pfDO = DefaultProductFactoryHelper.getProductFactoryOrDefault((DynamicObject)extendBill);
        Date renewalExpireDate = extendBill.getDate("renewalexpiredate");
        if (renewalExpireDate != null) {
            Date prevRenewalExpireDate;
            int renewalDateDiffDays;
            if (!pfDO.getBoolean("iscanoverterm")) {
                Date contractEndDate = extendBill.getDate("enddate");
                Date contractStartDate = extendBill.getDate("startdate");
                int contractDiffDays = DateUtils.getDiffDays((Date)contractStartDate, (Date)contractEndDate);
                int extendDiffDays = DateUtils.getDiffDays((Date)contractEndDate, (Date)renewalExpireDate);
                if (extendDiffDays > contractDiffDays) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5408\u540c\u6240\u9009\u878d\u8d44\u6a21\u578b\u4e0d\u5141\u8bb8\u5c55\u671f\u671f\u9650\u8d85\u8fc7\u501f\u6b3e\u671f\u9650\uff0c\u8bf7\u4fee\u6539\u5c55\u671f\u540e\u5230\u671f\u65e5\u671f\u3002", (String)"ExtendBillSaveValidator_01", (String)"tmc-cfm-business", (Object[])new Object[0]));
                }
            }
            if ((renewalDateDiffDays = DateUtils.getDiffDays((Date)(prevRenewalExpireDate = extendBill.getDate("prevrenewalexpiredate")), (Date)renewalExpireDate) - 1) < 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5c55\u671f\u540e\u5230\u671f\u65e5\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5c55\u671f\u524d\u5230\u671f\u65e5\u3002", (String)"ExtendBillSaveValidator_02", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
        }
    }

    private void validateInterestRate(ExtendedDataEntity dataEntity, DynamicObject extendBill, AbstractBizResource bizResource) {
        if (!extendBill.getBoolean("isadjustinterestrate")) {
            return;
        }
        if (InterestTypeEnum.FLOAT.getValue().equals(extendBill.getString("renewalinteresttype"))) {
            if (!"submit".equals(this.opName())) {
                return;
            }
            if (EmptyUtil.isEmpty((String)extendBill.getString("rateadjuststyle"))) {
                this.addErrorMessage(dataEntity, bizResource.getRateAdjustStyleNotNull());
            }
            if (EmptyUtil.isEmpty((String)extendBill.getString("ratesign"))) {
                this.addErrorMessage(dataEntity, bizResource.getRatesignNotNull());
            }
            if (EmptyUtil.isEmpty((DynamicObject)extendBill.getDynamicObject("referencerate"))) {
                this.addErrorMessage(dataEntity, bizResource.getReferenceRateNotNull());
            }
            if (RateAdjustStyleEnum.CYCLE.getValue().equals(extendBill.getString("rateadjuststyle"))) {
                BigDecimal rateAdjustCycle;
                String rateAdjustCycleType = extendBill.getString("rateadjustcycletype");
                if (EmptyUtil.isEmpty((String)rateAdjustCycleType)) {
                    this.addErrorMessage(dataEntity, bizResource.getRateAdjustCycleTypeNotNull());
                }
                if (EmptyUtil.isEmpty((BigDecimal)(rateAdjustCycle = extendBill.getBigDecimal("rateadjustcycle"))) || BigDecimal.ZERO.compareTo(rateAdjustCycle) >= 0) {
                    this.addErrorMessage(dataEntity, bizResource.getRateAdjustCycleNotNull());
                }
            }
        }
    }

    protected void validateLoanBill(ExtendedDataEntity dataEntity, DynamicObject extendBill, AbstractBizResource bizResource) {
        DynamicObjectCollection entrys = extendBill.getDynamicObjectCollection("loanbilllist");
        for (DynamicObject entry : entrys) {
            String loanBillNo = entry.getString("drawbillno");
            if (LoanTypeEnum.isBond((String)extendBill.getString("datasource"))) {
                if (InterestTypeEnum.isFloat((String)entry.getString("interesttype"))) {
                    if (EmptyUtil.isEmpty((String)entry.getString("lreferencerate"))) {
                        this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.ExtendBillSaveValidator_08.loadKDString());
                    }
                } else if (new BigDecimal(0).compareTo(entry.getBigDecimal("loanrate")) == 0 && entry.getBoolean("lisadjustinterestrate")) {
                    this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.ExtendBillSaveValidator_07.loadKDString(loanBillNo));
                }
            }
            if (!entry.getBoolean("isrenewal")) continue;
            Date renewalExpireDate = entry.getDate("lrenewalexpiredate");
            Date prevRenewalExpireDate = entry.getDate("e_prevrenewalexpiredate");
            this.checkRateAdjustDate(dataEntity, entry);
            if (renewalExpireDate != null) {
                Date expiredate;
                Date loandate;
                int loanDiffDate;
                DynamicObject pfDO;
                int diffDays = DateUtils.getDiffDays((Date)prevRenewalExpireDate, (Date)renewalExpireDate);
                if (diffDays <= 0) {
                    this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.ExtendBillSaveValidator_03.loadKDString(loanBillNo));
                }
                if ((pfDO = DefaultProductFactoryHelper.getProductFactoryOrDefault((DynamicObject)extendBill)).getBoolean("iscanoverterm") || diffDays <= (loanDiffDate = DateUtils.getDiffDays((Date)(loandate = entry.getDate("loandate")), (Date)(expiredate = entry.getDate("expiredate"))))) continue;
                this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.ExtendBillSaveValidator_04.loadKDString(loanBillNo));
                continue;
            }
            this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.ExtendBillSaveValidator_05.loadKDString(loanBillNo));
        }
    }

    private void checkRateAdjustDate(ExtendedDataEntity dataEntity, DynamicObject entry) {
        Date rateAdjustDate = entry.getDate("exrateadjustdate");
        if (EmptyUtil.isEmpty((Object)rateAdjustDate)) {
            return;
        }
        Date renewalExpireDate = entry.getDate("lrenewalexpiredate");
        Date prevRenewalExpireDate = entry.getDate("e_prevrenewalexpiredate");
        if (rateAdjustDate.compareTo(prevRenewalExpireDate) < 0) {
            this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.ExtendBillSaveValidator_09.loadKDString(entry.getString("drawbillno")));
        }
        if (EmptyUtil.isNoEmpty((Object)renewalExpireDate) && rateAdjustDate.compareTo(renewalExpireDate) > 0) {
            this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.ExtendBillSaveValidator_10.loadKDString(entry.getString("drawbillno")));
        }
    }

    protected void validateOnWayApply(ExtendedDataEntity dataEntity, DynamicObject extendBill) {
        DynamicObjectCollection entrys = extendBill.getDynamicObjectCollection("loanbilllist");
        Set<String> loanIds = entrys.stream().map(o -> o.getString("drawbillno")).collect(Collectors.toSet());
        DynamicObjectCollection onWayApplys = LoanBillApplyHelper.queryOnWayApply(loanIds);
        if (onWayApplys.size() > 0) {
            this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.ExtendBillSaveValidator_11.loadKDString(((DynamicObject)onWayApplys.get(0)).getString("billno")));
        }
    }

    protected String opName() {
        return "save";
    }
}

