/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.extendbill;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.business.resource.CfmBusinessResourceEnum;
import kd.tmc.cfm.business.validate.extendbill.ExtendBillSaveValidator;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.helper.RateAdjustHelper;
import kd.tmc.cfm.common.repository.IntBillBatchPreRepository;
import kd.tmc.cfm.common.repository.InterestBillRepository;
import kd.tmc.cfm.common.repository.RepaymentBillRepository;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ExtendBillSubmitValidator
extends ExtendBillSaveValidator {
    private static final String[] tempProperties = new String[]{"id", "billstatus", "drawtype", "billno", "datasource"};

    @Override
    public List<String> getSelector() {
        List<String> sic = super.getSelector();
        sic.add("sourcebillid");
        sic.add("ratetype");
        sic.add("ratedeadline");
        sic.add("ratesign");
        sic.add("ratefloatpoint");
        sic.add("rateadjuststyle");
        sic.add("rateadjustcycle");
        sic.add("datasource");
        sic.add("loanbilllist");
        sic.add("loanbilllist.drawbillid");
        sic.add("loanbilllist.drawbillno");
        sic.add("loanbilllist.lrenewalexpiredate");
        sic.add("loanbilllist.isrenewal");
        sic.add("loanbilllist.expiredate");
        sic.add("loanbilllist.exrateadjustdate");
        sic.add("loanbilllist.e_prevrenewalexpiredate");
        sic.add("loanbilllist.lisadjustinterestrate");
        sic.add("productfactory");
        sic.add("renewalexpiredate");
        sic.add("enddate");
        sic.add("prevrenewalexpiredate");
        sic.add("startdate");
        sic.add("referencerate");
        sic.add("rateadjustcycletype");
        sic.add("isadjustinterestrate");
        sic.add("loantype");
        sic.add("sourcebillid");
        sic.add("isinit");
        return sic;
    }

    @Override
    protected void validateLoanBill(ExtendedDataEntity dataEntity, DynamicObject extendBill, AbstractBizResource bizResource) {
        super.validateLoanBill(dataEntity, extendBill, bizResource);
        DynamicObjectCollection entrys = extendBill.getDynamicObjectCollection("loanbilllist");
        HashMap<Long, DynamicObject> entryMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject entry : entrys) {
            entryMap.put(entry.getLong("drawbillid"), entry);
        }
        Long contractId = extendBill.getLong("sourcebillid");
        QFilter contractFilter = new QFilter("sourcebillid", "=", (Object)contractId);
        CharSequence[] selectProperties = tempProperties;
        DynamicObjectCollection loanBills = QueryServiceHelper.query((String)"cfm_loanbill", (String)String.join((CharSequence)",", selectProperties), (QFilter[])new QFilter[]{contractFilter});
        for (DynamicObject loanBill : loanBills) {
            DynamicObject entry = (DynamicObject)entryMap.get(loanBill.get("id"));
            if (EmptyUtil.isEmpty((DynamicObject)entry)) {
                if (!StringUtils.equals((CharSequence)BillStatusEnum.SUBMIT.getValue(), (CharSequence)loanBill.getString("billstatus"))) continue;
                this.addWarningMessage(dataEntity, String.format(bizResource.getEbConfirmSumbit(), loanBill.getString("billno")));
                continue;
            }
            if (!entry.getBoolean("isrenewal")) continue;
            if (!StringUtils.equals((CharSequence)BillStatusEnum.AUDIT.getValue(), (CharSequence)loanBill.getString("billstatus"))) {
                this.addErrorMessage(dataEntity, String.format(bizResource.getEbEntryExisunaudit(), loanBill.getString("billno")));
            }
            if (!StringUtils.equals((CharSequence)DrawTypeEnum.CLOSEOUT.getValue(), (CharSequence)loanBill.getString("drawtype"))) continue;
            this.addErrorMessage(dataEntity, String.format(bizResource.getEbEntryExisclosed(), loanBill.getString("billno")));
        }
    }

    @Override
    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        super.validate(dataEntities);
        for (ExtendedDataEntity entity : dataEntities) {
            DynamicObject extendBill = entity.getDataEntity();
            if (extendBill.getBoolean("isinit") || !RateAdjustHelper.isAdjustRate((DynamicObject)extendBill)) continue;
            DynamicObjectCollection entrys = extendBill.getDynamicObjectCollection("loanbilllist");
            this.checkOnWayAdjust(entity, extendBill);
            this.checkOnWayPayInt(entity, entrys);
            this.checkOnWayRepayment(entity, entrys);
            this.checkPayIntByBizDate(entity, entrys);
            this.checkRepaymentByBizDate(entity, entrys);
        }
    }

    private void checkOnWayAdjust(ExtendedDataEntity entity, DynamicObject extendBill) {
        Long contractId = extendBill.getLong("sourcebillid");
        QFilter qFilter = new QFilter("loancontractbill", "=", (Object)contractId).and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        boolean isExistsOnWay = QueryServiceHelper.exists((String)"cfm_rateadjustbill", (QFilter[])qFilter.toArray());
        if (isExistsOnWay) {
            this.addErrorMessage(entity, CfmBusinessResourceEnum.ExtendBillSubmitValidator_1.loadKDString());
        }
    }

    private void checkOnWayPayInt(ExtendedDataEntity entity, DynamicObjectCollection entrys) {
        DynamicObjectCollection batchIntBills;
        List loanBillNos = entrys.stream().map(o -> o.getString("drawbillno")).collect(Collectors.toList());
        DynamicObjectCollection interestBills = InterestBillRepository.getOnWayInterestBills(loanBillNos);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)interestBills)) {
            this.addErrorMessage(entity, CfmBusinessResourceEnum.ExtendBillSubmitValidator_2.loadKDString(((DynamicObject)interestBills.get(0)).getString("loanbillno")));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(batchIntBills = IntBillBatchPreRepository.getOnWayBatchInterestBills(loanBillNos)))) {
            this.addErrorMessage(entity, CfmBusinessResourceEnum.ExtendBillSubmitValidator_2.loadKDString(((DynamicObject)batchIntBills.get(0)).getString("entry.loanbillno")));
        }
    }

    private void checkOnWayRepayment(ExtendedDataEntity entity, DynamicObjectCollection entrys) {
        List loanBillIds = entrys.stream().map(o -> o.getLong("drawbillid")).collect(Collectors.toList());
        DynamicObjectCollection repaymentBills = RepaymentBillRepository.getOnWayRepaymentBillByLoanIds(loanBillIds);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)repaymentBills)) {
            this.addErrorMessage(entity, CfmBusinessResourceEnum.ExtendBillSubmitValidator_3.loadKDString(((DynamicObject)repaymentBills.get(0)).getString("loans.e_loanbill.number")));
        }
    }

    private void checkPayIntByBizDate(ExtendedDataEntity entity, DynamicObjectCollection entrys) {
        List loanBillNos = entrys.stream().map(o -> o.getString("drawbillno")).collect(Collectors.toList());
        Map<String, Date> loanBill_DateMap = entrys.stream().collect(Collectors.toMap(o -> o.getString("drawbillno"), o -> o.getDate("e_prevrenewalexpiredate")));
        DynamicObjectCollection interestBills = InterestBillRepository.getInterestBillsByLoanBillNos(loanBillNos);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)interestBills)) {
            for (DynamicObject interestBill : interestBills) {
                Date bizDate = interestBill.getDate("bizdate");
                String loanBillNo = interestBill.getString("loanbillno");
                Date expireDate = loanBill_DateMap.get(loanBillNo);
                if (!EmptyUtil.isNoEmpty((Object)expireDate) || bizDate.compareTo(expireDate) <= 0) continue;
                this.addErrorMessage(entity, CfmBusinessResourceEnum.ExtendBillSubmitValidator_4.loadKDString(loanBillNo));
            }
        }
    }

    private void checkRepaymentByBizDate(ExtendedDataEntity entity, DynamicObjectCollection entrys) {
        List loanBillIds = entrys.stream().map(o -> o.getLong("drawbillid")).collect(Collectors.toList());
        Map<Long, Date> loanBill_DateMap = entrys.stream().collect(Collectors.toMap(o -> o.getLong("drawbillid"), o -> o.getDate("e_prevrenewalexpiredate")));
        Map<Long, String> loanBillMap = entrys.stream().collect(Collectors.toMap(o -> o.getLong("drawbillid"), o -> o.getString("drawbillno")));
        DynamicObjectCollection repaymentBills = RepaymentBillRepository.queryRepaymentByLoanBillIds(loanBillIds, null);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)repaymentBills)) {
            for (DynamicObject repaymentBill : repaymentBills) {
                Date bizDate = repaymentBill.getDate("bizdate");
                Long loanBillId = repaymentBill.getLong("loans.e_loanbill");
                Date expireDate = loanBill_DateMap.get(loanBillId);
                if (!EmptyUtil.isNoEmpty((Object)expireDate) || bizDate.compareTo(expireDate) <= 0) continue;
                this.addErrorMessage(entity, CfmBusinessResourceEnum.ExtendBillSubmitValidator_5.loadKDString(loanBillMap.get(loanBillId)));
            }
        }
    }

    @Override
    protected String opName() {
        return "submit";
    }
}

