/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.extendbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.tmc.cfm.business.resource.CfmBusinessResourceEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.ExtendHelper;
import kd.tmc.cfm.common.repository.IntBillBatchPreRepository;
import kd.tmc.cfm.common.repository.InterestBillRepository;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.collections.CollectionUtils;

public class ExtendBillUnAuditValidator
extends AbstractTmcBizOppValidator {
    private static String[] staticProperties = new String[]{"expiredate", "billno", "repaymentway", "repayplan_entry", "repayplan_entry.exrepaymentdate"};

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("isinit");
        sic.add("lendernature");
        sic.add("datasource");
        sic.add("confirmstatus");
        sic.add("sourcebillid");
        sic.add("productfactory");
        sic.add("createtime");
        sic.add("renewalexpiredate");
        sic.add("enddate");
        sic.add("prevrenewalexpiredate");
        sic.add("startdate");
        sic.add("referencerate");
        sic.add("rateadjustcycletype");
        sic.add("loantype");
        sic.add("loancontractbill");
        sic.add("isadjustinterestrate");
        sic.add("debtortype");
        sic.add("creditortype");
        sic.add("loanbilllist");
        sic.add("loanbilllist.drawbillid");
        sic.add("loanbilllist.drawbillno");
        sic.add("loanbilllist.isrenewal");
        sic.add("loanbilllist.e_prevrenewalexpiredate");
        sic.add("loanbilllist.lisadjustinterestrate");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject extendBill = dataEntity.getDataEntity();
            this.checkExistsLoanBill(dataEntity, extendBill);
            String creditorType = extendBill.getString("creditortype");
            String dataSource = extendBill.getString("datasource");
            if (!ExtendHelper.isTheLatestExtendBill((DynamicObject)extendBill)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u591a\u6b21\u5c55\u671f\u65f6\u53ea\u80fd\u4ece\u6700\u540e\u4e00\u6b21\u5c55\u671f\u5f00\u59cb\u64cd\u4f5c\u3002", (String)"ExtendBillUnAuditValidator_01", (String)"tmc-cfm-business", (Object[])new Object[0]));
                continue;
            }
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(dataSource);
            if (extendBill.getBoolean("isinit")) {
                this.addErrorMessage(dataEntity, bizResource.getEbUnauditContractinit());
                continue;
            }
            DynamicObject contractBillF7 = extendBill.getDynamicObject("loancontractbill");
            if (EmptyUtil.isNoEmpty((DynamicObject)contractBillF7) && LoanContractStatusEnum.CLOSED.getValue().equals(contractBillF7.getString("contractstatus")) && contractBillF7.getBoolean("ishandend")) {
                String contractNum = contractBillF7.getString("number");
                this.addErrorMessage(dataEntity, String.format(bizResource.getIbUnOpContractByHandEnd(), contractNum));
                continue;
            }
            if (CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType)) {
                Map botpMap = BFTrackerServiceHelper.findTargetBills((String)extendBill.getDataEntityType().getName(), (Long[])new Long[]{extendBill.getLong("id")});
                if (botpMap != null && botpMap.size() > 0) {
                    this.addErrorMessage(dataEntity, bizResource.getIfmExtendBillExitDownBill());
                }
                if ("ifm".equals(dataSource) && "cfm_contractextendbill".equals(extendBill.getDynamicObjectType().getName())) {
                    this.addErrorMessage(dataEntity, bizResource.getExtendBillGenTypeMsg());
                } else if ("cfm".equals(dataSource) && "ifm_contractextendbill".equals(extendBill.getDynamicObjectType().getName())) {
                    this.addErrorMessage(dataEntity, bizResource.getIfmExtendBillGenTypeMsg());
                }
            }
            if (BusinessHelper.isOutGroup((DynamicObject)extendBill)) {
                DynamicObject[] loanBills;
                DynamicObjectCollection entrys = extendBill.getDynamicObjectCollection("loanbilllist");
                ArrayList<Long> pkList = new ArrayList<Long>(entrys.size());
                HashMap<Long, DynamicObject> pkLoanMap = new HashMap<Long, DynamicObject>(entrys.size());
                for (DynamicObject entry : entrys) {
                    if (!entry.getBoolean("isrenewal")) continue;
                    pkList.add(entry.getLong("drawbillid"));
                    pkLoanMap.put(entry.getLong("drawbillid"), entry);
                }
                if (CollectionUtils.isEmpty(pkList)) continue;
                QFilter pkFilter = new QFilter("id", "in", pkList);
                CharSequence[] selectProperties = staticProperties;
                for (DynamicObject loanBill : loanBills = TmcDataServiceHelper.load((String)"cfm_loanbill", (String)String.join((CharSequence)",", selectProperties), (QFilter[])new QFilter[]{pkFilter})) {
                    DynamicObjectCollection repayPlans;
                    DynamicObject entry = (DynamicObject)pkLoanMap.get(loanBill.getLong("id"));
                    Date prevExpireDate = entry.getDate("e_prevrenewalexpiredate");
                    Date expiredate = prevExpireDate == null ? loanBill.getDate("expiredate") : prevExpireDate;
                    String repaymentWay = loanBill.getString("repaymentway");
                    List<String> dqhbTypeList = Arrays.asList(RepaymentWayEnum.bqhblsbq.getValue(), RepaymentWayEnum.bqhbdqhx.getValue());
                    if (dqhbTypeList.contains(repaymentWay) || EmptyUtil.isEmpty((DynamicObjectCollection)(repayPlans = loanBill.getDynamicObjectCollection("repayplan_entry")))) continue;
                    for (DynamicObject repayPlan : repayPlans) {
                        Date exrepaymentdate = repayPlan.getDate("exrepaymentdate");
                        if (exrepaymentdate.compareTo(expiredate) <= 0) continue;
                        this.addErrorMessage(dataEntity, String.format(bizResource.getEbUnauditRepayPlandate(), loanBill.getString("billno")));
                    }
                }
            } else {
                String confirmStatus = extendBill.getString("confirmstatus");
                String entityName = extendBill.getDynamicObjectType().getName();
                if (!(ConfirmStatusEnum.isWaitconfirm((String)confirmStatus) || ConfirmStatusEnum.isYetreturn((String)confirmStatus) || StringUtils.equals((CharSequence)entityName, (CharSequence)"ifm_contractextendbill"))) {
                    this.addErrorMessage(dataEntity, bizResource.getUnauditConfirmStatus());
                }
            }
            this.checkExistsRateAdjustBill(dataEntity, extendBill);
            this.checkPayIntByBizDate(dataEntity, extendBill.getDynamicObjectCollection("loanbilllist"));
            this.checkPreIntByBizDate(dataEntity, extendBill.getDynamicObjectCollection("loanbilllist"));
        }
    }

    private void checkExistsLoanBill(ExtendedDataEntity dataEntity, DynamicObject extendBill) {
        Date renewalExpireDate = extendBill.getDate("prevrenewalexpiredate");
        DynamicObject loanContractBill = extendBill.getDynamicObject("loancontractbill");
        QFilter qFilter = new QFilter("loancontractbill", "=", loanContractBill.getPkValue());
        qFilter.and(new QFilter("bizdate", ">", (Object)renewalExpireDate));
        if (TmcDataServiceHelper.exists((String)"cfm_loanbill", (QFilter[])qFilter.toArray())) {
            this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.ExtendBillUnAuditValidator_05.loadKDString(CfmBillCommonHelper.getLoanNameByDataSource((String)extendBill.getString("datasource"))));
        }
    }

    private void checkExistsRateAdjustBill(ExtendedDataEntity dataEntity, DynamicObject extendBill) {
        Date renewalExpireDate = extendBill.getDate("prevrenewalexpiredate");
        DynamicObject loanContractBill = extendBill.getDynamicObject("loancontractbill");
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and(new QFilter("loancontractbill", "=", loanContractBill.getPkValue()));
        qFilter.and(new QFilter("adjusteffectdate", ">=", (Object)renewalExpireDate));
        if (TmcDataServiceHelper.exists((String)"cfm_rateadjustbill", (QFilter[])qFilter.toArray())) {
            this.addErrorMessage(dataEntity, CfmBusinessResourceEnum.ExtendBillUnAuditValidator_02.loadKDString());
        }
    }

    private void checkPayIntByBizDate(ExtendedDataEntity entity, DynamicObjectCollection entrys) {
        List loanBillNos = entrys.stream().map(o -> o.getString("drawbillno")).collect(Collectors.toList());
        Map<String, Date> loanBill_DateMap = entrys.stream().collect(Collectors.toMap(o -> o.getString("drawbillno"), o -> o.getDate("e_prevrenewalexpiredate")));
        DynamicObjectCollection interestBills = InterestBillRepository.getOnWayInterestBills(loanBillNos);
        this.checkDate(entity, interestBills, loanBill_DateMap);
        DynamicObjectCollection batchIntBills = IntBillBatchPreRepository.getOnWayBatchInterestBills(loanBillNos);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)batchIntBills)) {
            for (DynamicObject batchIntBill : batchIntBills) {
                Date bizDate = batchIntBill.getDate("bizdate");
                String loanBillNo = batchIntBill.getString("entry.loanbillno");
                Date expireDate = loanBill_DateMap.get(loanBillNo);
                if (!EmptyUtil.isNoEmpty((Object)expireDate) || bizDate.compareTo(expireDate) <= 0) continue;
                this.addErrorMessage(entity, CfmBusinessResourceEnum.ExtendBillUnAuditValidator_03.loadKDString(loanBillNo));
                return;
            }
        }
        interestBills = InterestBillRepository.getInterestBillsByLoanBillNos(loanBillNos);
        this.checkDate(entity, interestBills, loanBill_DateMap);
    }

    private void checkDate(ExtendedDataEntity entity, DynamicObjectCollection interestBills, Map<String, Date> loanBill_DateMap) {
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)interestBills)) {
            for (DynamicObject interestBill : interestBills) {
                Date bizDate = interestBill.getDate("bizdate");
                String loanBillNo = interestBill.getString("loanbillno");
                Date expireDate = loanBill_DateMap.get(loanBillNo);
                if (!EmptyUtil.isNoEmpty((Object)expireDate) || bizDate.compareTo(expireDate) <= 0) continue;
                this.addErrorMessage(entity, CfmBusinessResourceEnum.ExtendBillUnAuditValidator_03.loadKDString(loanBillNo));
            }
        }
    }

    private void checkPreIntByBizDate(ExtendedDataEntity entity, DynamicObjectCollection entrys) {
        List loanBillNos = entrys.stream().map(o -> o.getString("drawbillno")).collect(Collectors.toList());
        DynamicObjectCollection batchIntBills = IntBillBatchPreRepository.getBatchPreIntBills(loanBillNos);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)batchIntBills)) {
            Map<String, Date> loanBill_DateMap = entrys.stream().collect(Collectors.toMap(o -> o.getString("drawbillno"), o -> o.getDate("e_prevrenewalexpiredate")));
            for (DynamicObject batchIntBill : batchIntBills) {
                Date preintDate = batchIntBill.getDate("preintdate");
                String loanBillNo = batchIntBill.getString("entry.loannum");
                Date expireDate = loanBill_DateMap.get(loanBillNo);
                if (!EmptyUtil.isNoEmpty((Object)expireDate) || preintDate.compareTo(expireDate) <= 0) continue;
                this.addErrorMessage(entity, CfmBusinessResourceEnum.ExtendBillUnAuditValidator_04.loadKDString(loanBillNo));
            }
        }
    }
}

