/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.extendbill;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.ExtendHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ExtendBillUnConfirmValidator
extends AbstractTmcBizOppValidator {
    private static String[] staticProperties = new String[]{"expiredate", "billno", "repayplan_entry", "repayplan_entry.exrepaymentdate"};

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("loanbilllist");
        sic.add("loanbilllist.drawbillid");
        sic.add("loanbilllist.isrenewal");
        sic.add("isinit");
        sic.add("lendernature");
        sic.add("datasource");
        sic.add("confirmstatus");
        sic.add("productfactory");
        sic.add("renewalexpiredate");
        sic.add("enddate");
        sic.add("prevrenewalexpiredate");
        sic.add("startdate");
        sic.add("referencerate");
        sic.add("rateadjustcycletype");
        sic.add("loantype");
        sic.add("createtime");
        sic.add("loancontractbill");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject[] loanBills;
            DynamicObject extendBill = dataEntity.getDataEntity();
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(extendBill.getString("datasource"));
            if (extendBill.getBoolean("isinit")) {
                this.addErrorMessage(dataEntity, bizResource.getUnConfirmInitData());
                continue;
            }
            DynamicObject contractBillF7 = extendBill.getDynamicObject("loancontractbill");
            if (EmptyUtil.isNoEmpty((DynamicObject)contractBillF7) && LoanContractStatusEnum.CLOSED.getValue().equals(contractBillF7.getString("contractstatus")) && contractBillF7.getBoolean("ishandend")) {
                String contractNum = contractBillF7.getString("number");
                this.addErrorMessage(dataEntity, String.format(bizResource.getIbUnOpContractByHandEnd(), contractNum));
                continue;
            }
            if (!ExtendHelper.isTheLatestExtendBill((DynamicObject)extendBill)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u591a\u6b21\u5c55\u671f\u65f6\u53ea\u80fd\u4ece\u6700\u540e\u4e00\u6b21\u5c55\u671f\u5f00\u59cb\u64cd\u4f5c\u3002", (String)"ExtendBillUnConfirmValidator_01", (String)"tmc-cfm-business", (Object[])new Object[0]));
                continue;
            }
            String dataSource = extendBill.getString("datasource");
            String entityName = extendBill.getDataEntityType().getName();
            if (BusinessHelper.isSameSource((String)entityName, (String)dataSource) && !entityName.startsWith("ifm_")) {
                this.addErrorMessage(dataEntity, bizResource.getUnConfirmSameSourceData());
            }
            String confirmstatus = extendBill.getString("confirmstatus");
            if (!StringUtils.equals((CharSequence)ConfirmStatusEnum.YETCONFIRM.getValue(), (CharSequence)confirmstatus) && !entityName.startsWith("ifm_")) {
                this.addErrorMessage(dataEntity, bizResource.getConfirmStatusError());
            }
            DynamicObjectCollection entrys = extendBill.getDynamicObjectCollection("loanbilllist");
            ArrayList<Long> pkList = new ArrayList<Long>();
            for (DynamicObject entry : entrys) {
                if (!entry.getBoolean("isrenewal")) continue;
                pkList.add(entry.getLong("drawbillid"));
            }
            if (CollectionUtils.isEmpty(pkList)) continue;
            QFilter pkFilter = new QFilter("id", "in", pkList);
            CharSequence[] selectProperties = staticProperties;
            for (DynamicObject loanBill : loanBills = TmcDataServiceHelper.load((String)"cfm_loanbill", (String)String.join((CharSequence)",", selectProperties), (QFilter[])new QFilter[]{pkFilter})) {
                Date expiredate = loanBill.getDate("expiredate");
                DynamicObjectCollection repayPlans = loanBill.getDynamicObjectCollection("repayplan_entry");
                for (DynamicObject repayPlan : repayPlans) {
                    Date exrepaymentdate = repayPlan.getDate("exrepaymentdate");
                    if (exrepaymentdate.compareTo(expiredate) <= 0) continue;
                    this.addErrorMessage(dataEntity, String.format(bizResource.getEbUnConfirmRepayPlandate(), loanBill.getString("billno")));
                }
            }
        }
    }
}

