/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.finlease;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinLeaseLoanTypeValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("loantype");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        String ignoreFinLeaseFlag = (String)this.getOption().getVariables().get("ignoreFinLeaseFlag");
        if (EmptyUtil.isNoEmpty((String)ignoreFinLeaseFlag)) {
            return;
        }
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            boolean isFlEntity;
            DynamicObject data = extendedDataEntity.getDataEntity();
            String loanType = data.getString("loantype");
            String entityName = data.getDynamicObjectType().getName();
            boolean finLease = LoanTypeEnum.isFinLease((String)loanType);
            if (finLease == (isFlEntity = entityName.startsWith("fl_"))) continue;
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u540d\u79f0:%1$s\u4e0e\u501f\u6b3e\u7c7b\u578b%2$s\u4e0d\u5339\u914d\u3002", (String)"FinLeaseLoanTypeValidator_0", (String)"tmc-cfm-business", (Object[])new Object[0]), entityName, LoanTypeEnum.getName((String)loanType)));
        }
    }
}

