/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.initbill;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.InitStatusEnum;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InitBillEndInitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("initstatus");
        sic.add("datasource");
        sic.add("repaymentway");
        sic.add("tradefin_entry");
        sic.add("tradefin_entry.e_tf_relatebillid");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject initBill = dataEntity.getDataEntity();
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(initBill.getString("datasource"));
            String initStatus = initBill.getString("initstatus");
            if (!InitStatusEnum.INITING.getValue().equals(initStatus)) {
                this.addErrorMessage(dataEntity, bizResource.getInbEndinitInitstatus());
            }
            this.validateTradeFinInfo(dataEntity, initBill);
            String repaymentWay = initBill.getString("repaymentway");
            List<String> repaymentWayList = Arrays.asList(RepaymentWayEnum.debx.getValue(), RepaymentWayEnum.debj.getValue(), RepaymentWayEnum.dbdx.getValue());
            if (!EmptyUtil.isEmpty((String)repaymentWay) && !repaymentWayList.contains(repaymentWay)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8fd8\u6b3e/\u672c\u91d1\u6536\u56de\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e14\u4e0d\u80fd\u4e3a\u7b49\u989d\u672c\u606f\u3001\u7b49\u989d\u672c\u91d1\u3001\u7b49\u672c\u7b49\u606f\u3002", (String)"InitBillEndInitValidator_2", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
    }

    private void validateTradeFinInfo(ExtendedDataEntity dataEntity, DynamicObject initBill) {
        DynamicObjectCollection tradeEntry = initBill.getDynamicObjectCollection("tradefin_entry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)tradeEntry)) {
            return;
        }
        Set relateSet = tradeEntry.stream().map(r -> r.getLong("e_tf_relatebillid")).filter(r -> EmptyUtil.isNoEmpty((Long)r)).collect(Collectors.toSet());
        if (EmptyUtil.isNoEmpty(relateSet)) {
            QFilter qFilter = new QFilter("id", "!=", initBill.getPkValue());
            qFilter.and("tradefin_entry.e_tf_relatebillid", "in", relateSet);
            DynamicObjectCollection existCols = QueryServiceHelper.query((String)initBill.getDataEntityType().getName(), (String)"billno", (QFilter[])new QFilter[]{qFilter}, (String)"");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)existCols)) {
                List existBills = existCols.stream().map(r -> r.getString("billno")).collect(Collectors.toList());
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d38\u878d\u5173\u8054\u7684\u4fe1\u7528\u8bc1\u4ea4\u5355\u6216\u5230\u5355\u5df2\u7ecf\u88ab\u5176\u4ed6\u521d\u59cb\u5316\u5355\u3010%s\u3011\u7ba1\u7406\u3002", (String)"InitBillEndInitValidator_1", (String)"tmc-cfm-business", (Object[])new Object[]{String.join((CharSequence)",", existBills)}));
            }
        }
    }
}

