/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.initbill;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.GuaranteeWayEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InitBillForGmEntryValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("guarantee");
        selector.add("guarantee");
        selector.add("loanentry");
        selector.add("gcontract");
        selector.add("gratio");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            DynamicObjectCollection subEntry;
            DynamicObjectCollection loanEntry;
            DynamicObject initBill = extData.getDataEntity();
            String guarWay = initBill.getString("guarantee");
            List guaWayList = Arrays.stream(guarWay.split(",")).filter(r -> EmptyUtil.isNoEmpty((String)r)).collect(Collectors.toList());
            if (guaWayList.contains(GuaranteeWayEnum.NONE.getNumberValue()) && guaWayList.size() > 1) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u65e0\u62c5\u4fdd\u53ca\u5176\u4ed6\u62c5\u4fdd\u65b9\u5f0f\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u3002", (String)"InitBillSaveValidator_07", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
            boolean relateDebt = this.isRelateDebt(initBill);
            if (guaWayList.contains(GuaranteeWayEnum.ENSURE.getNumberValue()) || guaWayList.contains(GuaranteeWayEnum.MORTGAGE.getNumberValue()) || guaWayList.contains(GuaranteeWayEnum.PLEDGE.getNumberValue())) {
                loanEntry = initBill.getDynamicObjectCollection("loanentry");
                for (DynamicObject parentRow : loanEntry) {
                    subEntry = parentRow.getDynamicObjectCollection("gmsubentry");
                    if (EmptyUtil.isEmpty((DynamicObjectCollection)subEntry) && relateDebt) {
                        this.addErrorMessage(extData, ResManager.loadKDString((String)"\u62c5\u4fdd\u65b9\u5f0f\u4e3a\u4fdd\u8bc1\u3001\u62b5\u62bc\u3001\u8d28\u62bc\u65f6\uff0c\u8bf7\u5148\u586b\u5199\u62c5\u4fdd\u4fe1\u606f\u3002", (String)"InitBillSaveValidator_03", (String)"tmc-cfm-business", (Object[])new Object[0]));
                        continue;
                    }
                    List notCreditSubEntry = subEntry.stream().filter(r -> !r.getBoolean("gcreditguarantee")).collect(Collectors.toList());
                    BigDecimal totalRatio = BigDecimal.ZERO;
                    for (DynamicObject subRow : notCreditSubEntry) {
                        DynamicObject gmContract = subRow.getDynamicObject("gcontract");
                        if (EmptyUtil.isEmpty((DynamicObject)gmContract)) continue;
                        String gmContractNum = gmContract.getString("billno");
                        String operationName = this.getOperationName();
                        if (!BillStatusEnum.AUDIT.getValue().equals(gmContract.getString("billstatus"))) {
                            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u62c5\u4fdd\u5408\u540c\u3010%1$s\u3011\u4e3a\u975e\u5df2\u5ba1\u6838\u72b6\u6001\uff0c\u4e0d\u80fd%2$s\u3002", (String)"InitBillSaveValidator_08", (String)"tmc-cfm-business", (Object[])new Object[]{gmContractNum, operationName}));
                            continue;
                        }
                        if ("closed".equals(gmContract.getString("bizstatus"))) {
                            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u62c5\u4fdd\u5408\u540c\u3010%1$s\u3011\u4e1a\u52a1\u72b6\u6001\u5df2\u662f\u5173\u95ed\u72b6\u6001\uff0c\u4e0d\u80fd%2$s\u3002", (String)"InitBillSaveValidator_09", (String)"tmc-cfm-business", (Object[])new Object[]{gmContractNum, operationName}));
                            continue;
                        }
                        String guaranteeWay = gmContract.getString("guaranteeway");
                        if (EmptyUtil.isEmpty((String)guaranteeWay)) continue;
                        List onBillList = Arrays.stream(guaranteeWay.split(",")).filter(r -> EmptyUtil.isNoEmpty((String)r)).map(r -> GuaranteeWayEnum.exchangeValueToNumberValue((String)r)).collect(Collectors.toList());
                        if (Collections.disjoint(guaWayList, onBillList)) {
                            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u8d37\u6b3e\u5408\u540c\u4e0e\u62c5\u4fdd\u5408\u540c\u7684\u62c5\u4fdd\u65b9\u5f0f\u65e0\u4ea4\u96c6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u62c5\u4fdd\u5408\u540c\u3002", (String)"InitBillForGmEntryValidator_0", (String)"tmc-cfm-business", (Object[])new Object[0]));
                            continue;
                        }
                        totalRatio = totalRatio.add(subRow.getBigDecimal("gratio"));
                    }
                }
                continue;
            }
            loanEntry = initBill.getDynamicObjectCollection("loanentry");
            for (DynamicObject parentRow : loanEntry) {
                subEntry = parentRow.getDynamicObjectCollection("gmsubentry");
                long notCreditGuaNo = subEntry.stream().filter(r -> !r.getBoolean("gcreditguarantee")).count();
                if (notCreditGuaNo <= 0L) continue;
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u62c5\u4fdd\u65b9\u5f0f\u4e0d\u5305\u542b\u4fdd\u8bc1\u3001\u62b5\u62bc\u3001\u8d28\u62bc\u65f6\uff0c\u201c\u62c5\u4fdd\u4fe1\u606f\u201d\u4e0d\u5141\u8bb8\u5b58\u5728\u975e\u989d\u5ea6\u62c5\u4fdd\u4fe1\u606f\u3002", (String)"InitBillForGmEntryValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]));
            }
        }
    }

    private boolean isRelateDebt(DynamicObject bizBill) {
        DynamicObject mainBizOrg = bizBill.getDynamicObject(EntityMetadataCache.getDataEntityType((String)bizBill.getDataEntityType().getName()).getMainOrg());
        if (EmptyUtil.isEmpty((DynamicObject)mainBizOrg)) {
            return false;
        }
        return TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.GM.getId(), (long)mainBizOrg.getLong("id"), (String)"isrelatedebt");
    }
}

