/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.initbill;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InitBillGenRepayPlanValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("datasource");
        sic.add("loanentry");
        sic.add("loantype");
        sic.add("drawamount");
        sic.add("interestrate");
        sic.add("currency");
        sic.add("repaymentway");
        sic.add("loaddate");
        sic.add("expiredate");
        sic.add("loan_repaymentway");
        sic.add("loan_stageplan");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            this.validateLoanEntry(dataEntity);
        }
    }

    private void validateLoanEntry(ExtendedDataEntity dataEntity) {
        DynamicObject initBill = dataEntity.getDataEntity();
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource(initBill.getString("datasource"));
        DynamicObjectCollection loanEntrys = initBill.getDynamicObjectCollection("loanentry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)loanEntrys)) {
            this.addErrorMessage(dataEntity, bizResource.getInbEndLoanNotNull());
            return;
        }
        boolean isBond = false;
        if (LoanTypeEnum.BOND.getValue().equals(initBill.getString("loantype"))) {
            isBond = true;
        }
        if (EmptyUtil.isEmpty((DynamicObject)initBill.getDynamicObject("currency"))) {
            this.addErrorMessage(dataEntity, bizResource.getInitCurrenyIsNotNull());
            return;
        }
        if (!isBond) {
            if (EmptyUtil.isEmpty((String)initBill.getString("repaymentway"))) {
                this.addErrorMessage(dataEntity, bizResource.getLoanRepayMentWayIsNotNull());
                return;
            }
            this.validateRepaymentWay(dataEntity, bizResource);
        }
        for (int i = 0; i < loanEntrys.size(); ++i) {
            DynamicObject loanEntry = (DynamicObject)loanEntrys.get(i);
            if (EmptyUtil.isEmpty((BigDecimal)loanEntry.getBigDecimal("drawamount"))) {
                this.addErrorMessage(dataEntity, String.format(bizResource.getLoanEntryDrawAmtIsNotNull(), i + 1));
                return;
            }
            if (EmptyUtil.isEmpty((Object)loanEntry.getDate("loaddate"))) {
                this.addErrorMessage(dataEntity, String.format(bizResource.getLoanEntryLoanDateIsNotNull(), i + 1));
                return;
            }
            if (EmptyUtil.isEmpty((Object)loanEntry.getDate("expiredate"))) {
                this.addErrorMessage(dataEntity, String.format(bizResource.getLoanEntryExpireDateIsNotNull(), i + 1));
                return;
            }
            if (!isBond) continue;
            if (EmptyUtil.isEmpty((String)loanEntry.getString("loan_repaymentway"))) {
                this.addErrorMessage(dataEntity, String.format(bizResource.getLoanBondEntryRepayMentWayIsNotNull(), i + 1));
                return;
            }
            this.validateEntryRepaymentWay(dataEntity, loanEntry, bizResource);
        }
    }

    private void validateEntryRepaymentWay(ExtendedDataEntity dataEntity, DynamicObject loanEntry, AbstractBizResource bizResource) {
        ArrayList repayWays;
        String repaymentWay = loanEntry.getString("loan_repaymentway");
        ArrayList intPlanWays = Lists.newArrayList((Object[])new String[]{RepaymentWayEnum.bqhbdqhx.getValue(), RepaymentWayEnum.dqhbdqhx.getValue(), RepaymentWayEnum.zdyhk.getValue()});
        BigDecimal interestRate = dataEntity.getDataEntity().getBigDecimal("interestrate");
        if (EmptyUtil.isNoEmpty((BigDecimal)interestRate) && intPlanWays.contains(repaymentWay) && EmptyUtil.isEmpty((DynamicObject)loanEntry.getDynamicObject("loan_interestsettledplan"))) {
            this.addErrorMessage(dataEntity, bizResource.getInterestSettledPlanNotNull());
        }
        if ((repayWays = Lists.newArrayList((Object[])new String[]{RepaymentWayEnum.dqhblsbq.getValue(), RepaymentWayEnum.dqhbdqhx.getValue(), RepaymentWayEnum.debx.getValue()})).contains(repaymentWay) && EmptyUtil.isEmpty((DynamicObject)loanEntry.getDynamicObject("loan_stageplan"))) {
            this.addErrorMessage(dataEntity, bizResource.getStagePlanNotNull());
        }
    }

    private void validateRepaymentWay(ExtendedDataEntity dataEntity, AbstractBizResource bizResource) {
        ArrayList repayWays;
        DynamicObject initBill = dataEntity.getDataEntity();
        String repaymentWay = initBill.getString("repaymentway");
        ArrayList intPlanWays = Lists.newArrayList((Object[])new String[]{RepaymentWayEnum.bqhbdqhx.getValue(), RepaymentWayEnum.dqhbdqhx.getValue(), RepaymentWayEnum.zdyhk.getValue()});
        BigDecimal interestRate = initBill.getBigDecimal("interestrate");
        String settleIntMode = initBill.getString("settleintmode");
        if (EmptyUtil.isNoEmpty((BigDecimal)interestRate) && intPlanWays.contains(repaymentWay) && EmptyUtil.isEmpty((DynamicObject)initBill.getDynamicObject("interestsettledplan")) && SettleIntModeEnum.gdpljx.getValue().equals(settleIntMode)) {
            this.addErrorMessage(dataEntity, bizResource.getInterestSettledPlanNotNull());
        }
        if ((repayWays = Lists.newArrayList((Object[])new String[]{RepaymentWayEnum.dqhblsbq.getValue(), RepaymentWayEnum.dqhbdqhx.getValue(), RepaymentWayEnum.debx.getValue()})).contains(repaymentWay) && EmptyUtil.isEmpty((DynamicObject)initBill.getDynamicObject("stageplan"))) {
            this.addErrorMessage(dataEntity, bizResource.getStagePlanNotNull());
        }
    }
}

