/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.initbill;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class InitBillOccupyBondLimitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("occupybondlimit");
        sic.add("loaddate");
        sic.add("drawamount");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        HashMap<Long, BigDecimal> limitAvaliamtMap = new HashMap<Long, BigDecimal>(16);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject initBill = dataEntity.getDataEntity();
            this.validateOccupybondlimit(dataEntity, initBill, limitAvaliamtMap);
        }
    }

    private void validateOccupybondlimit(ExtendedDataEntity extendedDataEntity, DynamicObject initBill, Map<Long, BigDecimal> limitAvaliamtMap) {
        DynamicObjectCollection loanentry = initBill.getDynamicObjectCollection("loanentry");
        Map entryGroup = loanentry.stream().filter(e -> e.getDynamicObject("occupybondlimit") != null).collect(Collectors.groupingBy(e -> (Long)e.getDynamicObject("occupybondlimit").getPkValue(), Collectors.toList()));
        HashMap<Long, BigDecimal> limitdrawMap = new HashMap<Long, BigDecimal>(16);
        for (Map.Entry entry : entryGroup.entrySet()) {
            Long limitId = entry.getKey();
            DynamicObject limit = TmcDataServiceHelper.loadSingle((Object)limitId, (String)"bdim_bond_limit", (String)"number,status,enable,effectdate,expirydate,availamt");
            List entrys = entry.getValue();
            BigDecimal groupDrawAmount = BigDecimal.ZERO;
            for (DynamicObject entry2 : entrys) {
                Date bizdate = entry2.getDate("loaddate");
                BigDecimal drawAmount = entry2.getBigDecimal("drawamount");
                this.validateStatus(extendedDataEntity, limit);
                this.validateEnable(extendedDataEntity, limit);
                this.validateBizdate(extendedDataEntity, limit, bizdate);
                groupDrawAmount = groupDrawAmount.add(drawAmount);
            }
            if (limitdrawMap.containsKey(limitId)) {
                BigDecimal amount = (BigDecimal)limitdrawMap.get(limitId);
                limitdrawMap.put(limitId, amount.add(groupDrawAmount));
                continue;
            }
            limitdrawMap.put(limitId, groupDrawAmount);
        }
        if (limitdrawMap.size() > 0) {
            for (Map.Entry<Long, List<Object>> entry : limitdrawMap.entrySet()) {
                BigDecimal availamt;
                Long id = entry.getKey();
                BigDecimal amount = (BigDecimal)((Object)entry.getValue());
                DynamicObject limit = TmcDataServiceHelper.loadSingle((Object)id, (String)"bdim_bond_limit", (String)"number,availamt");
                if (limitAvaliamtMap.containsKey(id)) {
                    availamt = limitAvaliamtMap.get(id);
                    if (availamt.compareTo(amount) < 0) {
                        this.addMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7ed3\u675f\u521d\u59cb\u5316\u5931\u8d25\uff0c\u6ce8\u518c\u989d\u5ea6%1$s\u53ef\u7528\u989d\u5ea6\u4e0d\u8db3\u3002", (String)"InitBillOccupyBondLimitValidator_4", (String)"tmc-cfm-business", (Object[])new Object[0]), limit.getString("number")));
                        continue;
                    }
                    limitAvaliamtMap.put(id, availamt.subtract(amount));
                    continue;
                }
                availamt = limit.getBigDecimal("availamt");
                if (availamt.compareTo(amount) < 0) {
                    this.addMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7ed3\u675f\u521d\u59cb\u5316\u5931\u8d25\uff0c\u6ce8\u518c\u989d\u5ea6%1$s\u53ef\u7528\u989d\u5ea6\u4e0d\u8db3\u3002", (String)"InitBillOccupyBondLimitValidator_4", (String)"tmc-cfm-business", (Object[])new Object[0]), limit.getString("number")));
                    continue;
                }
                limitAvaliamtMap.put(id, availamt.subtract(amount));
            }
        }
    }

    private void validateStatus(ExtendedDataEntity extendedDataEntity, DynamicObject limit) {
        String billstatus = limit.getString("status");
        if (!"C".equals(billstatus)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53d1\u884c\u989d\u5ea6\u7684\u5355\u636e\u72b6\u6001\u4e0d\u662f\u5df2\u5ba1\u6838\uff0c\u8bf7\u4fee\u6539\u5360\u7528\u53d1\u884c\u989d\u5ea6\u3002", (String)"InitBillOccupyBondLimitValidator_0", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
    }

    private void validateEnable(ExtendedDataEntity extendedDataEntity, DynamicObject limit) {
        String enable = limit.getString("enable");
        if ("0".equals(enable)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53d1\u884c\u989d\u5ea6\u7684\u4f7f\u7528\u72b6\u6001\u4e0d\u53ef\u7528\uff0c\u8bf7\u4fee\u6539\u5360\u7528\u53d1\u884c\u989d\u5ea6\u3002", (String)"InitBillOccupyBondLimitValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
    }

    private void validateBizdate(ExtendedDataEntity extendedDataEntity, DynamicObject limit, Date bizdate) {
        Date effectdate = limit.getDate("effectdate");
        Date expirydate = limit.getDate("expirydate");
        if (bizdate.after(expirydate) || bizdate.before(effectdate)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53d1\u884c\u65e5\u671f\u4e0d\u5728\u53d1\u884c\u989d\u5ea6\u6709\u6548\u671f\u5185\uff0c\u8bf7\u4fee\u6539\u5360\u7528\u53d1\u884c\u989d\u5ea6\u3002", (String)"InitBillOccupyBondLimitValidator_2", (String)"tmc-cfm-business", (Object[])new Object[0]));
        }
    }

    private void validateAmount(ExtendedDataEntity extendedDataEntity, DynamicObject limit, BigDecimal drawAmount) {
        BigDecimal availamt = limit.getBigDecimal("availamt");
        if (drawAmount.compareTo(availamt) > 0) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53d1\u884c\u989d\u5ea6%s\u53ef\u7528\u989d\u5ea6\u4e0d\u8db3\uff0c\u8bf7\u4fee\u6539\u5360\u7528\u53d1\u884c\u989d\u5ea6\u3002", (String)"InitBillOccupyBondLimitValidator_3", (String)"tmc-cfm-business", (Object[])new Object[]{limit.getString("number")}));
        }
    }
}

