/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.business.validate.initbill;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.cfm.common.enums.InitStatusEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.OppUnitTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InitBillSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("ratesign");
        sic.add("ratefloatpoint");
        sic.add("rateadjuststyle");
        sic.add("rateadjustdate");
        sic.add("rateadjustcycletype");
        sic.add("rateadjustcycle");
        sic.add("creditortype");
        sic.add("debtortype");
        sic.add("repaymentway");
        sic.add("settleintmode");
        sic.add("basis");
        sic.add("stageplan");
        sic.add("interestsettledplan");
        sic.add("floatingratio");
        sic.add("islimitclause");
        sic.add("limitclauseexplain");
        sic.add("loantype");
        sic.add("loaneracctbank");
        sic.add("isextend");
        sic.add("protocolno");
        sic.add("renewaldate");
        sic.add("renewalexpiredate");
        sic.add("renewalinteresttype");
        sic.add("renewalinterestrate");
        sic.add("exreferencerate");
        sic.add("exratesign");
        sic.add("exratefloatpoint");
        sic.add("exrateadjuststyle");
        sic.add("exrateadjustcycletype");
        sic.add("exrateadjustcycle");
        sic.add("initstatus");
        sic.add("lendernature");
        sic.add("creditorg");
        sic.add("interesttype");
        sic.add("interestrate");
        sic.add("isclientloan");
        sic.add("clientorg");
        sic.add("repaymentway");
        sic.add("stageplan");
        sic.add("startdate");
        sic.add("enddate");
        sic.add("interesttype");
        sic.add("rateadjuststyle");
        sic.add("ratefloatpoint");
        sic.add("rateadjuststyle");
        sic.add("rateadjustdate");
        sic.add("startdate");
        sic.add("enddate");
        sic.add("datasource");
        sic.add("rateadjustcycle");
        sic.add("renewalinteresttype");
        sic.add("loanentry");
        sic.add("loanentry.creditamount");
        sic.add("loanentry.creditlimit");
        sic.add("loanentry.loanratesign");
        sic.add("loanentry.loanratefloatpoint");
        sic.add("loanentry.loanrateadjuststyle");
        sic.add("loanentry.drawamount");
        sic.add("feedetail");
        sic.add("feeoppunittype");
        sic.add("feeoppunit");
        sic.add("feeoppunittext");
        sic.add("loan_feedetail");
        sic.add("lfeeoppunittype");
        sic.add("lfeeoppunit");
        sic.add("lfeeoppunittext");
        sic.add("guarantee");
        sic.add("loanentry");
        sic.add("creditorg");
        sic.add("org");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            BigDecimal interestrate;
            int diffDays;
            QFilter filter;
            DynamicObject org;
            String textCreditor;
            DynamicObject org2;
            Long loanOrgId;
            DynamicObject initBill = dataEntity.getDataEntity();
            this.validateFeeInfo(dataEntity, initBill);
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(initBill.getString("datasource"));
            if (TmcDataServiceHelper.isFromDatabase((ExtendedDataEntity)dataEntity)) {
                Long pkId = (Long)initBill.getPkValue();
                DynamicObject initDb = TmcDataServiceHelper.loadSingle((Object)pkId, (String)"cfm_initbill", (String)"initstatus");
                String initStatus = initDb.getString("initstatus");
                if (InitStatusEnum.INITED.getValue().equals(initStatus)) {
                    this.addErrorMessage(dataEntity, bizResource.getInbSaveInited());
                    continue;
                }
            }
            if (LoanTypeEnum.isLinklend((String)initBill.getString("loantype")) && CreditorTypeEnum.INNERUNIT.getValue().equals(initBill.getString("creditortype")) && EmptyUtil.isEmpty((DynamicObject)initBill.getDynamicObject("loaneracctbank"))) {
                this.addErrorMessage(dataEntity, bizResource.mustInputCreditorAcct());
                continue;
            }
            if (initBill.getBoolean("isclientloan") && EmptyUtil.isEmpty((DynamicObject)initBill.getDynamicObject("clientorg"))) {
                this.addErrorMessage(dataEntity, bizResource.getCbClientorgNotNull());
            }
            if (!BusinessHelper.isOutGroup((DynamicObject)initBill) && EmptyUtil.isNoEmpty((Long)(loanOrgId = Long.valueOf(initBill.getLong("creditor")))) && (org2 = initBill.getDynamicObject("org")).getPkValue().equals(loanOrgId)) {
                this.addErrorMessage(dataEntity, bizResource.getInbLoanorgSame());
            }
            if (StringUtils.equals((CharSequence)initBill.getString("creditortype"), (CharSequence)CreditorTypeEnum.INNERUNIT.getValue()) && EmptyUtil.isNoEmpty((String)(textCreditor = initBill.getString("textcreditor"))) && EmptyUtil.isEmpty((DynamicObject)(org = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{filter = new QFilter("name", "=", (Object)textCreditor).and("fisbankroll", "=", (Object)true)})))) {
                this.addErrorMessage(dataEntity, bizResource.checkCreditorNoData());
            }
            Date startDate = initBill.getDate("startdate");
            Date endDate = initBill.getDate("enddate");
            Date signDate = initBill.getDate("bizdate");
            if (startDate == null) {
                this.addErrorMessage(dataEntity, bizResource.getInbStartdateNotNull());
            }
            if (endDate == null) {
                this.addErrorMessage(dataEntity, bizResource.getInbEnddateNotNull());
            }
            if (startDate != null && endDate != null && (diffDays = DateUtils.getDiffDays((Date)startDate, (Date)endDate)) <= 1) {
                this.addErrorMessage(dataEntity, bizResource.getCbEnddateMin());
            }
            if (startDate != null && signDate != null && (diffDays = DateUtils.getDiffDays((Date)signDate, (Date)startDate) - 1) < 0) {
                this.addErrorMessage(dataEntity, bizResource.getCbSigndateMin());
            }
            boolean isLimitClause = initBill.getBoolean("islimitclause");
            String limitClauseExplain = initBill.getString("limitclauseexplain");
            if (isLimitClause && StringUtils.isBlank((CharSequence)limitClauseExplain)) {
                this.addErrorMessage(dataEntity, bizResource.getCbIslimitCheck());
            }
            String interestType = initBill.getString("interesttype");
            if ((InterestTypeEnum.FIXED.getValue().equals(interestType) || InterestTypeEnum.AGREE.getValue().equals(interestType)) && null == (interestrate = initBill.getBigDecimal("interestrate"))) {
                this.addErrorMessage(dataEntity, bizResource.getCbIntereStrateNotNull());
            }
            if (InterestTypeEnum.FLOAT.getValue().equals(interestType)) {
                if (EmptyUtil.isEmpty((String)initBill.getString("rateadjuststyle"))) {
                    this.addErrorMessage(dataEntity, bizResource.getRateAdjustStyleNotNull());
                }
                if (EmptyUtil.isEmpty((DynamicObject)initBill.getDynamicObject("referencerate"))) {
                    this.addErrorMessage(dataEntity, bizResource.getReferenceRateNotNull());
                }
                if (RateAdjustStyleEnum.CYCLE.getValue().equals(initBill.getString("rateadjuststyle"))) {
                    Date rateAdjustDate = initBill.getDate("rateadjustdate");
                    if (EmptyUtil.isEmpty((Object)rateAdjustDate)) {
                        this.addErrorMessage(dataEntity, bizResource.getRateadjustDateNotNull());
                    } else {
                        endDate = initBill.getDate("enddate");
                        if (rateAdjustDate.compareTo(endDate) >= 0) {
                            this.addErrorMessage(dataEntity, bizResource.getRateadjustDateRange());
                        }
                    }
                    if (EmptyUtil.isEmpty((Object)initBill.get("rateadjustcycle"))) {
                        this.addErrorMessage(dataEntity, bizResource.getRateAdjustCycleNotNull());
                    }
                    if (EmptyUtil.isEmpty((Object)initBill.get("rateadjustcycletype"))) {
                        this.addErrorMessage(dataEntity, bizResource.getRateAdjustCycleTypeNotNull());
                    }
                }
                DynamicObjectCollection loanEntry = initBill.getDynamicObjectCollection("loanentry");
                for (DynamicObject loan : loanEntry) {
                    String entryLoanRateAdjustStyle = loan.getString("loanrateadjuststyle");
                    if (EmptyUtil.isEmpty((String)entryLoanRateAdjustStyle)) {
                        this.addErrorMessage(dataEntity, bizResource.initBillRateloanrateadjuststyleCanNotNull());
                    }
                    if (!RateAdjustStyleEnum.CYCLE.getValue().equals(loan.getString("loanrateadjuststyle"))) continue;
                    Date rateAdjustDate = loan.getDate("loanrateadjustdate");
                    if (EmptyUtil.isEmpty((Object)rateAdjustDate)) {
                        this.addErrorMessage(dataEntity, bizResource.getRateadjustDateNotNull());
                        continue;
                    }
                    startDate = loan.getDate("loaddate");
                    endDate = loan.getDate("expiredate");
                    if (rateAdjustDate.compareTo(endDate) >= 0) {
                        this.addErrorMessage(dataEntity, bizResource.getLoanRateadjustDateRange());
                    }
                    if (EmptyUtil.isEmpty((Object)loan.get("loanrateadjusttype"))) {
                        this.addErrorMessage(dataEntity, bizResource.getLoanRateAdjustCycleTypeNotNull());
                    }
                    if (EmptyUtil.isEmpty((Object)loan.get("loanrateadjustcycle"))) {
                        this.addErrorMessage(dataEntity, bizResource.getLoanRateAdjustCycleNotNull());
                    }
                    if (!EmptyUtil.isEmpty((Object)loan.get("loanrateadjusttype"))) continue;
                    this.addErrorMessage(dataEntity, bizResource.initBillRateloanrateadjuststyleCanNotNull());
                }
            }
            this.validExtInfo(dataEntity, initBill, bizResource, startDate, endDate);
            this.validateLoanEntry(dataEntity);
        }
    }

    private void validateRepaymentWay(ExtendedDataEntity dataEntity, AbstractBizResource bizResource) {
        List<String> repayWays;
        DynamicObject initBill = dataEntity.getDataEntity();
        String repaymentWay = initBill.getString("repaymentway");
        List<String> intPlanWays = Arrays.asList(RepaymentWayEnum.bqhbdqhx.getValue(), RepaymentWayEnum.dqhbdqhx.getValue(), RepaymentWayEnum.zdyhk.getValue());
        if (intPlanWays.contains(repaymentWay)) {
            BigDecimal interestrate = initBill.getBigDecimal("interestrate");
            String interestType = initBill.getString("interesttype");
            String settleMode = initBill.getString("settleintmode");
            if ((EmptyUtil.isNoEmpty((BigDecimal)interestrate) || InterestTypeEnum.FLOAT.getValue().equals(interestType)) && SettleIntModeEnum.gdpljx.getValue().equals(settleMode) && EmptyUtil.isEmpty((DynamicObject)initBill.getDynamicObject("interestsettledplan"))) {
                this.addErrorMessage(dataEntity, bizResource.getInterestSettledPlanNotNull());
            }
        }
        if ((repayWays = Arrays.asList(RepaymentWayEnum.dqhblsbq.getValue(), RepaymentWayEnum.dqhbdqhx.getValue(), RepaymentWayEnum.debx.getValue())).contains(repaymentWay) && EmptyUtil.isEmpty((DynamicObject)initBill.getDynamicObject("stageplan"))) {
            this.addErrorMessage(dataEntity, bizResource.getStagePlanNotNull());
        }
    }

    private void validateFeeInfo(ExtendedDataEntity dataEntity, DynamicObject info) {
        MainEntityType tagEntityType = MetadataServiceHelper.getDataEntityType((String)info.getDataEntityType().getName());
        DynamicObject mainOrg = info.getDynamicObject(tagEntityType.getMainOrg());
        DynamicObjectCollection contractFeeDetailEntrys = info.getDynamicObjectCollection("feedetail");
        String feeBillType = ResManager.loadKDString((String)"\u5408\u540c", (String)"BusinessInfoSaveValidator_5", (String)"tmc-cfm-business", (Object[])new Object[0]);
        String loanType = info.getString("loantype");
        if (LoanTypeEnum.BOND.getValue().equals(loanType)) {
            feeBillType = ResManager.loadKDString((String)"\u53d1\u884c\u8ba1\u5212", (String)"InitBillSaveValidator_1", (String)"tmc-cfm-business", (Object[])new Object[0]);
        }
        for (int i = 0; i < contractFeeDetailEntrys.size(); ++i) {
            DynamicObject feeEntry = (DynamicObject)contractFeeDetailEntrys.get(i);
            String oppType = feeEntry.getString("feeoppunittype");
            String oppName = feeEntry.getString("feeoppunittext");
            this.volidateOppUnitInfo(dataEntity, mainOrg, feeBillType, i, oppType, oppName);
        }
        DynamicObjectCollection loanEntrys = info.getDynamicObjectCollection("loanentry");
        for (DynamicObject loanEntry : loanEntrys) {
            DynamicObjectCollection loanFeeDetailEntrys = loanEntry.getDynamicObjectCollection("loan_feedetail");
            for (int i = 0; i < loanFeeDetailEntrys.size(); ++i) {
                DynamicObject feeEntry = (DynamicObject)loanFeeDetailEntrys.get(i);
                String oppType = feeEntry.getString("lfeeoppunittype");
                String oppName = feeEntry.getString("lfeeoppunittext");
                feeBillType = ResManager.loadKDString((String)"\u63d0\u6b3e", (String)"InitBillSaveValidator_2", (String)"tmc-cfm-business", (Object[])new Object[0]);
                if (LoanTypeEnum.BOND.getValue().equals(loanType)) {
                    feeBillType = ResManager.loadKDString((String)"\u53d1\u884c", (String)"BusinessInfoSaveValidator_4", (String)"tmc-cfm-business", (Object[])new Object[0]);
                }
                this.volidateOppUnitInfo(dataEntity, mainOrg, feeBillType, i, oppType, oppName);
            }
        }
    }

    private void volidateOppUnitInfo(ExtendedDataEntity dataEntity, DynamicObject mainOrg, String feeBillType, int i, String oppType, String oppName) {
        if (EmptyUtil.isNoEmpty((String)oppType) && EmptyUtil.isNoEmpty((String)oppName) && !OppUnitTypeEnum.OTHER.getValue().equals(oppType)) {
            QFilter existFilter = new QFilter("name", "=", (Object)oppName);
            if (OppUnitTypeEnum.SUPPLIER.getValue().equals(oppType) || OppUnitTypeEnum.CUSTOMER.getValue().equals(oppType)) {
                existFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)oppType, (Long)mainOrg.getLong("id")));
            }
            if (!TmcDataServiceHelper.exists((String)oppType, (QFilter[])existFilter.toArray())) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u8d39\u7528\u660e\u7ec6\u7684\u7b2c\u3010%2$s\u3011\u884c\u5bf9\u65b9\u5355\u4f4d\u7c7b\u578b\u548c\u5bf9\u65b9\u5355\u4f4d\u503c\u4e0d\u5339\u914d,\u8bf7\u91cd\u65b0\u70b9\u51fb\u5bf9\u65b9\u5355\u4f4d\u9009\u62e9\u3002", (String)"InitBillSaveValidator_3", (String)"tmc-cfm-business", (Object[])new Object[0]), feeBillType, i + 1));
            }
        }
    }

    private void validExtInfo(ExtendedDataEntity dataEntity, DynamicObject initBill, AbstractBizResource bizResource, Date startDate, Date endDate) {
        boolean isextend = initBill.getBoolean("isextend");
        if (isextend) {
            int diffDays;
            Date renewalExpiredate;
            Date renewaldate = initBill.getDate("renewaldate");
            if (renewaldate == null) {
                this.addErrorMessage(dataEntity, bizResource.getInbRenewaldateNotNull());
            }
            if (EmptyUtil.isEmpty((Object)(renewalExpiredate = initBill.getDate("renewalexpiredate")))) {
                this.addErrorMessage(dataEntity, bizResource.getInbRenewalexpiredateNotNull());
            }
            if (EmptyUtil.isEmpty((String)initBill.getString("renewalinteresttype"))) {
                this.addErrorMessage(dataEntity, bizResource.getInitExtRateTypeNotNull());
                return;
            }
            if (InterestTypeEnum.FLOAT.getValue().equals(initBill.getString("renewalinteresttype"))) {
                if (EmptyUtil.isEmpty((DynamicObject)initBill.getDynamicObject("exreferencerate"))) {
                    this.addErrorMessage(dataEntity, bizResource.getExtReferenceRateNotNull());
                }
                if (EmptyUtil.isEmpty((String)initBill.getString("exrateadjuststyle"))) {
                    this.addErrorMessage(dataEntity, bizResource.getInitExtRateAdjustStyleNotNull());
                }
            }
            if (startDate != null && endDate != null && renewaldate != null) {
                int sdiffDays = DateUtils.getDiffDays((Date)startDate, (Date)renewaldate);
                int ediffDays = DateUtils.getDiffDays((Date)endDate, (Date)renewaldate);
                if (sdiffDays < 1 || ediffDays > 1) {
                    this.addErrorMessage(dataEntity, String.format(bizResource.getEbBizDateOut(), DateUtils.formatString((Date)startDate, (String)"yyyy-MM-dd"), DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd")));
                }
            }
            if (endDate != null && renewalExpiredate != null && (diffDays = DateUtils.getDiffDays((Date)endDate, (Date)renewalExpiredate)) <= 0) {
                this.addErrorMessage(dataEntity, String.format(bizResource.getEbExpiredateMin(), DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd")));
            }
        }
    }

    private void validateLoanEntry(ExtendedDataEntity dataEntity) {
        DynamicObject initBill = dataEntity.getDataEntity();
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource(initBill.getString("datasource"));
        DynamicObjectCollection loanEntrys = initBill.getDynamicObjectCollection("loanentry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)loanEntrys)) {
            this.addErrorMessage(dataEntity, bizResource.getInbEndLoanNotNull());
            return;
        }
        this.validateRepaymentWay(dataEntity, bizResource);
        BigDecimal loanTotalAmt = BigDecimal.ZERO;
        for (DynamicObject loanEntry : loanEntrys) {
            Date endPreInstDate;
            Date loadDate = loanEntry.getDate("loaddate");
            Date receiveDate = loanEntry.getDate("receivedate");
            Date expireDate = loanEntry.getDate("expiredate");
            if (loadDate != null && receiveDate != null && DateUtils.getDiffDays((Date)loadDate, (Date)receiveDate) < 1) {
                this.addErrorMessage(dataEntity, String.format(bizResource.getInbReceivedateCheck(), loanEntry.getInt("seq")));
            }
            if (loadDate != null && expireDate != null && DateUtils.getDiffDays((Date)loadDate, (Date)expireDate) <= 1) {
                this.addErrorMessage(dataEntity, String.format(bizResource.getInbExpiredateCheck(), loanEntry.getInt("seq")));
            }
            BigDecimal drawamount = loanEntry.getBigDecimal("drawamount");
            BigDecimal repayAmount = loanEntry.getBigDecimal("repayamount");
            if (repayAmount.compareTo(BigDecimal.ZERO) > 0 && repayAmount.compareTo(drawamount) > 0) {
                this.addErrorMessage(dataEntity, String.format(bizResource.getInbRepayamountCheck(), loanEntry.getInt("seq")));
            }
            Date repayDate = loanEntry.getDate("repaydate");
            if (repayAmount.compareTo(BigDecimal.ZERO) > 0) {
                if (repayDate == null) {
                    this.addErrorMessage(dataEntity, String.format(bizResource.getInbRepayadateNotNull(), loanEntry.getInt("seq")));
                } else if (loadDate != null && DateUtils.getDiffDays((Date)loadDate, (Date)repayDate) <= 1) {
                    this.addErrorMessage(dataEntity, String.format(bizResource.getInbRepayadateCheck(), loanEntry.getInt("seq")));
                }
            }
            if (EmptyUtil.isEmpty((BigDecimal)repayAmount) && EmptyUtil.isNoEmpty((Object)repayDate)) {
                this.addErrorMessage(dataEntity, String.format(bizResource.getRepayInfoCannotAllnull(), loanEntry.getInt("seq")));
            }
            BigDecimal payinterestamount = loanEntry.getBigDecimal("payinterestamount");
            Date endinstDate = loanEntry.getDate("endinstdate");
            if (EmptyUtil.isEmpty((BigDecimal)payinterestamount) && EmptyUtil.isNoEmpty((Object)endinstDate)) {
                this.addErrorMessage(dataEntity, String.format(bizResource.getpayIntInfoCannotAllnull(), loanEntry.getInt("seq")));
            }
            if (payinterestamount.compareTo(BigDecimal.ZERO) > 0) {
                if (endinstDate == null) {
                    this.addErrorMessage(dataEntity, String.format(bizResource.getInbEndinstdateNotNull(), loanEntry.getInt("seq")));
                } else if (loadDate != null && DateUtils.getDiffDays((Date)loadDate, (Date)endinstDate) < 1) {
                    this.addErrorMessage(dataEntity, String.format(bizResource.getInbEndinstdateCheck(), loanEntry.getInt("seq")));
                }
            }
            if ((endPreInstDate = loanEntry.getDate("endpreinstdate")) != null) {
                if (endinstDate != null && DateUtils.getDiffDays((Date)endinstDate, (Date)endPreInstDate) < 1) {
                    this.addErrorMessage(dataEntity, String.format(bizResource.getInbEndpreinstdateCheck(), loanEntry.getInt("seq")));
                } else if (loadDate != null && DateUtils.getDiffDays((Date)loadDate, (Date)endPreInstDate) < 1) {
                    this.addErrorMessage(dataEntity, String.format(bizResource.getInbEndpreinstdateLdcheck(), loanEntry.getInt("seq")));
                }
            }
            boolean isLoanExtend = loanEntry.getBoolean("isloanextend");
            Date extExpireDate = loanEntry.getDate("loanexpiredate");
            Date extRateAjustDate = loanEntry.getDate("extrateajustdate");
            Boolean isextend = initBill.getBoolean("isextend");
            String exRateAdjustStyle = initBill.getString("exrateadjuststyle");
            String extInterestType = initBill.getString("renewalinteresttype");
            boolean isFloatExt = InterestTypeEnum.FLOAT.getValue().equals(extInterestType);
            if (isextend.booleanValue() && isLoanExtend && expireDate != null) {
                if (EmptyUtil.isEmpty((Object)extExpireDate)) {
                    this.addErrorMessage(dataEntity, String.format(bizResource.getInbLoanexpiredateNotnull(), loanEntry.getInt("seq")));
                } else if (EmptyUtil.isNoEmpty((Object)extExpireDate) && extExpireDate.compareTo(expireDate) < 0) {
                    this.addErrorMessage(dataEntity, String.format(bizResource.getInbLoanexpiredateCheck(), loanEntry.getInt("seq")));
                } else if (isFloatExt && RateAdjustStyleEnum.CYCLE.getValue().equals(exRateAdjustStyle) && EmptyUtil.isEmpty((Object)extRateAjustDate)) {
                    this.addErrorMessage(dataEntity, String.format(bizResource.getInitRateadjustDateNotNull(), loanEntry.getInt("seq")));
                } else if (isFloatExt && RateAdjustStyleEnum.CYCLE.getValue().equals(exRateAdjustStyle) && (extRateAjustDate.before(expireDate) || extRateAjustDate.after(extExpireDate))) {
                    this.addErrorMessage(dataEntity, String.format(bizResource.getInitRateAdjustDatCheck(), loanEntry.getInt("seq")));
                }
            }
            this.validateRepaySubEntry(dataEntity, loanEntry, isextend);
            loanTotalAmt = loanTotalAmt.add(drawamount);
            if (!initBill.getBoolean("iscycleloan")) continue;
            loanTotalAmt = loanTotalAmt.subtract(repayAmount);
        }
        BigDecimal amount = initBill.getBigDecimal("amount");
        if (loanTotalAmt.compareTo(amount) > 0) {
            this.addErrorMessage(dataEntity, bizResource.getLbDrawamountChecksum());
        }
    }

    private void validateRepaySubEntry(ExtendedDataEntity dataEntity, DynamicObject loanEntry, Boolean isextend) {
        String repaymentway = dataEntity.getDataEntity().getString("repaymentway");
        if (RepaymentWayEnum.debx.getValue().equals(repaymentway)) {
            return;
        }
        DynamicObjectCollection repaySubEntrys = loanEntry.getDynamicObjectCollection("repaysubentry");
        BigDecimal entryDrawAmt = loanEntry.getBigDecimal("drawamount");
        BigDecimal entryrepayAmt = loanEntry.getBigDecimal("repayamount");
        AbstractBizResource cfmBizResource = new BizResourceFactory().getBizResource(dataEntity.getDataEntity().getString("datasource"));
        if (entryDrawAmt != null && entryDrawAmt.compareTo(entryrepayAmt) > 0 && EmptyUtil.isEmpty((DynamicObjectCollection)repaySubEntrys)) {
            this.addErrorMessage(dataEntity, String.format(cfmBizResource.getInbRepaysubentryNotnull(), loanEntry.getInt("seq")));
            return;
        }
        String repaymentWay = dataEntity.getDataEntity().getString("repaymentway");
        boolean isLoanExtend = loanEntry.getBoolean("isloanextend");
        Date loanExpireDate = loanEntry.getDate("loanexpiredate");
        Date loadDate = loanEntry.getDate("loaddate");
        Date expireDate = loanEntry.getDate("expiredate");
        if (isextend.booleanValue() && isLoanExtend && loanExpireDate != null) {
            expireDate = loanExpireDate;
        }
        Date compareDate = null;
        BigDecimal repayTotalAmt = BigDecimal.ZERO;
        for (DynamicObject repaySubEntry : repaySubEntrys) {
            Date exRepaymentDate = repaySubEntry.getDate("exrepaymentdate");
            BigDecimal exdrawamount = repaySubEntry.getBigDecimal("exdrawamount");
            if (exRepaymentDate == null) {
                this.addErrorMessage(dataEntity, String.format(cfmBizResource.getInbExrepaymentdateNotnull(), loanEntry.getInt("seq"), repaySubEntry.getInt("seq")));
            }
            if (exdrawamount.compareTo(BigDecimal.ZERO) == 0 && !RepaymentWayEnum.debx.getValue().equals(repaymentWay)) {
                this.addErrorMessage(dataEntity, String.format(cfmBizResource.getInbExdrawamountNotnull(), loanEntry.getInt("seq"), repaySubEntry.getInt("seq")));
            }
            if (loadDate != null && expireDate != null && exRepaymentDate != null && (DateUtils.getDiffDays((Date)loadDate, (Date)exRepaymentDate) <= 1 || DateUtils.getDiffDays((Date)expireDate, (Date)exRepaymentDate) > 1)) {
                this.addErrorMessage(dataEntity, String.format(cfmBizResource.getInbExrepaymentdateCheck(), loanEntry.getInt("seq"), repaySubEntry.getInt("seq"), DateUtils.formatString((Date)loadDate, (String)"yyyy-MM-dd"), DateUtils.formatString((Date)expireDate, (String)"yyyy-MM-dd")));
            }
            if (compareDate == null && exRepaymentDate != null) {
                compareDate = exRepaymentDate;
            } else if (exRepaymentDate != null && DateUtils.getDiffDays((Date)compareDate, (Date)exRepaymentDate) <= 1) {
                this.addErrorMessage(dataEntity, String.format(cfmBizResource.getInbExrepaymentdateMax(), loanEntry.getInt("seq"), repaySubEntry.getInt("seq"), DateUtils.formatString((Date)compareDate, (String)"yyyy-MM-dd")));
            }
            repayTotalAmt = repayTotalAmt.add(exdrawamount);
        }
        BigDecimal drawamount = loanEntry.getBigDecimal("drawamount");
        if (repayTotalAmt.compareTo(drawamount) != 0 && !RepaymentWayEnum.debx.getValue().equals(repaymentWay)) {
            this.addErrorMessage(dataEntity, String.format(cfmBizResource.getInbExdrawamountCheck(), loanEntry.getInt("seq")));
        }
    }
}

